/**
 * @file CcDbusIfCreateProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy work item.
 */

#ifndef _CC_DBUS_IF_CREATE_PROXY_ITEM_H_
#define _CC_DBUS_IF_CREATE_PROXY_ITEM_H_

#include "IWorkItem.h"

namespace ccdbusif {

// class forward declarations
class ICcDbusIfCreateProxy;

/**
 *
 */
class CcDbusIfCreateProxyWorkItem : public IWorkItem
{
public:
   CcDbusIfCreateProxyWorkItem(ICcDbusIfCreateProxy* creator);
   virtual ~CcDbusIfCreateProxyWorkItem();
   virtual void processWorkItem(void);

protected:
   CcDbusIfCreateProxyWorkItem();

private:
   ICcDbusIfCreateProxy* _proxyCreator;
};

} //ccdbusif

#endif //_CC_DBUS_IF_CREATE_PROXY_ITEM_H_
