/**
 * @file CcDbusIfController.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller.
 *
 * @copyright (C) 2015-2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for CcDbusIf.
 */

#ifndef _CC_DBUS_IF_CONTROLLER_H_
#define _CC_DBUS_IF_CONTROLLER_H_

#include "CcDbusIfTypes.h"
#include "ICcDbusIfController.h"
#include "ICcDbusIfControllerDestroyAllProxies.h"
#include "ICcDbusIfControllerClient.h"
#include "IReceiveLocalEventMessage.h"
#include "ICcDbusIfControllerConnMan.h"
#include "ICcDbusIfControllerEcNr.h"
#include "ICcDbusIfControllerEvolutionGenivi.h"
#include "ICcDbusIfControllerObjectManager.h"
#include "ICcDbusIfControllerIntrospectable.h"
#include "ICcDbusIfControllerPropertiesGetAll.h"
#include "ICcDbusIfControllerWbl.h"
#include "CcDbusIfWorkItemQueue.h"

#include "FwSemaphore.h"
#include "FwLock.h"

namespace ccdbusif {

// class forward declarations
class ISendLocalEventMessage;
class CcDbusIfLauncher;
class ICcDbusIfDestroyProxy;
class IDestroyAllProxies;

//ConnMan DBUS interface:
class IConnManDbusManagerSendRequestIf;
class IConnManDbusServiceSendRequestIf;
class IConnManDbusTechnologySendRequestIf;

// EcNr DBUS interface:
class IEcNrDbusServiceSendRequestIf;

// Evolution Genivi DBUS interface:
class IEvolutionGeniviDbusAdapterSendRequestIf;
class IEvolutionGeniviDbusDeviceSendRequestIf;
class IEvolutionGeniviDbusAgentManagerSendRequestIf;
class IEvolutionGeniviDbusDMSendRequestIf;
class IEvolutionGeniviDbusServiceSendRequestIf;
class IEvolutionGeniviDbusTraceSendRequestIf;
class IEvolutionGeniviDbusGeniviTraceSendRequestIf;
class IEvolutionGeniviDbusAgentSendRequestIf;
class IEvolutionGeniviDbusDidSendRequestIf;
class IEvolutionGeniviDbusSppSendRequestIf;
class IEvolutionGeniviDbusObexClientSendRequestIf;
class IEvolutionGeniviDbusObexSessionSendRequestIf;
class IEvolutionGeniviDbusObexTransferSendRequestIf;
class IEvolutionGeniviDbusHfpCallVolumeSendRequestIf;
class IEvolutionGeniviDbusHfpHandsfreeSendRequestIf;
class IEvolutionGeniviDbusHfpManagerSendRequestIf;
class IEvolutionGeniviDbusHfpModemSendRequestIf;
class IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf;
class IEvolutionGeniviDbusHfpNetworkRegistrationSendRequestIf;
class IEvolutionGeniviDbusHfpSiriSendRequestIf;
class IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf;
class IEvolutionGeniviDbusHfpVoiceCallSendRequestIf;
class IEvolutionGeniviDbusSerialSendRequestIf;
class IEvolutionGeniviDbusLEAdapterSendRequestIf;
class IEvolutionGeniviDbusLEDeviceSendRequestIf;
class IEvolutionGeniviDbusLESeamlessPairingSendRequestIf;

// ObjectManager DBUS interface:
class IOrgFreedesktopDbusObjectManagerSendRequestIf;

// Introspectable DBUS interface:
class IIntrospectableDbusSendRequestIf;

// PropertiesGetAll DBUS interface:
class IPropertiesGetAllDbusSendRequestIf;

// WBL DBUS interface:
class IWblDbusLastIntendedModeSendRequestIf;
class IWblDbusConflictManagementSendRequestIf;
class IWblDbusWifiSetupSendRequestIf;

/**
 *
 */
class CcDbusIfController :
   public ICcDbusIfController,
   public ICcDbusIfControllerDestroyAllProxies,
   public ICcDbusIfControllerClient,
   public IReceiveLocalEventMessage,
   public ICcDbusIfControllerConnMan,
   public ICcDbusIfControllerEcNr,
   public ICcDbusIfControllerEvolutionGenivi,
   public ICcDbusIfControllerObjectManager,
   public ICcDbusIfControllerIntrospectable,
   public ICcDbusIfControllerPropertiesGetAll,
   public ICcDbusIfControllerWbl
{
public:
   CcDbusIfController();
   virtual ~CcDbusIfController();

   // ICcDbusIfController
   virtual void start(void);
   virtual void stop(void);
   virtual void startDbusLauncher(const LaunchType launchType, const ::std::string& configFile);
   virtual void stopDbusLauncher(void);
   virtual void prepareStop(void);
   virtual unsigned int getCallbackId(void);
   virtual ICcDbusIfControllerClient* getCcDbusIfControllerClient(void);
   virtual ICcDbusIfControllerConnMan* getCcDbusIfControllerConnMan(void);
   virtual ICcDbusIfControllerEcNr* getCcDbusIfControllerEcNr(void);
   virtual ICcDbusIfControllerEvolutionGenivi* getCcDbusIfControllerEvolutionGenivi(void);
   virtual ICcDbusIfControllerObjectManager* getCcDbusIfControllerObjectManager(void);
   virtual ICcDbusIfControllerIntrospectable* getCcDbusIfControllerIntrospectable(void);
   virtual ICcDbusIfControllerPropertiesGetAll* getCcDbusIfControllerPropertiesGetAll(void);
   virtual ICcDbusIfControllerWbl* getCcDbusIfControllerWbl(void);

   // ICcDbusIfControllerDestroyAllProxies
   virtual void destroyAllProxies(void);

   // ICcDbusIfControllerClient
   virtual void pushWorkItem(IWorkItem* workItem);
   virtual void destroyAllBluetoothRuntimeProxies(void);

   // IReceiveLocalEventMessage
   virtual void handleReceiveLocalEvent(const unsigned int event);

   // ICcDbusIfControllerConnMan
   virtual IConnManDbusManagerSendRequestIf* getConnManManagerProxy(void);
   virtual IConnManDbusServiceSendRequestIf* getConnManServiceProxy(void);
   virtual IConnManDbusTechnologySendRequestIf* getConnManTechnologyProxy(void);

   // ICcDbusIfControllerEcNr
   virtual IEcNrDbusServiceSendRequestIf* getEcNrServiceProxy(void);

   // ICcDbusIfControllerEvolutionGenivi
   virtual IEvolutionGeniviDbusAdapterSendRequestIf* getEvolutionGeniviAdapterProxy(void);
   virtual IEvolutionGeniviDbusDeviceSendRequestIf* getEvolutionGeniviDeviceProxy(void);
   virtual IEvolutionGeniviDbusAgentManagerSendRequestIf* getEvolutionGeniviAgentManagerProxy(void);
   virtual IEvolutionGeniviDbusDMSendRequestIf* getEvolutionGeniviDMProxy(void);
   virtual IEvolutionGeniviDbusServiceSendRequestIf* getEvolutionGeniviServiceProxy(void);
   virtual IEvolutionGeniviDbusTraceSendRequestIf* getEvolutionGeniviTraceProxy(void);
   virtual IEvolutionGeniviDbusGeniviTraceSendRequestIf* getEvolutionGeniviGeniviTraceProxy(void);
   virtual IEvolutionGeniviDbusAgentSendRequestIf* getEvolutionGeniviAgentStub(void);
   virtual IEvolutionGeniviDbusDidSendRequestIf* getEvolutionGeniviDidProxy(void);
   virtual IEvolutionGeniviDbusSppSendRequestIf* getEvolutionGeniviSppProxy(void);
   virtual IEvolutionGeniviDbusObexClientSendRequestIf* getEvolutionGeniviObexClientProxy(void);
   virtual IEvolutionGeniviDbusObexSessionSendRequestIf* getEvolutionGeniviObexSessionProxy(void);
   virtual IEvolutionGeniviDbusObexTransferSendRequestIf* getEvolutionGeniviObexTransferProxy(void);
   virtual IEvolutionGeniviDbusHfpCallVolumeSendRequestIf* getEvolutionGeniviHfpCallVolumeProxy(void);
   virtual IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* getEvolutionGeniviHfpHandsfreeProxy(void);
   virtual IEvolutionGeniviDbusHfpManagerSendRequestIf* getEvolutionGeniviHfpManagerProxy(void);
   virtual IEvolutionGeniviDbusHfpModemSendRequestIf* getEvolutionGeniviHfpModemProxy(void);
   virtual IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf* getEvolutionGeniviHfpNetworkOperatorProxy(void);
   virtual IEvolutionGeniviDbusHfpNetworkRegistrationSendRequestIf* getEvolutionGeniviHfpNetworkRegistrationProxy(void);
   virtual IEvolutionGeniviDbusHfpSiriSendRequestIf* getEvolutionGeniviHfpSiriProxy(void);
   virtual IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf* getEvolutionGeniviHfpVoiceCallManagerProxy(void);
   virtual IEvolutionGeniviDbusHfpVoiceCallSendRequestIf* getEvolutionGeniviHfpVoiceCallProxy(void);
   virtual IEvolutionGeniviDbusSerialSendRequestIf* getEvolutionGeniviSerialProxy(void);
   virtual IEvolutionGeniviDbusLEAdapterSendRequestIf* getEvolutionGeniviLEAdapterProxy(void);
   virtual IEvolutionGeniviDbusLEDeviceSendRequestIf* getEvolutionGeniviLEDeviceProxy(void);
   virtual IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* getEvolutionGeniviLESeamlessPairingProxy(void);

   // ICcDbusIfControllerObjectManager
   virtual IOrgFreedesktopDbusObjectManagerSendRequestIf* getObjectManagerProxy(void);

   // ICcDbusIfControllerIntrospectable
   virtual IIntrospectableDbusSendRequestIf* getIntrospectableProxy(void);

   // ICcDbusIfControllerPropertiesGetAll
   virtual IPropertiesGetAllDbusSendRequestIf* getPropertiesGetAllProxy(void);

   // ICcDbusIfControllerWbl
   virtual IWblDbusLastIntendedModeSendRequestIf* getWblLastIntendedModeProxy(void);
   virtual IWblDbusConflictManagementSendRequestIf* getWblConflictManagementProxy(void);
   virtual IWblDbusWifiSetupSendRequestIf* getWblWifiSetupProxy(void);

protected:
   // copy constructor => must not be used
   CcDbusIfController(const CcDbusIfController& rhs);
   // assignment operator => must not be used
   CcDbusIfController& operator=(const CcDbusIfController& rhs);

private:
   CcDbusIfWorkItemQueue _workItemQueue;
   ISendLocalEventMessage* _localEventSender;
   CcDbusIfLauncher* _launcher;
   ::std::vector< ICcDbusIfDestroyProxy* > _destroyProxyList;
   ::std::vector< IDestroyAllProxies* > _destroyAllProxiesList;
   ::std::vector< ICcDbusIfDestroyProxy* > _destroyBluetoothRuntimeProxyList;
   ::std::vector< IDestroyAllProxies* > _destroyAllBluetoothRuntimeProxiesList;
   ::fw::Semaphore _destroyProxiesSem;
   ::fw::Semaphore _startupSem;
   LockForeverAndNonReentrant _callbackIdLock;
   unsigned int _callbackId;

   // ConnMan DBUS interface:
   IConnManDbusManagerSendRequestIf* _connManManagerProxy;
   IConnManDbusServiceSendRequestIf* _connManServiceProxy;
   IConnManDbusTechnologySendRequestIf* _connManTechnologyProxy;

   // EcNr DBUS interface:
   IEcNrDbusServiceSendRequestIf* _ecnrServiceProxy;

   // Evolution Genivi DBUS interface:
   IEvolutionGeniviDbusAdapterSendRequestIf* _evolutionGeniviAdapterProxy;
   IEvolutionGeniviDbusDeviceSendRequestIf* _evolutionGeniviDeviceProxy;
   IEvolutionGeniviDbusAgentManagerSendRequestIf* _evolutionGeniviAgentManagerProxy;
   IEvolutionGeniviDbusDMSendRequestIf* _evolutionGeniviDMProxy;
   IEvolutionGeniviDbusServiceSendRequestIf* _evolutionGeniviServiceProxy;
   IEvolutionGeniviDbusTraceSendRequestIf* _evolutionGeniviTraceProxy;
   IEvolutionGeniviDbusGeniviTraceSendRequestIf* _evolutionGeniviGeniviTraceProxy;
   IEvolutionGeniviDbusAgentSendRequestIf* _evolutionGeniviAgentStub;
   IEvolutionGeniviDbusDidSendRequestIf* _evolutionGeniviDidProxy;
   IEvolutionGeniviDbusSppSendRequestIf* _evolutionGeniviSppProxy;
   IEvolutionGeniviDbusObexClientSendRequestIf* _evolutionGeniviObexClientProxy;
   IEvolutionGeniviDbusObexSessionSendRequestIf* _evolutionGeniviObexSessionProxy;
   IEvolutionGeniviDbusObexTransferSendRequestIf* _evolutionGeniviObexTransferProxy;
   IEvolutionGeniviDbusHfpCallVolumeSendRequestIf* _evolutionGeniviHfpCallVolumeProxy;
   IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* _evolutionGeniviHfpHandsfreeProxy;
   IEvolutionGeniviDbusHfpManagerSendRequestIf* _evolutionGeniviHfpManagerProxy;
   IEvolutionGeniviDbusHfpModemSendRequestIf* _evolutionGeniviHfpModemProxy;
   IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf* _evolutionGeniviHfpNetworkOperatorProxy;
   IEvolutionGeniviDbusHfpNetworkRegistrationSendRequestIf* _evolutionGeniviHfpNetworkRegistrationProxy;
   IEvolutionGeniviDbusHfpSiriSendRequestIf* _evolutionGeniviHfpSiriProxy;
   IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf* _evolutionGeniviHfpVoiceCallManagerProxy;
   IEvolutionGeniviDbusHfpVoiceCallSendRequestIf* _evolutionGeniviHfpVoiceCallProxy;
   IEvolutionGeniviDbusSerialSendRequestIf* _evolutionGeniviSerialProxy;
   IEvolutionGeniviDbusLEAdapterSendRequestIf* _evolutionGeniviLEAdapterProxy;
   IEvolutionGeniviDbusLEDeviceSendRequestIf* _evolutionGeniviLEDeviceProxy;
   IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* _evolutionGeniviLESeamlessPairingProxy;

   // ObjectManager DBUS interface:
   IOrgFreedesktopDbusObjectManagerSendRequestIf* _objectManagerProxy;

   // Introspectable DBUS interface:
   IIntrospectableDbusSendRequestIf* _introspectableProxy;

   // PropertiesGetAll DBUS interface:
   IPropertiesGetAllDbusSendRequestIf* _propertiesGetAllProxy;

   // WBL DBUS interface:
   IWblDbusLastIntendedModeSendRequestIf* _lastIntendedModeProxy;
   IWblDbusConflictManagementSendRequestIf* _conflictManagementProxy;
   IWblDbusWifiSetupSendRequestIf* _wifiSetupProxy;
};

} //ccdbusif

#endif //_CC_DBUS_IF_CONTROLLER_H_
