/**
 * @file ConnManDbusTechnologyFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan instance factory for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan instance factory for Technology.
 */

#include "ConnManDbusTechnologyFactory.h"
#include "ConnManDbusTechnologyProxyIf.h"

namespace ccdbusif {

ConnManDbusTechnologyFactory::ConnManDbusTechnologyFactory()
{
   _proxy = NULL;
}

ConnManDbusTechnologyFactory::~ConnManDbusTechnologyFactory()
{
   _proxy = NULL;
}

ConnManDbusTechnologyFactory& ConnManDbusTechnologyFactory::getInstance(void)
{
   static ConnManDbusTechnologyFactory factory;
   return factory;
}

IConnManDbusTechnologySendRequestIf* ConnManDbusTechnologyFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      ConnManDbusTechnologyProxyIf* tmp = new ConnManDbusTechnologyProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void ConnManDbusTechnologyFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void ConnManDbusTechnologyFactory::setProxyForTesting(IConnManDbusTechnologySendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
