/**
 * @file IConnManDbusTechnologySendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Send Request Interface for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for ConnMan DBUS send request for Technology.
 */

#ifndef _I_CONN_MAN_DBUS_TECHNOLOGY_SEND_REQUEST_IF_H_
#define _I_CONN_MAN_DBUS_TECHNOLOGY_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IConnManDbusTechnologyCallbackIf;

/**
 * Send request interface class for Technology.
 */
class IConnManDbusTechnologySendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnManDbusTechnologySendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IConnManDbusTechnologyCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Handle signal for created technology.
    *
    * @param[in] objPath: object path of created technology
    */
   virtual void technologyCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed technology.
    *
    * @param[in] objPath: object path of removed technology
    */
   virtual void technologyRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of technology
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;

};

} //ccdbusif

#endif //_I_CONN_MAN_DBUS_TECHNOLOGY_SEND_REQUEST_IF_H_
