/**
 * @file IConnManDbusTechnologyCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Callback Interface for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for ConnMan DBUS callback for Technology.
 */

#ifndef _I_CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_
#define _I_CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_

#include "net/connman/TechnologyProxy.h"

using namespace ::net::connman::Technology;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Technology.
 */
class IConnManDbusTechnologyCallbackIf :
   // from net/connman/TechnologyProxy.h --- start
   public GetPropertiesCallbackIF,
   public PropertyChangedCallbackIF
   // from net/connman/TechnologyProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnManDbusTechnologyCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // net/connman/TechnologyProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // net/connman/TechnologyProxy implementation --- end
};

} //ccdbusif

#endif //_I_CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_
