/**
 * @file IConnManDbusManagerSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Send Request Interface for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for ConnMan DBUS send request for Manager.
 */

#ifndef _I_CONN_MAN_DBUS_MANAGER_SEND_REQUEST_IF_H_
#define _I_CONN_MAN_DBUS_MANAGER_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IConnManDbusManagerCallbackIf;

/**
 * Send request interface class for Manager.
 */
class IConnManDbusManagerSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnManDbusManagerSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IConnManDbusManagerCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Send GetProperties Request.
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(void) = 0;

   /**
    * Send GetTechnologies Request.
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetTechnologiesRequest(void) = 0;

   /**
    * Send GetServices Request.
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetServicesRequest(void) = 0;

};

} //ccdbusif

#endif //_I_CONN_MAN_DBUS_MANAGER_SEND_REQUEST_IF_H_
