/**
 * @file IConnManDbusManagerCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Callback Interface for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for ConnMan DBUS callback for Manager.
 */

#ifndef _I_CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_
#define _I_CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_

#include "net/connman/ManagerProxy.h"

using namespace ::net::connman::Manager;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Manager.
 */
class IConnManDbusManagerCallbackIf :
   // from net/connman/ManagerProxy.h --- start
   public GetPropertiesCallbackIF,
   public GetTechnologiesCallbackIF,
   public GetServicesCallbackIF,
   public PropertyChangedCallbackIF,
   public TechnologyAddedCallbackIF,
   public TechnologyRemovedCallbackIF,
   public ServicesChangedCallbackIF
   // from net/connman/ManagerProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnManDbusManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // net/connman/ManagerProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onGetTechnologiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesError >& error) = 0;

   virtual void onGetTechnologiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesResponse >& response) = 0;

   virtual void onGetServicesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesError >& error) = 0;

   virtual void onGetServicesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;

   virtual void onTechnologyAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedError >& error) = 0;

   virtual void onTechnologyAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedSignal >& signal) = 0;

   virtual void onTechnologyRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedError >& error) = 0;

   virtual void onTechnologyRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedSignal >& signal) = 0;

   virtual void onServicesChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedError >& error) = 0;

   virtual void onServicesChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedSignal >& signal) = 0;
   // net/connman/ManagerProxy implementation --- end
};

} //ccdbusif

#endif //_I_CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_
