/**
 * @file ConnManDbusServiceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Proxy for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS proxy for Service.
 */

#ifndef _CONN_MAN_DBUS_SERVICE_PROXY_IF_H_
#define _CONN_MAN_DBUS_SERVICE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IConnManDbusServiceSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "net/connman/ServiceProxy.h"

using namespace ::net::connman::Service;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IConnManDbusServiceCallbackIf;

/**
 * Service proxy class for ConnMan interface.
 */
class ConnManDbusServiceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IConnManDbusServiceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   ConnManDbusServiceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~ConnManDbusServiceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IConnManDbusServiceCallbackIf* callbackIf, bool enableProxy);

   virtual void serviceCreated(const ::std::string& objPath);

   virtual void serviceRemoved(const ::std::string& objPath, const bool destroyDirectly = false);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IConnManDbusServiceProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendConnectRequest(const ::std::string& objPath);

   virtual act_t sendDisconnectRequest(const ::std::string& objPath);
   // IConnManDbusServiceProxyIf implementation --- end

protected:
   ConnManDbusServiceProxyIf();

private:
   ProxyManager< ServiceProxy > _serviceProxy;
   IConnManDbusServiceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_CONN_MAN_DBUS_SERVICE_PROXY_IF_H_
