/**
 * @file ConnManDbusServiceProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Properties for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Properties for Service.
 */

#ifndef _CONN_MAN_DBUS_SERVICE_PROPERTIES_H_
#define _CONN_MAN_DBUS_SERVICE_PROPERTIES_H_

#include "DbusProperties.h"
#include "ConnManDbusTypes.h"

namespace ccdbusif {
namespace connman {

/**
 * Service properties class for ConnMan interface.
 */
class ConnManDbusServiceProperties : public DbusProperties
{
public:
   ConnManDbusServiceProperties();
   virtual ~ConnManDbusServiceProperties();

   inline const ::std::map< std::string, int >* getState2EnumListPtr(void) const { return &_state2EnumList; }
   inline const ::std::map< int, const std::string* >* getState2StringListPtr(void) const { return &_enum2StateList; }
   inline const ::std::map< std::string, int >* getType2EnumListPtr(void) const { return &_type2EnumList; }
   inline const ::std::map< int, const std::string* >* getType2StringListPtr(void) const { return &_enum2TypeList; }

   ServiceProperty getProperty2Enum(const ::std::string& value) const;
   ServiceState getState2Enum(const ::std::string& value) const;
   ServiceType getType2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const ServiceProperty value) const;
   const ::std::string& getProperty2StringTrace(const ServiceProperty value) const;
   const ::std::string& getState2String(const ServiceState value) const;
   const ::std::string& getState2StringTrace(const ServiceState value) const;
   const ::std::string& getType2String(const ServiceType value) const;
   const ::std::string& getType2StringTrace(const ServiceType value) const;

private:
   const ::std::string _propertyType;
   const ::std::string _propertySecurity;
   const ::std::string _propertyState;
   const ::std::string _propertyError;
   const ::std::string _propertyStrength;
   const ::std::string _propertyFavorite;
   const ::std::string _propertyImmutable;
   const ::std::string _propertyAutoConnect;
   const ::std::string _propertyName;
   const ::std::string _propertyRoaming;
   const ::std::string _propertyEthernet;
   const ::std::string _propertyIPv4;
   const ::std::string _propertyIPv4Configuration;
   const ::std::string _propertyIPv6;
   const ::std::string _propertyIPv6Configuration;
   const ::std::string _propertyNameservers;
   const ::std::string _propertyNameserversConfiguration;
   const ::std::string _propertyTimeservers;
   const ::std::string _propertyTimeserversConfiguration;
   const ::std::string _propertyDomains;
   const ::std::string _propertyDomainsConfiguration;
   const ::std::string _propertyProxy;
   const ::std::string _propertyProxyConfiguration;
   const ::std::string _propertyProvider;
   // -------------------------------------------------------------------------
   const ::std::string _propertyEthernetMethod;
   const ::std::string _propertyEthernetInterface;
   const ::std::string _propertyEthernetAddress;
   const ::std::string _propertyEthernetMtu;
   const ::std::string _propertyEthernetSpeed;
   const ::std::string _propertyEthernetDuplex;
   // -------------------------------------------------------------------------
   const ::std::string _propertyIpv4Method;
   const ::std::string _propertyIpv4Address;
   const ::std::string _propertyIpv4Netmask;
   const ::std::string _propertyIpv4Gateway;
   // -------------------------------------------------------------------------
   const ::std::string _propertyIpv6Method;
   const ::std::string _propertyIpv6Address;
   const ::std::string _propertyIpv6PrefixLength;
   const ::std::string _propertyIpv6Gateway;
   const ::std::string _propertyIpv6Privacy;
   // -------------------------------------------------------------------------
   const ::std::string _propertyProxyMethod;
   const ::std::string _propertyProxyURL;
   const ::std::string _propertyProxyServers;
   const ::std::string _propertyProxyExcludes;
   // -------------------------------------------------------------------------
   const ::std::string _propertyProviderHost;
   const ::std::string _propertyProviderDomain;
   const ::std::string _propertyProviderName;
   const ::std::string _propertyProviderType;

   const ::std::string _stateIdle;
   const ::std::string _stateFailure;
   const ::std::string _stateAssociation;
   const ::std::string _stateConfiguration;
   const ::std::string _stateReady;
   const ::std::string _stateDisconnect;
   const ::std::string _stateOnline;

   const ::std::string _typeSystem;
   const ::std::string _typeEthernet;
   const ::std::string _typeWifi;
   const ::std::string _typeBluetooth;
   const ::std::string _typeCellular;
   const ::std::string _typeGps;
   const ::std::string _typeVpn;
   const ::std::string _typeGadget;

   ::std::map< std::string, int > _state2EnumList; /**< map with supported value for state + enum pairs */
   ::std::map< int, const std::string* > _enum2StateList; /**< map with enum + supported value for state pairs */

   ::std::map< std::string, int > _type2EnumList; /**< map with supported value for Type + enum pairs */
   ::std::map< int, const std::string* > _enum2TypeList; /**< map with enum + supported value for Type pairs */
};

} //connman
} //ccdbusif

#endif //_CONN_MAN_DBUS_SERVICE_PROPERTIES_H_
