/**
 * @file ConnManDbusManagerProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Properties for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Properties for Manager.
 */

#ifndef _CONN_MAN_DBUS_MANAGER_PROPERTIES_H_
#define _CONN_MAN_DBUS_MANAGER_PROPERTIES_H_

#include "DbusProperties.h"
#include "ConnManDbusTypes.h"

namespace ccdbusif {
namespace connman {

/**
 * Manager properties class for ConnMan interface.
 */
class ConnManDbusManagerProperties : public DbusProperties
{
public:
   ConnManDbusManagerProperties();
   virtual ~ConnManDbusManagerProperties();

   ManagerProperty getProperty2Enum(const ::std::string& value) const;
   ManagerState getState2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const ManagerProperty value) const;
   const ::std::string& getProperty2StringTrace(const ManagerProperty value) const;
   const ::std::string& getState2String(const ManagerState value) const;

private:
   const ::std::string _propertyState;
   const ::std::string _propertyOfflineMode;
   const ::std::string _propertySessionMode;

   const ::std::string _stateIdle;
   const ::std::string _stateOffline;
   const ::std::string _stateReady;
   const ::std::string _stateOnline;

   ::std::map< std::string, int > _state2EnumList; /**< map with supported value for state + enum pairs */
   ::std::map< int, const std::string* > _enum2stateList; /**< map with enum + supported value for state pairs */
};

} //connman
} //ccdbusif

#endif //_CONN_MAN_DBUS_MANAGER_PROPERTIES_H_
