/**
 * @file ConnManDbusInterfaces.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ConnMan DBUS Interfaces.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Interfaces.
 */

#ifndef _CONN_MAN_DBUS_INTERFACES_H_
#define _CONN_MAN_DBUS_INTERFACES_H_

#include "IDbusProperty2EnumMapping.h"
#include "ConnManDbusTypes.h"
#include "ConnManDbusManagerProperties.h"
#include "ConnManDbusServiceProperties.h"
#include "ConnManDbusTechnologyProperties.h"

namespace ccdbusif {
namespace connman {

/**
 * Class for ConnMan DBUS interfaces.
 */
class ConnManDbusInterfaces : public IDbusProperty2EnumMapping
{
public:
   ConnManDbusInterfaces();
   virtual ~ConnManDbusInterfaces();
   virtual void getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const;
   const ::std::string& getInterfaceName(const Interface interface) const;

   inline ManagerProperty getManagerProperty2Enum(const ::std::string& value) const { return (ManagerProperty)_managerProperties.convertString2Enum(value); }
   inline const ::std::string& getManagerProperty2String(const ManagerProperty value) const { return _managerProperties.convertEnum2String((int)value); }

   inline ManagerState getManagerState2Enum(const ::std::string& value) const { return (ManagerState)_managerProperties.getState2Enum(value); }
   inline const ::std::string& getManagerState2String(const ManagerState value) const { return _managerProperties.getState2String((ManagerState)value); }

   inline ServiceProperty getServiceProperty2Enum(const ::std::string& value) const { return (ServiceProperty)_serviceProperties.convertString2Enum(value); }
   inline const ::std::string& getServiceProperty2String(const ServiceProperty value) const { return _serviceProperties.convertEnum2String((int)value); }

   inline ServiceState getServiceState2Enum(const ::std::string& value) const { return (ServiceState)_serviceProperties.getState2Enum(value); }
   inline const ::std::string& getServiceState2String(const ServiceState value) const { return _serviceProperties.getState2String((ServiceState)value); }

   inline ServiceType getServiceType2Enum(const ::std::string& value) const { return (ServiceType)_serviceProperties.getType2Enum(value); }
   inline const ::std::string& getServiceType2String(const ServiceType value) const { return _serviceProperties.getType2String((ServiceType)value); }

   inline TechnologyProperty getTechnologyProperty2Enum(const ::std::string& value) const { return (TechnologyProperty)_technologyProperties.convertString2Enum(value); }
   inline const ::std::string& getTechnologyProperty2String(const TechnologyProperty value) const { return _technologyProperties.convertEnum2String((int)value); }

private:
   const ::std::string _dummy;

   const ::std::string _interfaceManager;
   const ::std::string _interfaceService;
   const ::std::string _interfaceTechnology;

   ConnManDbusManagerProperties _managerProperties;
   ConnManDbusServiceProperties _serviceProperties;
   ConnManDbusTechnologyProperties _technologyProperties;
};

} //connman
} //ccdbusif

#endif //_CONN_MAN_DBUS_INTERFACES_H_
