/**
 * @file DbusProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief DBUS Properties.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details DBUS Properties.
 */

#include "DbusProperties.h"

#include <cstdio>

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DbusProperties.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

const ::std::string DbusProperties::_emptyString = "";
const ::std::string DbusProperties::_dummyString = "";
const int DbusProperties::_dummyEnum = 0;
const ::std::string DbusProperties::_unknownString = "<Unknown>";

DbusProperties::DbusProperties()
{
   // _string2EnumList
   // _enum2StringList
   // _description
}

DbusProperties::DbusProperties(const ::std::string& description)
{
   // _string2EnumList
   // _enum2StringList
   _description = description;
}

DbusProperties::~DbusProperties()
{
   _string2EnumList.clear();
   _enum2StringList.clear();
   _description.clear();
}

int DbusProperties::convertString2Enum(const ::std::string& input, const bool handleError /*= true*/) const
{
   return convertString2Enum(_string2EnumList, input, handleError);
}

const ::std::string& DbusProperties::convertEnum2String(const int input, const bool handleError /*= true*/) const
{
   return convertEnum2String(_enum2StringList, input, handleError);
}

int DbusProperties::convertString2Enum(const ::std::map< std::string, int >& list, const ::std::string& input, const bool handleError /*= true*/) const
{
   ::std::map< std::string, int >::const_iterator it = list.find(input);
   if(list.end() != it)
   {
      return it->second;
   }

   if(true == handleError)
   {
      onString2EnumError(input);
   }

   return _dummyEnum;
}

const ::std::string& DbusProperties::convertEnum2String(const ::std::map< int, const std::string* >& list, const int input, const bool handleError /*= true*/) const
{
   ::std::map< int, const std::string* >::const_iterator it = list.find(input);
   if(list.end() != it)
   {
      if(NULL != it->second)
      {
         return *(it->second);
      }
   }

   if(true == handleError)
   {
      onEnum2StringError(input);
   }

   return _dummyString;
}

void DbusProperties::onString2EnumError(const ::std::string& input) const
{
   ETG_TRACE_ERRMEM((" #CONN: CcDbusIf: onString2EnumError(): proxy=%40s input=%s", _description.c_str(), input.c_str()));
}

void DbusProperties::onEnum2StringError(const int input) const
{
   ETG_TRACE_ERRMEM((" #CONN: CcDbusIf: onEnum2StringError(): proxy=%40s input=%d", _description.c_str(), input));
}

} //ccdbusif
