/**
 * @file CreateProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Proxy Work Item.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation for create proxy work item for CcDbusIf.
 */

#include "CreateProxyWorkItem.h"
#include "ICreateProxy.h"

namespace ccdbusif {

CreateProxyWorkItem::CreateProxyWorkItem(ICreateProxy* creator, const unsigned int callbackId, const ::std::string& objPath /*= ::std::string()*/, const ::std::string& busName /*= ::std::string()*/, const DbusBusType busType /*= BUS_TYPE_SYSTEM*/) :
_creator(creator),
_callbackId(callbackId),
_objPath(objPath),
_busName(busName),
_busType(busType)
{
}

CreateProxyWorkItem::~CreateProxyWorkItem()
{
   _creator = 0;
}

void CreateProxyWorkItem::processWorkItem(void)
{
   if(0 != _creator)
   {
      _creator->handleCreateProxy(_callbackId, _objPath, _busName, _busType);
   }
}

} //ccdbusif
