/**
 * @file BaseDbusProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Base DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class implementation for DBUS proxies.
 */

#include "BaseDbusProxyIf.h"
#include "FwUtils.h"
#include "FwFormattedDataPrint.h"
#include "TraceClasses.h"
#include "FwTrace.h"
#include <cstdio>
#include <cstring>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BaseDbusProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

BaseDbusProxyIf::BaseDbusProxyIf()
{
   _enableProxy = false;
   _controllerClient = NULL;
}

BaseDbusProxyIf::BaseDbusProxyIf(ICcDbusIfControllerClient* client)
{
   _enableProxy = false;
   _controllerClient = client;
}

BaseDbusProxyIf::~BaseDbusProxyIf()
{
   _controllerClient = NULL;
}

void BaseDbusProxyIf::printThreadInfo(const ::std::string& description) const
{
   char buffer[240];
   char threadName[17];
   ::fw::FormattedOutputPid processId(::fw::getProcessId());
   ::fw::FormattedOutputPid threadId(::fw::getThreadId());
   (void)snprintf(buffer, sizeof(buffer), "%s: PID=%s TID=%s NAME=%s", description.c_str(), processId.c_str(), threadId.c_str(), ::fw::getThreadName(threadName, sizeof(threadName)));

   ETG_TRACE_ERR((" ### %s", buffer));
}

} //ccdbusif
