/**
 * @file IWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Work Item Interface.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for work item for CcDbusIf.
 */

#ifndef _I_WORK_ITEM_H_
#define _I_WORK_ITEM_H_

namespace ccdbusif {

/**
 *
 */
class IWorkItem
{
public:
   /**
    * Destructor.
    */
   virtual ~IWorkItem() {}

   /**
    * Process work item function.
    */
   virtual void processWorkItem(void) = 0;
};

} //ccdbusif

#endif //_I_WORK_ITEM_H_
