/**
 * @file ISendLocalEventMessage.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Interface for sending local event message.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for sending local event message.
 */

#ifndef _I_SEND_LOCAL_EVENT_MESSAGE_H_
#define _I_SEND_LOCAL_EVENT_MESSAGE_H_

namespace ccdbusif {

/**
 *
 */
class ISendLocalEventMessage
{
public:
   /**
    * Destructor.
    */
   virtual ~ISendLocalEventMessage() {}

   /**
    * Handle send local event request.
    *
    * @param[in] event: event
    */
   virtual void handleSendLocalEvent(const unsigned int event) = 0;
};

} //ccdbusif

#endif //_I_SEND_LOCAL_EVENT_MESSAGE_H_
