/**
 * @file IDbusProperty2EnumMapping.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief DBUS Property To Enum Mapping.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details DBUS Property To Enum Mapping.
 */

#ifndef _I_DBUS_PROPERTY_2_ENUM_MAPPING_H_
#define _I_DBUS_PROPERTY_2_ENUM_MAPPING_H_

#include <vector>
#include <map>
#include <string>

namespace ccdbusif {

/**
 * DBUS property parser class.
 */
class IDbusProperty2EnumMapping
{
public:
   /**
    * Destructor.
    */
   virtual ~IDbusProperty2EnumMapping() {}

   /**
    * Get property to enum mapping list. To be implemented by child class.
    *
    * @param[out] interfaceList: property to enum mapping list matching the given interfaces
    * @param[in] matchingInterfaces: interfaces to be checked
    */
   virtual void getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const = 0;
};

} //ccdbusif

#endif //_I_DBUS_PROPERTY_2_ENUM_MAPPING_H_
