/**
 * @file ICreateProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create Proxy.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface for creating proxy for CcDbusIf.
 */

#ifndef _I_CREATE_PROXY_H_
#define _I_CREATE_PROXY_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

/**
 *
 */
class ICreateProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~ICreateProxy() {}

   /**
    * Handle create proxy request.
    *
    * @param[in] callbackId: callback id
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
};

} //ccdbusif

#endif //_I_CREATE_PROXY_H_
