/**
 * @file CommonBaseProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Common Base Proxy.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class for proxies.
 */

#ifndef _COMMON_BASE_PROXY_IF_H_
#define _COMMON_BASE_PROXY_IF_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class ICreateProxy;
class IDestroyProxy;

class CommonBaseProxyIf
{
protected:
   CommonBaseProxyIf(ICcDbusIfControllerClient* client);

   CommonBaseProxyIf(const CommonBaseProxyIf& ref);

   CommonBaseProxyIf& operator=(const CommonBaseProxyIf& ref);

   virtual ~CommonBaseProxyIf();

   bool _enableProxy; /**< enable flag */
   ICcDbusIfControllerClient* _controllerClient; /**< controller client */

   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType) = 0;

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType) = 0;

   virtual void internalDestroyAllProxies(void) = 0;

   void processCreateProxy(ICreateProxy* creator, const bool createDirectly, const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void processDestroyProxy(IDestroyProxy* creator, const bool destroyDirectly, const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void printThreadInfo(const ::std::string& description) const;
};

} //ccdbusif

#endif //_COMMON_BASE_PROXY_IF_H_
