/**
 * @file BaseInstanceFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Base Instance Factory.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Base class for instance factory.
 */

#ifndef _BASE_INSTANCE_FACTORY_H_
#define _BASE_INSTANCE_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

namespace ccdbusif {

// class forward declarations
class ICcDbusIfDestroyProxy;

/**
 *
 */
class BaseInstanceFactory
{
public:
   /**
    * Default constructor.
    */
   BaseInstanceFactory();

   /**
    * Destructor.
    */
   virtual ~BaseInstanceFactory();

   /**
    * Get destroy reference.
    *
    * @return = destroy reference
    */
   inline ICcDbusIfDestroyProxy* getDestroyer(void) { return _destroyer; }

protected:
   bool _createdLocally; /**< creator flag */
   ICcDbusIfDestroyProxy* _destroyer; /**< destroy reference */
};

} //ccdbusif

#endif //_BASE_INSTANCE_FACTORY_H_
