/**
 * @file WblStartupWbl.h
 *
 * @par SW-Component
 * State machine for WBL startup
 *
 * @brief Implementation of WBL startup state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of WBL startup state machine.
 */

#ifndef _WBL_STARTUP_WBL_H_
#define _WBL_STARTUP_WBL_H_

#include "IWblStartupRequest.h"
#include "IWblStartupWbl.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace wbl {

/**
 * WBL startup class.
 */
class WblStartupWbl : public IWblStartupRequest, public IWblStartupWbl
{
public:
   /**
    * Default constructor.
    */
   WblStartupWbl();

   /**
    * Destructor.
    */
   virtual ~WblStartupWbl();

   virtual void setCallback(IN IWblStartupCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual IWblStartupRequest* getRequestIf(void);

   virtual void addInterfaces(OUT ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces);

   virtual void updateServiceAvailability(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSWblDbusServiceInterface interface, IN const BTSDbusServiceAvailability availabilityEvent);

private:
   IWblStartupCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   DbusServiceGroupStatus _serviceGroupGeneral; /**< group service status */
   DbusServiceStatus _serviceLastIntendedMode; /**< LastIntendedMode service status */
   DbusServiceStatus _serviceConflictManagement; /**< ConflictManagement service status */
   DbusServiceStatus _serviceObjectManager; /**< ObjectManager service status */
};

} //wbl
} //btstackif

#endif //_WBL_STARTUP_WBL_H_
