/**
 * @file WblLastModeWbl.h
 *
 * @par SW-Component
 * State machine for WBL last mode
 *
 * @brief Implementation of WBL last mode state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of WBL last mode state machine.
 */

#ifndef _WBL_LAST_MODE_WBL_H_
#define _WBL_LAST_MODE_WBL_H_

#include "IWblLastModeRequest.h"
#include "IWblLastModeWbl.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace wbl {

/**
 * WBL last mode class.
 */
class WblLastModeWbl : public IWblLastModeRequest, public IWblLastModeWbl
{
public:
   /**
    * Default constructor.
    */
   WblLastModeWbl();

   /**
    * Destructor.
    */
   virtual ~WblLastModeWbl();

   virtual void setCallback(IN IWblLastModeCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void getLastMode(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual IWblLastModeRequest* getRequestIf(void);

   virtual void setObjectPathManagerIf(IN IWblObjectPathManagerWbl* manager);

   virtual void updateLastMode(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode result, IN const BTSWblWiFiSetupStatusWblList& wifiSetupStatusList);

private:
   IWblLastModeCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   IWblObjectPathManagerWbl* _objectPathManager; /**< object path manager */

   void createGetLastIntendedModeMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList);
};

} //wbl
} //btstackif

#endif //_WBL_LAST_MODE_WBL_H_
