/**
 * @file TrcIpc2Bts_WBL.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Traces for Ipc2Bts messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of traces for Ipc2Bts messages.
 */

#include "Ipc2Bts_MessageWrapper_WBL.h"
#include "TraceClasses.h"
#include "FwTrace.h"
#include "BtsUtils.h"
#include "WblStackTypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_IPC2BTS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TrcIpc2Bts_WBL.cpp.trc.h"
#else
#include "BtStackIfTypesTrace.h"
#include "BtStackInternalTypesTrace.h"
#include "WblStackTypesTrace.h"
#include "WblStackOpcodesTrace.h"
#endif
#endif

namespace btstackif {
namespace wbl {

void Ipc2Bts_ServiceAvailabilityWbl::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d interface=%d availabilityEvent=%d busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSWblDbusServiceInterface, _interface),
            ETG_ENUM(TRC_BTSDbusServiceAvailability, _availabilityEvent),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s interface=%s availabilityEvent=%s busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getWblDbusServiceInterface2String(_interface),
            getDbusServiceAvailability2String(_availabilityEvent),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#endif
}

void Ipc2Bts_GetManagedObjectsWbl::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s busType=%d busName=%20s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            _busType,
            _busName.c_str() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));

#endif
}

void Ipc2Bts_AddWifiSetupObjectPath::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_DelWifiSetupObjectPath::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_LastIntendedModeUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d wifiSetupStatusList.size()=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            _wifiSetupStatusList.size() /*DONE: format*/));
   for(size_t i = 0; i < _wifiSetupStatusList.size(); i++)
   {
      ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): wifiSetupStatusList[%u]: mode=%d powerState=%d frequency=%d type=%d path=%s",
               getMessageTraceId(),
               ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
               i,
               ETG_ENUM(TRC_BTSWblWifiMode, _wifiSetupStatusList[i].mode),
               ETG_ENUM(TRC_BTSWblWifiPowerState, _wifiSetupStatusList[i].powerState),
               ETG_ENUM(TRC_BTSWblWifiFrequency, _wifiSetupStatusList[i].frequency),
               ETG_ENUM(TRC_BTSWblAccessPointConfigType, _wifiSetupStatusList[i].type),
               _wifiSetupStatusList[i].objPath.c_str() /*DONE: _wifiSetupStatusList format*/));
   }

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s wifiSetupStatusList.size()=%u",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            _wifiSetupStatusList.size() /*DONE: format*/));
   for(size_t i = 0; i < _wifiSetupStatusList.size(); i++)
   {
      BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): wifiSetupStatusList[%u]: mode=%s powerState=%s frequency=%s type=%s path=%s",
               getMessageTraceId(),
               getWblIpc2BtsOpcode2String(opcode),
               i,
               getWblWifiMode2String(_wifiSetupStatusList[i].mode),
               getWblWifiPowerState2String(_wifiSetupStatusList[i].powerState),
               getWblWifiFrequency2String(_wifiSetupStatusList[i].frequency),
               getWblAccessPointConfigType2String(_wifiSetupStatusList[i].type),
               _wifiSetupStatusList[i].objPath.c_str() /*DONE: _wifiSetupStatusList format*/));
   }

#endif
}

void Ipc2Bts_SupportedFrequenciesUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d supportedRestrictions.size()=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            _supportedRestrictions.size() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));
   for(size_t j = 0; j < _supportedRestrictions.size(); j++)
   {
      BTSWblSupportedRestriction& restriction = _supportedRestrictions[j];
      ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): supportedRestrictions[%u]: frequency=%d technologies.size()=%u",
               getMessageTraceId(),
               ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
               j,
               ETG_ENUM(TRC_BTSWblWifiFrequency, restriction.frequency),
               restriction.technologies.size() /*DONE: _supportedRestrictions format*/));
      for(size_t k = 0; k < restriction.technologies.size(); k++)
      {
         BTSWblSupportedTechnology& technology = restriction.technologies[k];
         ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): supportedRestrictions[%u][%u]: frequency=%d type=%d setting=%d",
                  getMessageTraceId(),
                  ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
                  j,
                  k,
                  ETG_ENUM(TRC_BTSWblWifiFrequency, restriction.frequency),
                  ETG_ENUM(TRC_BTSWblAccessPointConfigType, technology.type),
                  ETG_ENUM(TRC_BTSWblSupportedSetting, technology.setting) /*DONE: _supportedRestrictions format*/));
      }
   }

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s supportedRestrictions.size()=%u objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            _supportedRestrictions.size() /*DONE: format*/,
            _objPath.c_str() /*DONE: format*/));
   for(size_t j = 0; j < _supportedRestrictions.size(); j++)
   {
      BTSWblSupportedRestriction& restriction = _supportedRestrictions[j];
      BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): supportedRestrictions[%u]: frequency=%s technologies.size()=%u",
               getMessageTraceId(),
               getWblIpc2BtsOpcode2String(opcode),
               j,
               getWblWifiFrequency2String(restriction.frequency),
               restriction.technologies.size() /*DONE: _supportedRestrictions format*/));
      for(size_t k = 0; k < restriction.technologies.size(); k++)
      {
         BTSWblSupportedTechnology& technology = restriction.technologies[k];
         BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): supportedRestrictions[%u][%u]: frequency=%s type=%s setting=%s",
                  getMessageTraceId(),
                  getWblIpc2BtsOpcode2String(opcode),
                  j,
                  k,
                  getWblWifiFrequency2String(restriction.frequency),
                  getWblAccessPointConfigType2String(technology.type),
                  getWblSupportedSetting2String(technology.setting) /*DONE: _supportedRestrictions format*/));
      }
   }

#endif
}

void Ipc2Bts_WifiModeUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d mode=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSWblWifiMode, _mode),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s mode=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getWblWifiMode2String(_mode),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_WifiPowerStateUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d powerState=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSWblWifiPowerState, _powerState),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s powerState=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getWblWifiPowerState2String(_powerState),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_WifiFrequencyUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d frequency=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSWblWifiFrequency, _frequency),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s frequency=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getWblWifiFrequency2String(_frequency),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_AccessPointConfigTypeUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d type=%d objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSWblAccessPointConfigType, _type),
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s type=%s objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getWblAccessPointConfigType2String(_type),
            _objPath.c_str()));

#endif
}

void Ipc2Bts_WifiConnectionStatusUpdate::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   ETG_TRACE_USR1((" Ipc2Bts: 0x%08X (%d): errCode=%d connected=%d healthIndicator=%u objPath=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSWblIpc2BtsOpcode, opcode),
            ETG_ENUM(TRC_BTSIpcCommonErrorCode, _commonErrorCode),
            ETG_ENUM(TRC_BTSBool, _connected),
            _healthIndicator,
            _objPath.c_str()));

#else

   BTSWblIpc2BtsOpcode opcode = (BTSWblIpc2BtsOpcode)_opCode;
   BTS_TRACE_USR1((" Ipc2Bts: 0x%08X (%s): errCode=%s connected=%s healthIndicator=%u objPath=%s",
            getMessageTraceId(),
            getWblIpc2BtsOpcode2String(opcode),
            getIpcCommonErrorCode2String(_commonErrorCode),
            getBool2String(_connected),
            _healthIndicator,
            _objPath.c_str()));

#endif
}

} //wbl
} //btstackif
