/**
 * @file WblWifiSetupFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl instance factory for WifiSetup.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for WifiSetup.
 */

#include "WblWifiSetupFactory.h"
#include "WblWifiSetupCallbackIf.h"

namespace btstackif {
namespace wbl {

WblWifiSetupFactory::WblWifiSetupFactory() :
_createdLocally(true),
_cb(0)
{
}

WblWifiSetupFactory::~WblWifiSetupFactory()
{
   _cb = 0;
}

WblWifiSetupFactory& WblWifiSetupFactory::getInstance(void)
{
   static WblWifiSetupFactory factory;
   return factory;
}

IWblWifiSetupCallbackIf* WblWifiSetupFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new WblWifiSetupCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void WblWifiSetupFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void WblWifiSetupFactory::setCbForTesting(IWblWifiSetupCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //wbl
} //btstackif
