/**
 * @file WblOrgFreedesktopObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop DBUS Callback for ObjectManager.
 */

#ifndef _WBL_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
#define _WBL_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_

#include "IWblOrgFreedesktopObjectManagerCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace btstackif {
namespace wbl {

/**
 * Callback class for ObjectManager.
 */
class WblOrgFreedesktopObjectManagerCallbackIf : public DbusCallbackIf, public IWblOrgFreedesktopObjectManagerCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   WblOrgFreedesktopObjectManagerCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~WblOrgFreedesktopObjectManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

   virtual void setWifiSetupIf(::ccdbusif::IWblDbusWifiSetupSendRequestIf* wifiSetupIf);

   virtual void setWifiSetupCb(IWblWifiSetupCallbackIf* wifiSetupCb);

private:
   unsigned int _callbackId; /**< callback id */
   ::ccdbusif::IWblDbusWifiSetupSendRequestIf* _wifiSetupIf; /**< Wifi setup handler */
   IWblWifiSetupCallbackIf* _wifiSetupCb; /**< Wifi setup callback */
   ::std::map< ::std::string, bool > _objPathList; /**< object path list */

   void parseAddedInterface(const ::std::string& addedObjPath, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& addedInterfaces, const ::std::string& objPath, const ::std::string& busName, const ::ccdbusif::DbusBusType busType, const ::std::string& interfaceName);

   void removeObjPath(const ::std::string& objPath);

   bool isObjPathAvailable(const ::std::string& objPath) const;

   void addObjPath(const ::std::string& objPath);
};

/**
 * inline methods
 */
inline void WblOrgFreedesktopObjectManagerCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void WblOrgFreedesktopObjectManagerCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int WblOrgFreedesktopObjectManagerCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

inline void WblOrgFreedesktopObjectManagerCallbackIf::setWifiSetupIf(::ccdbusif::IWblDbusWifiSetupSendRequestIf* wifiSetupIf)
{
   _wifiSetupIf = wifiSetupIf;
}

inline void WblOrgFreedesktopObjectManagerCallbackIf::setWifiSetupCb(IWblWifiSetupCallbackIf* wifiSetupCb)
{
   _wifiSetupCb = wifiSetupCb;
}

} //wbl
} //btstackif

#endif //_WBL_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
