/**
 * @file WblLastIntendedModeCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl DBUS Callback for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS Callback for LastIntendedMode.
 */

#ifndef _WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_
#define _WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_

#include "IWblLastIntendedModeCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::org::bosch::wbl::LastIntendedMode;

namespace btstackif {
namespace wbl {

/**
 * Callback class for LastIntendedMode.
 */
class WblLastIntendedModeCallbackIf : public DbusCallbackIf, public IWblLastIntendedModeCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   WblLastIntendedModeCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~WblLastIntendedModeCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /org/bosch/wbl/LastIntendedModeProxy implementation --- start
   virtual void onLastIntendedModeErrorCb(const ::boost::shared_ptr< LastIntendedModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onLastIntendedModeUpdateCb(const ::boost::shared_ptr< LastIntendedModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /org/bosch/wbl/LastIntendedModeProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

private:
   unsigned int _callbackId; /**< callback id */
};

/**
 * inline methods
 */
inline void WblLastIntendedModeCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void WblLastIntendedModeCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int WblLastIntendedModeCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

} //wbl
} //btstackif

#endif //_WBL_LAST_INTENDED_MODE_CALLBACK_IF_H_
