/**
 * @file WblDbusAccessMain.h
 *
 * @par SW-Component
 * IPC
 *
 * @brief DBUS WBL handling.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Class for DBUS WBL handling.
 */

#ifndef _WBL_DBUS_ACCESS_MAIN_H_
#define _WBL_DBUS_ACCESS_MAIN_H_

#include "BtStackInternalTypes.h"
#include "DbusBase.h"
#include "IDbusTrmHandler.h"
#include "IDbusRecHandler.h"
#include "IDbusCallbackHandler.h"
#include "IDbusTimeoutHandler.h"
#include "IDbusResponseTimeoutHandler.h"

namespace btstackif {
namespace wbl {

/**
 *
 */
class WblDbusAccessMain : public DbusBase, public IDbusTrmHandler, public IDbusRecHandler, public IDbusCallbackHandler, public IDbusTimeoutHandler, public IDbusResponseTimeoutHandler
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Default constructor.
    */
   WblDbusAccessMain();

   /**
    * Destructor.
    */
   virtual ~WblDbusAccessMain();

   virtual void sendBts2IpcMessage(IN Bts2Ipc_BaseMessage* ptrMessage);

   virtual void stop(void);

   virtual void run(void);

   virtual BTSErrorCode setCcDbusIfControllerIf(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
            IN ::ccdbusif::ICcDbusIfController* controller, IN const ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual void resetCcDbusIfControllerIf(void);

   virtual void handleTimerTick(void);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual void setSimulationTestCommand(IN const char* testCommand, IN const Ipc2Bts_BaseMessage& testData);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent);

   virtual void createDbusServiceAvailabilityMessage(IN const BTSCommonEnumClass interface, IN const BTSDbusServiceAvailability availabilityEvent, IN const BTSBusName& busName, IN const BTSObjectPath& objPath, IN const BTSCommonEnumClass busType);

   virtual void threadFunction(void* arguments);

   virtual void setTerminate(void* arguments);

   virtual void handleDbusTrmQueue(void);

   virtual void handleReceivedDbusMessage(IN Ipc2Bts_BaseMessage* ptrMessage, IN const bool highPrio = false);

   virtual void handleDbusCallbackMessage(void);

   virtual void handleDbusTimeoutEvent(void);

   virtual void handleDbusResponseTimeout(Bts2Ipc_BaseMessage* ptrMessage);

private:
   const unsigned int _count; /**< initial number of timer entries */

   void createDbusIfHandler(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode, IN const BTSLocalWblConfiguration& configuration);
   void removeBts2IpcWorkingMessagesOnObjectPathRemovedSignal(IN Ipc2Bts_BaseMessage* ptrMessage);
};

} //wbl
} //btstackif

#endif //_WBL_DBUS_ACCESS_MAIN_H_
