/**
 * @file IWblWifiSetupCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief Wbl DBUS Callback Interface for WifiSetup.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS callback for WifiSetup.
 */

#ifndef _I_WBL_WIFI_SETUP_CALLBACK_IF_H_
#define _I_WBL_WIFI_SETUP_CALLBACK_IF_H_

#include "cc_dbus_if/IWblDbusWifiSetupCallbackIf.h"

using namespace ::org::bosch::wbl::wifisetup;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace wbl {

/**
 * Callback interface class for WifiSetup.
 */
class IWblWifiSetupCallbackIf : public ::ccdbusif::IWblDbusWifiSetupCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblWifiSetupCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /org/bosch/wbl/wifisetupProxy implementation --- start
   virtual void onDeAuthenticateStationErrorCb(const ::boost::shared_ptr< DeAuthenticateStationError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onDeAuthenticateStationResponseCb(const ::boost::shared_ptr< DeAuthenticateStationResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onManageBandwidthErrorCb(const ::boost::shared_ptr< ManageBandwidthError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onManageBandwidthResponseCb(const ::boost::shared_ptr< ManageBandwidthResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSetRestrictionsErrorCb(const ::boost::shared_ptr< SetRestrictionsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSetRestrictionsResponseCb(const ::boost::shared_ptr< SetRestrictionsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onModeErrorCb(const ::boost::shared_ptr< ModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onModeUpdateCb(const ::boost::shared_ptr< ModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfaceErrorCb(const ::boost::shared_ptr< InterfaceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfaceUpdateCb(const ::boost::shared_ptr< InterfaceUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onMacAddressErrorCb(const ::boost::shared_ptr< MacAddressError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onMacAddressUpdateCb(const ::boost::shared_ptr< MacAddressUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onPowerStateErrorCb(const ::boost::shared_ptr< PowerStateError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onPowerStateUpdateCb(const ::boost::shared_ptr< PowerStateUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onPowerFailureReasonErrorCb(const ::boost::shared_ptr< PowerFailureReasonError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onPowerFailureReasonUpdateCb(const ::boost::shared_ptr< PowerFailureReasonUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFrequencyErrorCb(const ::boost::shared_ptr< FrequencyError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onFrequencyUpdateCb(const ::boost::shared_ptr< FrequencyUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onCurrentOperatingChannelErrorCb(const ::boost::shared_ptr< CurrentOperatingChannelError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onCurrentOperatingChannelUpdateCb(const ::boost::shared_ptr< CurrentOperatingChannelUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onAPConfigErrorCb(const ::boost::shared_ptr< APConfigError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onAPConfigUpdateCb(const ::boost::shared_ptr< APConfigUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onRestrictionsErrorCb(const ::boost::shared_ptr< RestrictionsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onRestrictionsUpdateCb(const ::boost::shared_ptr< RestrictionsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSupportedFrequenciesErrorCb(const ::boost::shared_ptr< SupportedFrequenciesError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onSupportedFrequenciesUpdateCb(const ::boost::shared_ptr< SupportedFrequenciesUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

#ifdef VARIANT_S_FTR_ENABLE_CONNECTION_STATUS
   virtual void onConnectionStatusErrorCb(const ::boost::shared_ptr< ConnectionStatusError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onConnectionStatusUpdateCb(const ::boost::shared_ptr< ConnectionStatusUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
#endif
   // /org/bosch/wbl/wifisetupProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;
};

} //wbl
} //btstackif

#endif //_I_WBL_WIFI_SETUP_CALLBACK_IF_H_
