/**
 * @file WblUtils.cpp
 *
 * @par SW-Component
 * Utilities
 *
 * @brief Utilities for WBL handling.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of utilities class.
 */

#include "WblUtils.h"
#include "FwAssert.h"

namespace btstackif {
namespace wbl {

BTSWblWifiFrequency convertWifiFrequency(IN const ::ccdbusif::wbl::WiFiFrequency value)
{
   BTSWblWifiFrequency returnValue(BTS_WBL_WIFI_FREQUENCY_2_4_GHZ);

   switch(value)
   {
      case ::ccdbusif::wbl::WIFI_FREQUENCY_2_4_GHZ:
         returnValue = BTS_WBL_WIFI_FREQUENCY_2_4_GHZ;
         break;
      case ::ccdbusif::wbl::WIFI_FREQUENCY_5_GHZ:
         returnValue = BTS_WBL_WIFI_FREQUENCY_5_GHZ;
         break;
      case ::ccdbusif::wbl::WIFI_FREQUENCY_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         break;
   }

   return returnValue;
}

BTSWblAccessPointConfigType convertAccessPointConfigType(IN const ::ccdbusif::wbl::WiFiType value)
{
   BTSWblAccessPointConfigType returnValue(BTS_WBL_AP_CONFIG_NORMAL);

   switch(value)
   {
      case ::ccdbusif::wbl::WIFI_TYPE_CARPLAYWIRELESS:
         returnValue = BTS_WBL_AP_CONFIG_CPW;
         break;
      case ::ccdbusif::wbl::WIFI_TYPE_ANDROIDAUTOWIRELESS:
         returnValue = BTS_WBL_AP_CONFIG_AA;
         break;
      case ::ccdbusif::wbl::WIFI_TYPE_NORMAL:
         returnValue = BTS_WBL_AP_CONFIG_NORMAL;
         break;
      case ::ccdbusif::wbl::WIFI_TYPE_RESTRICTED:
         returnValue = BTS_WBL_AP_CONFIG_RESTRICTED;
         break;
      case ::ccdbusif::wbl::WIFI_TYPE_TYPE_UNKNOWN:
         returnValue = BTS_WBL_AP_CONFIG_UNKNOWN;
         break;
      case ::ccdbusif::wbl::WIFI_TYPE_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         break;
   }

   return returnValue;
}

BTSWblWifiPowerState convertWifiPowerState(IN const ::ccdbusif::wbl::PowerState value)
{
   BTSWblWifiPowerState returnValue(BTS_WBL_WIFI_STATE_DEVICE_UNAVAILABLE);

   switch(value)
   {
      case ::ccdbusif::wbl::POWER_STATE_POWERING_ON:
         returnValue = BTS_WBL_WIFI_STATE_POWERING_ON;
         break;
      case ::ccdbusif::wbl::POWER_STATE_POWERED_ON:
         returnValue = BTS_WBL_WIFI_STATE_POWERED_ON;
         break;
      case ::ccdbusif::wbl::POWER_STATE_POWERING_OFF:
         returnValue = BTS_WBL_WIFI_STATE_POWERING_OFF;
         break;
      case ::ccdbusif::wbl::POWER_STATE_POWERED_OFF:
         returnValue = BTS_WBL_WIFI_STATE_POWERED_OFF;
         break;
      case ::ccdbusif::wbl::POWER_STATE_POWER_FAILURE:
         returnValue = BTS_WBL_WIFI_STATE_POWER_FAILURE;
         break;
      case ::ccdbusif::wbl::POWER_STATE_DEVICE_UNAVAILABLE:
         returnValue = BTS_WBL_WIFI_STATE_DEVICE_UNAVAILABLE;
         break;
      case ::ccdbusif::wbl::POWER_STATE_DEVICE_AVAILABLE:
         returnValue = BTS_WBL_WIFI_STATE_DEVICE_AVAILABLE;
         break;
      case ::ccdbusif::wbl::POWER_STATE_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         break;
   }

   return returnValue;
}

BTSWblWifiMode convertWifiMode(IN const ::ccdbusif::wbl::WiFiMode value)
{
   BTSWblWifiMode returnValue(BTS_WBL_WIFI_MODE_STA);

   switch(value)
   {
      case ::ccdbusif::wbl::WIFI_MODE_STA:
         returnValue = BTS_WBL_WIFI_MODE_STA;
         break;
      case ::ccdbusif::wbl::WIFI_MODE_AP:
         returnValue = BTS_WBL_WIFI_MODE_AP;
         break;
      case ::ccdbusif::wbl::WIFI_MODE_P2P:
         returnValue = BTS_WBL_WIFI_MODE_P2P;
         break;
      case ::ccdbusif::wbl::WIFI_MODE_ALL:
         returnValue = BTS_WBL_WIFI_MODE_ALL;
         break;
      case ::ccdbusif::wbl::WIFI_MODE_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         break;
   }

   return returnValue;
}

BTSWblSupportedSetting convertSupportedSetting(IN const ::ccdbusif::wbl::SupportedSetting value)
{
   BTSWblSupportedSetting returnValue(BTS_WBL_SUPPORTED_SETTING_NOT_ALLOWED);

   switch(value)
   {
      case ::ccdbusif::wbl::SUPPORTED_SETTING_NOT_ALLOWED:
         returnValue = BTS_WBL_SUPPORTED_SETTING_NOT_ALLOWED;
         break;
      case ::ccdbusif::wbl::SUPPORTED_SETTING_ALLOWED:
         returnValue = BTS_WBL_SUPPORTED_SETTING_ALLOWED;
         break;
      case ::ccdbusif::wbl::SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS:
         returnValue = BTS_WBL_SUPPORTED_SETTING_ALLOWED_WITH_LIMITATIONS;
         break;
      case ::ccdbusif::wbl::SUPPORTED_SETTING_UNKNOWN:
      default:
         FW_NORMAL_ASSERT_ALWAYS();
         break;
   }

   return returnValue;
}

} //wbl
} //btstackif
