/**
 * @file WblStackTypes.cpp
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for WBL access.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for WBL access.
 */

#include "WblStackTypes.h"

namespace btstackif {
namespace wbl {

BTSWblWiFiSetupStatusWbl::BTSWblWiFiSetupStatusWbl() :
BTSWblWiFiSetupStatus(),
objPath()
{
}

BTSWblWiFiSetupStatusWbl::BTSWblWiFiSetupStatusWbl(IN const BTSWblWiFiSetupStatusWbl& ref) :
BTSWblWiFiSetupStatus(ref),
objPath(ref.objPath)
{
}

BTSWblWiFiSetupStatusWbl& BTSWblWiFiSetupStatusWbl::operator=(IN const BTSWblWiFiSetupStatusWbl& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   BTSWblWiFiSetupStatus::operator=(ref);

   objPath = ref.objPath;

   return *this;
}

bool BTSWblWiFiSetupStatusWbl::operator==(IN const BTSWblWiFiSetupStatusWbl& ref) const
{
   bool result = BTSWblWiFiSetupStatus::operator==(ref);

   result = (true == result) && (objPath == ref.objPath);

   return result;
}

bool BTSWblWiFiSetupStatusWbl::operator!=(IN const BTSWblWiFiSetupStatusWbl& ref) const
{
   return !(operator==(ref));
}

BTSWblWiFiSetupStatusWbl::~BTSWblWiFiSetupStatusWbl()
{
}

} //wbl
} //btstackif
