/**
 * @file WblStackOpcodesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "WblStackOpcodesTrace.h"

namespace btstackif {
namespace wbl {

const char* getWblBts2IpcOpcode2String(BTSWblBts2IpcOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case Bts2IpcOC_None:
         result = "None";
         break;
      case Bts2IpcOC_WblBlockStart:
         result = "WblBlockStart";
         break;
      case Bts2IpcOC_GetManagedObjectsWbl:
         result = "GetManagedObjectsWbl";
         break;
      case Bts2IpcOC_GetIntrospectionWbl:
         result = "GetIntrospectionWbl";
         break;
      case Bts2IpcOC_GetLastIntendedMode:
         result = "GetLastIntendedMode";
         break;
      case Bts2IpcOC_GetSupportedFrequencies:
         result = "GetSupportedFrequencies";
         break;
      case Bts2IpcOC_GetWifiMode:
         result = "GetWifiMode";
         break;
      case Bts2IpcOC_GetWifiPowerState:
         result = "GetWifiPowerState";
         break;
      case Bts2IpcOC_GetWifiFrequency:
         result = "GetWifiFrequency";
         break;
      case Bts2IpcOC_GetAccessPointConfigType:
         result = "GetAccessPointConfigType";
         break;
      case Bts2IpcOC_GetWifiConnectionStatus:
         result = "GetWifiConnectionStatus";
         break;
      case Bts2IpcOC_WblBlockEnd:
         result = "WblBlockEnd";
         break;
      case Bts2IpcOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

const char* getWblIpc2BtsOpcode2String(BTSWblIpc2BtsOpcode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case Ipc2BtsOC_None:
         result = "None";
         break;
      case Ipc2BtsOC_WblBlockStart:
         result = "WblBlockStart";
         break;
      case Ipc2BtsOC_ServiceAvailabilityWbl:
         result = "ServiceAvailabilityWbl";
         break;
      case Ipc2BtsOC_GetManagedObjectsWbl:
         result = "GetManagedObjectsWbl";
         break;
      case Ipc2BtsOC_AddWifiSetupObjectPath:
         result = "AddWifiSetupObjectPath";
         break;
      case Ipc2BtsOC_DelWifiSetupObjectPath:
         result = "DelWifiSetupObjectPath";
         break;
      case Ipc2BtsOC_LastIntendedModeUpdate:
         result = "LastIntendedModeUpdate";
         break;
      case Ipc2BtsOC_SupportedFrequenciesUpdate:
         result = "SupportedFrequenciesUpdate";
         break;
      case Ipc2BtsOC_WifiModeUpdate:
         result = "WifiModeUpdate";
         break;
      case Ipc2BtsOC_WifiPowerStateUpdate:
         result = "WifiPowerStateUpdate";
         break;
      case Ipc2BtsOC_WifiFrequencyUpdate:
         result = "WifiFrequencyUpdate";
         break;
      case Ipc2BtsOC_AccessPointConfigTypeUpdate:
         result = "AccessPointConfigTypeUpdate";
         break;
      case Ipc2BtsOC_WifiConnectionStatusUpdate:
         result = "WifiConnectionStatusUpdate";
         break;
      case Ipc2BtsOC_WblBlockEnd:
         result = "WblBlockEnd";
         break;
      case Ipc2BtsOC_Last:
         result = "Last";
         break;
      default:
         break;
   }

   return result;
}

} //wbl
} //btstackif
