/**
 * @file WblUtils.h
 *
 * @par SW-Component
 * Utilities
 *
 * @brief Utilities for WBL handling.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Utilities class.
 */

#ifndef _WBL_UTILS_H_
#define _WBL_UTILS_H_

#include "WblStackTypes.h"
#include "cc_dbus_if/WblDbusTypes.h"

namespace btstackif {
namespace wbl {

BTSWblWifiFrequency convertWifiFrequency(IN const ::ccdbusif::wbl::WiFiFrequency value);
BTSWblAccessPointConfigType convertAccessPointConfigType(IN const ::ccdbusif::wbl::WiFiType value);
BTSWblWifiPowerState convertWifiPowerState(IN const ::ccdbusif::wbl::PowerState value);
BTSWblWifiMode convertWifiMode(IN const ::ccdbusif::wbl::WiFiMode value);
BTSWblSupportedSetting convertSupportedSetting(IN const ::ccdbusif::wbl::SupportedSetting value);

} //wbl
} //btstackif

#endif //_WBL_UTILS_H_
