/**
 * @file Bts2Ipc_Wbl_WBL.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_WBL.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_WBL.
 */

#ifndef _BTS_2_IPC_WBL_MSG_WBL_H_
#define _BTS_2_IPC_WBL_MSG_WBL_H_

#include "WblStackTypes.h"
#include "Bts2Ipc_BaseMessage.h"

namespace btstackif {
namespace wbl {

/**
 *
 */
class Bts2Ipc_GetManagedObjectsWbl : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetManagedObjectsWbl();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetManagedObjectsWbl(IN const Bts2Ipc_GetManagedObjectsWbl& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetManagedObjectsWbl& operator=(IN const Bts2Ipc_GetManagedObjectsWbl& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetManagedObjectsWbl();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetIntrospectionWbl : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetIntrospectionWbl();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetIntrospectionWbl(IN const Bts2Ipc_GetIntrospectionWbl& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetIntrospectionWbl& operator=(IN const Bts2Ipc_GetIntrospectionWbl& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetIntrospectionWbl();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetLastIntendedMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetLastIntendedMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetLastIntendedMode(IN const Bts2Ipc_GetLastIntendedMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetLastIntendedMode& operator=(IN const Bts2Ipc_GetLastIntendedMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetLastIntendedMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;
};

/**
 *
 */
class Bts2Ipc_GetSupportedFrequencies : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetSupportedFrequencies();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetSupportedFrequencies(IN const Bts2Ipc_GetSupportedFrequencies& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetSupportedFrequencies& operator=(IN const Bts2Ipc_GetSupportedFrequencies& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetSupportedFrequencies();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetWifiMode : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetWifiMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetWifiMode(IN const Bts2Ipc_GetWifiMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetWifiMode& operator=(IN const Bts2Ipc_GetWifiMode& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetWifiMode();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetWifiPowerState : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetWifiPowerState();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetWifiPowerState(IN const Bts2Ipc_GetWifiPowerState& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetWifiPowerState& operator=(IN const Bts2Ipc_GetWifiPowerState& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetWifiPowerState();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetWifiFrequency : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetWifiFrequency();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetWifiFrequency(IN const Bts2Ipc_GetWifiFrequency& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetWifiFrequency& operator=(IN const Bts2Ipc_GetWifiFrequency& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetWifiFrequency();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetAccessPointConfigType : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAccessPointConfigType();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAccessPointConfigType(IN const Bts2Ipc_GetAccessPointConfigType& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAccessPointConfigType& operator=(IN const Bts2Ipc_GetAccessPointConfigType& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAccessPointConfigType();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetWifiConnectionStatus : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetWifiConnectionStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetWifiConnectionStatus(IN const Bts2Ipc_GetWifiConnectionStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetWifiConnectionStatus& operator=(IN const Bts2Ipc_GetWifiConnectionStatus& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetWifiConnectionStatus();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setId(IN const BTSWblWiFiSetupId id) { _id = id; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSWblWiFiSetupId getId(void) const { return _id; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSWblWiFiSetupId _id; /**< parameter id */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //wbl
} //btstackif

#endif //_BTS_2_IPC_WBL_MSG_WBL_H_
