/**
 * @file HfpAvpConnectDisconnectDataGenivi.cpp
 *
 * @par SW-Component
 * State machine for HFP/AVP connect/disconnect
 *
 * @brief Implementation of Genivi HFP/AVP connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of Genivi HFP/AVP connect/disconnect state machine data.
 */

#include "HfpAvpConnectDisconnectDataGenivi.h"

namespace btstackif {
namespace genivi {

HfpAvpConnectDisconnectDataGenivi::HfpAvpConnectDisconnectDataGenivi() :
serviceSppServiceTimer(),
serialIfAdded(false),
serialIfAvailable(false)
{
}

HfpAvpConnectDisconnectDataGenivi::~HfpAvpConnectDisconnectDataGenivi()
{
}

HfpAvpConnectDisconnectDataGenivi::HfpAvpConnectDisconnectDataGenivi(const HfpAvpConnectDisconnectDataGenivi& ref) :
serviceSppServiceTimer(ref.serviceSppServiceTimer),
serialIfAdded(ref.serialIfAdded),
serialIfAvailable(ref.serialIfAvailable)
{
}

HfpAvpConnectDisconnectDataGenivi& HfpAvpConnectDisconnectDataGenivi::operator=(const HfpAvpConnectDisconnectDataGenivi& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   serviceSppServiceTimer = ref.serviceSppServiceTimer;
   serialIfAdded = ref.serialIfAdded;
   serialIfAvailable = ref.serialIfAvailable;

   return *this;
}

bool HfpAvpConnectDisconnectDataGenivi::operator==(const HfpAvpConnectDisconnectDataGenivi& ref) const
{
   bool result = true;

   result = (true == result) && (serviceSppServiceTimer == ref.serviceSppServiceTimer);
   result = (true == result) && (serialIfAdded == ref.serialIfAdded);
   result = (true == result) && (serialIfAvailable == ref.serialIfAvailable);

   return result;
}

bool HfpAvpConnectDisconnectDataGenivi::operator!=(const HfpAvpConnectDisconnectDataGenivi& ref) const
{
   return !(operator==(ref));
}

} //genivi
} //btstackif
