/**
 * @file SppPoolGenivi.h
 *
 * @par SW-Component
 * State machine for SPP pool
 *
 * @brief Implementation of Genivi SPP pool state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi SPP pool state machine.
 */

#ifndef _SPP_POOL_GENIVI_H_
#define _SPP_POOL_GENIVI_H_

#include "ISppPoolRequest.h"
#include "ISppPoolGenivi.h"

namespace btstackif {
namespace genivi {

/**
 * Genivi SPP pool class.
 */
class SppPoolGenivi : public ISppPoolRequest, public ISppPoolGenivi
{
public:
   /**
    * Default constructor.
    */
   SppPoolGenivi();

   /**
    * Destructor.
    */
   virtual ~SppPoolGenivi();

   virtual void reset(void);

   virtual void setCallback(IN ISppPoolCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setTimerPoolIf(IN ITimerPool* timerPool);

   virtual BTSSppInstanceId getMaxNumberSppConnections(void) const;

   virtual BTSSppInstanceId getMaxNumberLocalSppServices(void) const;

   virtual void setUuid(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSSppInstanceId instance, IN const BTSUuid& outgoingUuid, IN const BTSUuid& incomingUuid);

   virtual void setLocalSppUuids(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSUuidList& uuidList);

   virtual void sendVirtualLocalSppUuidsUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSUuidList& uuidList, IN const BTSIpcCommonErrorCode errorCode);

   virtual ISppPoolRequest* getRequestIf(void);

   virtual void handleLocalSppUuidsUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSUuidList& uuidList, IN const BTSIpcCommonErrorCode errorCode, IN const bool response);

private:
   ISppPoolCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   ITimerPool* _timerPoolIf; /**< timer pool interface */
   const BTSSppInstanceId _maxSppConnections; /**< maximum number of supported SPP connections */
   const BTSSppInstanceId _maxLocalSppServices; /**< maximum number of local SPP services */

   void createSetAdapterAvailableSppServersMsg(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, IN const BTSUuidList& uuidList) const;
};

} //genivi
} //btstackif

#endif //_SPP_POOL_GENIVI_H_
