/**
 * @file ObexConnectDisconnectDataGenivi.h
 *
 * @par SW-Component
 * State machine for OBEX connect/disconnect
 *
 * @brief Implementation of Genivi OBEX connect/disconnect state machine data.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi OBEX connect/disconnect state machine data.
 */

#ifndef _OBEX_CONNECT_DISCONNECT_DATA_GENIVI_H_
#define _OBEX_CONNECT_DISCONNECT_DATA_GENIVI_H_

#include "BtStackInternalTypes.h"
#include "ExtendedTimerEntry.h"

namespace btstackif {
namespace genivi {

/**
 * OBEX connect/disconnect state machine data class.
 */
class ObexConnectDisconnectDataGenivi
{
public:
   /**
    * Default constructor.
    */
   ObexConnectDisconnectDataGenivi();

   /**
    * Destructor.
    */
   virtual ~ObexConnectDisconnectDataGenivi();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   ObexConnectDisconnectDataGenivi(const ObexConnectDisconnectDataGenivi& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   ObexConnectDisconnectDataGenivi& operator=(const ObexConnectDisconnectDataGenivi& ref);

   /**
    * Equality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator==(const ObexConnectDisconnectDataGenivi& ref) const;

   /**
    * Inequality operator.
    *
    * @param[in] ref: reference of message to be compared
    */
   bool operator!=(const ObexConnectDisconnectDataGenivi& ref) const;

   // member with public access
   ExtendedTimerEntry statusUpdateTimer; /**< timer for status update (protocol added) */
};

} //genivi
} //btstackif

#endif //_OBEX_CONNECT_DISCONNECT_DATA_GENIVI_H_
