/**
 * @file InquiryGenivi.h
 *
 * @par SW-Component
 * State machine for inquiry
 *
 * @brief Implementation of Genivi inquiry state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi inquiry state machine.
 */

#ifndef _INQUIRY_GENIVI_H_
#define _INQUIRY_GENIVI_H_

#include "IInquiryRequest.h"
#include "IInquiryGenivi.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

// class forward declarations
class IObjectPathManagerGenivi;

/**
 * Inquiry class.
 */
class InquiryGenivi : public IInquiryRequest, public IInquiryGenivi
{
public:
   /**
    * Default constructor.
    */
   InquiryGenivi();

   /**
    * Destructor.
    */
   virtual ~InquiryGenivi();

   virtual void reset(void);

   virtual void setCallback(IN IInquiryCallback* callback);

   virtual void startDiscovery(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void stopDiscovery(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setObjectPathManagerIf(IN IObjectPathManagerGenivi* objectPathManager);

   virtual void handleStartDiscoveryResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleStopDiscoveryResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleAdapterDiscoveringUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const bool discovering, IN const BTSIpcCommonErrorCode errorCode, IN const bool response);

   virtual void handleDeviceFound(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDiscoveredDeviceInfo& device);

private:
   IInquiryCallback* _callback; /**< callback interface */
   IObjectPathManagerGenivi* _objectPathManagerIf; /**< object path manager interface */

   void createStartDiscoveryMsg(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList) const;

   void createStopDiscoveryMsg(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList) const;
};

} //genivi
} //btstackif

#endif //_INQUIRY_GENIVI_H_
