/**
 * @file ISppPoolGenivi.h
 *
 * @par SW-Component
 * State machine for SPP pool
 *
 * @brief Interface definition for Genivi SPP pool state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Genivi SPP pool state machine.
 */

#ifndef _I_SPP_POOL_GENIVI_H_
#define _I_SPP_POOL_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {

// class forward declarations
class ISppPoolRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {

/**
 * Interface definition.
 */
class ISppPoolGenivi
{
public:
   /**
    * Destructor.
    */
   virtual ~ISppPoolGenivi() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual ISppPoolRequest* getRequestIf(void) = 0;

   /**
    * Handle local SPP UUIDs update message.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] uuidList: UUID list
    * @param[in] errorCode: error code
    * @param[in] response: response flag (update or return)
    */
   virtual void handleLocalSppUuidsUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSUuidList& uuidList, IN const BTSIpcCommonErrorCode errorCode, IN const bool response) = 0;
};

} //genivi
} //btstackif

#endif //_I_SPP_POOL_GENIVI_H_
