/**
 * @file IRssiGenivi.h
 *
 * @par SW-Component
 * State machine for RSSI
 *
 * @brief Interface definition for Genivi RSSI state machine.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Genivi interface for RSSI state machine.
 */

#ifndef _I_RSSI_GENIVI_H_
#define _I_RSSI_GENIVI_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {

// class forward declarations
class IObjectPathManagerGenivi;

/**
 * Interface definition.
 */
class IRssiGenivi
{
public:
   /**
    * Destructor.
    */
   virtual ~IRssiGenivi() {}

   /**
    * Set object path manager interface.
    *
    * @param[in] objectPathManager: object path manager interface
    */
   virtual void setObjectPathManagerIf(IN IObjectPathManagerGenivi* objectPathManager) = 0;

   /**
    * Handle RSSI update message.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] device: device object path
    * @param[in] rssi: RSSI
    * @param[in] errorCode: error code
    * @param[in] response: response flag (update or return)
    */
   virtual void handleDeviceRssiUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& device, IN const BTSRssi rssi, IN const BTSIpcCommonErrorCode errorCode, IN const bool response) = 0;
};

} //genivi
} //btstackif

#endif //_I_RSSI_GENIVI_H_
