/**
 * @file IConnectionSmExtension.h
 *
 * @par SW-Component
 * Connection state machine extension interface
 *
 * @brief Interface definition for connection state machine extension.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the interface to be implemented by connection state machine extension.
 */

#ifndef _I_CONNECTION_SM_EXTENSION_H_
#define _I_CONNECTION_SM_EXTENSION_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class ITestModeRequest;

namespace genivi {

/**
 * Interface definition.
 */
class IConnectionSmExtension
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnectionSmExtension() {}

   /**
    * Get SM for test mode.
    *
    * @return = test mode SM
    */
   virtual ITestModeRequest* getTestMode(void) = 0;
};

} //genivi
} //btstackif

#endif //_I_CONNECTION_SM_EXTENSION_H_
