/**
 * @file HfpDeviceCapabilitiesGenivi.h
 *
 * @par SW-Component
 * State machine for HFP device capabilities
 *
 * @brief Implementation of Genivi HFP device capabilities state machine.
 *
 * @copyright (C) 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Genivi HFP device capabilities state machine.
 */

#ifndef _HFP_DEVICE_CAPABILITIES_GENIVI_H_
#define _HFP_DEVICE_CAPABILITIES_GENIVI_H_

#include "IHfpDeviceCapabilitiesRequest.h"
#include "IHfpDeviceCapabilitiesGenivi.h"
#include "EvolutionGeniviStackTypes.h"
#include "DbusServiceAvailability.h"

namespace btstackif {
namespace genivi {

/**
 * HFP device capabilities class.
 */
class HfpDeviceCapabilitiesGenivi : public IHfpDeviceCapabilitiesRequest, public IHfpDeviceCapabilitiesGenivi
{
public:
   /**
    * Default constructor.
    */
   HfpDeviceCapabilitiesGenivi();

   /**
    * Destructor.
    */
   virtual ~HfpDeviceCapabilitiesGenivi();

   virtual void reset(void);

   virtual void setCallback(IN IHfpDeviceCapabilitiesCallback* callback);

   virtual void setControlIf(IN IBasicControl* control);

   virtual void getModems(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void getModemProperties(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSBDAddress& address);

   virtual void getHandsfreeProperties(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSBDAddress& address);

   virtual IHfpDeviceCapabilitiesRequest* getRequestIf(void);

   virtual void setObjectPathManagerIf(IN IObjectPathManagerGenivi* objectPathManager);

   virtual void setEnabled(IN const bool enabled, IN const BTSUserMode userMode);

   virtual bool getEnabled(void) const;

   virtual DbusServiceStatus& getServiceEntry(void);

   virtual void addInterfaces(OUT ::std::vector< BTSDbusInterfaceItem >& dbusInterfaces, IN const BTSUserMode userMode);

   virtual BTSDbusServiceAvailability getManagerAvailability(void) const;

   virtual void updateManagerAvailability(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSDbusServiceAvailability availability);

   virtual void updateModemAvailability(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath, IN const BTSDbusServiceAvailability availability);

   virtual void updateHandsfreeAvailability(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath, IN const BTSDbusServiceAvailability availability);

   virtual void handleAddedHfpInterface(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath, IN const ::ccdbusif::evolution::Interface interface);

   virtual void handleRemovedHfpInterface(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& objPath, IN const ::ccdbusif::evolution::Interface interface);

   virtual void handleHandsfreeFeaturesUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem, IN const BTSHfpSupportedFeatures& features);

   virtual void handleHandsfreeInbandRingingUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem, IN const bool inbandRingingEnabled);

   virtual void handleGetModemsResult(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleGetHandsfreePropertiesResult(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleGetModemPropertiesResult(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem, IN const BTSIpcCommonErrorCode errorCode);

   virtual void handleModemAdded(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSBDAddress& address, IN const BTSObjectPath& modem);

   virtual void handleModemRemoved(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem);

   virtual void handleModemInterfacesUpdate(OUT ::std::vector<Bts2Ipc_BaseMessage*>& bts2IpcMsgList, OUT ::std::vector<Bts2App_BaseMessage*>& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSObjectPath& modem, IN const BTSDbusInterfaceList& interfaces);

private:
   IHfpDeviceCapabilitiesCallback* _callback; /**< callback interface */
   IBasicControl* _controlIf; /**< basic control interface */
   IObjectPathManagerGenivi* _objectPathManagerIf; /**< object path manager interface */
   DbusServiceStatus _serviceStatusHfpManager; /**< HFP manager service status */
   DbusServiceStatus _serviceStatusHfpModem; /**< HFP modem service status */
   DbusServiceStatus _serviceStatusHfpHandsfree; /**< HFP handsfree service status */
};

} //genivi
} //btstackif

#endif //_HFP_DEVICE_CAPABILITIES_GENIVI_H_
