/**
 * @file Ipc2Bts_MediaPlayer_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MEDIAPLAYER.
 */

#include "Ipc2Bts_MediaPlayer_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Ipc2Bts_ServiceAvailabilityMediaPlayer::Ipc2Bts_ServiceAvailabilityMediaPlayer()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_MEDIAPLAYER), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityMediaPlayer))
{
   _interface = BTS_GEN_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_MEDIAPLAYER);
}

Ipc2Bts_ServiceAvailabilityMediaPlayer::Ipc2Bts_ServiceAvailabilityMediaPlayer(IN const Ipc2Bts_ServiceAvailabilityMediaPlayer& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityMediaPlayer& Ipc2Bts_ServiceAvailabilityMediaPlayer::operator=(IN const Ipc2Bts_ServiceAvailabilityMediaPlayer& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityMediaPlayer::~Ipc2Bts_ServiceAvailabilityMediaPlayer()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityMediaPlayer::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityMediaPlayer(*this);
}

} //genivi
} //btstackif
