/**
 * @file Ipc2Bts_Connection_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONNECTION.
 */

#include "Ipc2Bts_Connection_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Ipc2Bts_ServiceAvailabilityConnection::Ipc2Bts_ServiceAvailabilityConnection()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceAvailabilityConnection))
{
   _interface = BTS_GEN_DBUS_SERVICE_LAST;
   _availabilityEvent = BTS_DBUS_SERVICE_LAST;
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ServiceAvailabilityConnection::Ipc2Bts_ServiceAvailabilityConnection(IN const Ipc2Bts_ServiceAvailabilityConnection& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Ipc2Bts_ServiceAvailabilityConnection& Ipc2Bts_ServiceAvailabilityConnection::operator=(IN const Ipc2Bts_ServiceAvailabilityConnection& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _availabilityEvent = ref._availabilityEvent;
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_ServiceAvailabilityConnection::~Ipc2Bts_ServiceAvailabilityConnection()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceAvailabilityConnection::clone(void) const
{
   return new Ipc2Bts_ServiceAvailabilityConnection(*this);
}

Ipc2Bts_GetAllPropertiesConnection::Ipc2Bts_GetAllPropertiesConnection()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GetAllPropertiesConnection))
{
   _interface = ::ccdbusif::evolution::IF_UNKNOWN;
   // _properties is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GetAllPropertiesConnection::Ipc2Bts_GetAllPropertiesConnection(IN const Ipc2Bts_GetAllPropertiesConnection& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _properties = ref._properties;
}

Ipc2Bts_GetAllPropertiesConnection& Ipc2Bts_GetAllPropertiesConnection::operator=(IN const Ipc2Bts_GetAllPropertiesConnection& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _properties = ref._properties;

   return *this;
}

Ipc2Bts_GetAllPropertiesConnection::~Ipc2Bts_GetAllPropertiesConnection()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetAllPropertiesConnection::clone(void) const
{
   return new Ipc2Bts_GetAllPropertiesConnection(*this);
}

Ipc2Bts_AddDeviceObjectPathMapping::Ipc2Bts_AddDeviceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddDeviceObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddDeviceObjectPathMapping::Ipc2Bts_AddDeviceObjectPathMapping(IN const Ipc2Bts_AddDeviceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddDeviceObjectPathMapping& Ipc2Bts_AddDeviceObjectPathMapping::operator=(IN const Ipc2Bts_AddDeviceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddDeviceObjectPathMapping::~Ipc2Bts_AddDeviceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddDeviceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddDeviceObjectPathMapping(*this);
}

Ipc2Bts_DelDeviceObjectPathMapping::Ipc2Bts_DelDeviceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelDeviceObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelDeviceObjectPathMapping::Ipc2Bts_DelDeviceObjectPathMapping(IN const Ipc2Bts_DelDeviceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelDeviceObjectPathMapping& Ipc2Bts_DelDeviceObjectPathMapping::operator=(IN const Ipc2Bts_DelDeviceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelDeviceObjectPathMapping::~Ipc2Bts_DelDeviceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelDeviceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelDeviceObjectPathMapping(*this);
}

Ipc2Bts_AddProtocolObjectPathMapping::Ipc2Bts_AddProtocolObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddProtocolObjectPathMapping))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   _instanceId = 0;
   // _device: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddProtocolObjectPathMapping::Ipc2Bts_AddProtocolObjectPathMapping(IN const Ipc2Bts_AddProtocolObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _instanceId = ref._instanceId;
   _device = ref._device;
   _objPath = ref._objPath;
}

Ipc2Bts_AddProtocolObjectPathMapping& Ipc2Bts_AddProtocolObjectPathMapping::operator=(IN const Ipc2Bts_AddProtocolObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _instanceId = ref._instanceId;
   _device = ref._device;
   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddProtocolObjectPathMapping::~Ipc2Bts_AddProtocolObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddProtocolObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddProtocolObjectPathMapping(*this);
}

Ipc2Bts_DelProtocolObjectPathMapping::Ipc2Bts_DelProtocolObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelProtocolObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelProtocolObjectPathMapping::Ipc2Bts_DelProtocolObjectPathMapping(IN const Ipc2Bts_DelProtocolObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelProtocolObjectPathMapping& Ipc2Bts_DelProtocolObjectPathMapping::operator=(IN const Ipc2Bts_DelProtocolObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelProtocolObjectPathMapping::~Ipc2Bts_DelProtocolObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelProtocolObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelProtocolObjectPathMapping(*this);
}

Ipc2Bts_AddSerialObjectPathMapping::Ipc2Bts_AddSerialObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddSerialObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddSerialObjectPathMapping::Ipc2Bts_AddSerialObjectPathMapping(IN const Ipc2Bts_AddSerialObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddSerialObjectPathMapping& Ipc2Bts_AddSerialObjectPathMapping::operator=(IN const Ipc2Bts_AddSerialObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddSerialObjectPathMapping::~Ipc2Bts_AddSerialObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddSerialObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddSerialObjectPathMapping(*this);
}

Ipc2Bts_DelSerialObjectPathMapping::Ipc2Bts_DelSerialObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelSerialObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelSerialObjectPathMapping::Ipc2Bts_DelSerialObjectPathMapping(IN const Ipc2Bts_DelSerialObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelSerialObjectPathMapping& Ipc2Bts_DelSerialObjectPathMapping::operator=(IN const Ipc2Bts_DelSerialObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelSerialObjectPathMapping::~Ipc2Bts_DelSerialObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelSerialObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelSerialObjectPathMapping(*this);
}

Ipc2Bts_Release::Ipc2Bts_Release()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_Release))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_Release::Ipc2Bts_Release(IN const Ipc2Bts_Release& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_Release& Ipc2Bts_Release::operator=(IN const Ipc2Bts_Release& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_Release::~Ipc2Bts_Release()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_Release::clone(void) const
{
   return new Ipc2Bts_Release(*this);
}

Ipc2Bts_RequestPinCode::Ipc2Bts_RequestPinCode()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestPinCode))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestPinCode::Ipc2Bts_RequestPinCode(IN const Ipc2Bts_RequestPinCode& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_RequestPinCode& Ipc2Bts_RequestPinCode::operator=(IN const Ipc2Bts_RequestPinCode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_RequestPinCode::~Ipc2Bts_RequestPinCode()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestPinCode::clone(void) const
{
   return new Ipc2Bts_RequestPinCode(*this);
}

Ipc2Bts_DisplayPinCode::Ipc2Bts_DisplayPinCode()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DisplayPinCode))
{
   // _device: init is done by member constructor
   // _passkey: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DisplayPinCode::Ipc2Bts_DisplayPinCode(IN const Ipc2Bts_DisplayPinCode& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _passkey = ref._passkey;
}

Ipc2Bts_DisplayPinCode& Ipc2Bts_DisplayPinCode::operator=(IN const Ipc2Bts_DisplayPinCode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _passkey = ref._passkey;

   return *this;
}

Ipc2Bts_DisplayPinCode::~Ipc2Bts_DisplayPinCode()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DisplayPinCode::clone(void) const
{
   return new Ipc2Bts_DisplayPinCode(*this);
}

Ipc2Bts_RequestPasskey::Ipc2Bts_RequestPasskey()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestPasskey))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestPasskey::Ipc2Bts_RequestPasskey(IN const Ipc2Bts_RequestPasskey& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_RequestPasskey& Ipc2Bts_RequestPasskey::operator=(IN const Ipc2Bts_RequestPasskey& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_RequestPasskey::~Ipc2Bts_RequestPasskey()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestPasskey::clone(void) const
{
   return new Ipc2Bts_RequestPasskey(*this);
}

Ipc2Bts_RequestConfirmation::Ipc2Bts_RequestConfirmation()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestConfirmation))
{
   // _device: init is done by member constructor
   // _passkey: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestConfirmation::Ipc2Bts_RequestConfirmation(IN const Ipc2Bts_RequestConfirmation& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _passkey = ref._passkey;
}

Ipc2Bts_RequestConfirmation& Ipc2Bts_RequestConfirmation::operator=(IN const Ipc2Bts_RequestConfirmation& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _passkey = ref._passkey;

   return *this;
}

Ipc2Bts_RequestConfirmation::~Ipc2Bts_RequestConfirmation()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestConfirmation::clone(void) const
{
   return new Ipc2Bts_RequestConfirmation(*this);
}

Ipc2Bts_Cancel::Ipc2Bts_Cancel()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_Cancel))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_Cancel::Ipc2Bts_Cancel(IN const Ipc2Bts_Cancel& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_Cancel& Ipc2Bts_Cancel::operator=(IN const Ipc2Bts_Cancel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_Cancel::~Ipc2Bts_Cancel()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_Cancel::clone(void) const
{
   return new Ipc2Bts_Cancel(*this);
}

Ipc2Bts_CancelRequest::Ipc2Bts_CancelRequest()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CancelRequest))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CancelRequest::Ipc2Bts_CancelRequest(IN const Ipc2Bts_CancelRequest& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_CancelRequest& Ipc2Bts_CancelRequest::operator=(IN const Ipc2Bts_CancelRequest& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_CancelRequest::~Ipc2Bts_CancelRequest()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CancelRequest::clone(void) const
{
   return new Ipc2Bts_CancelRequest(*this);
}

Ipc2Bts_AuthorizeService::Ipc2Bts_AuthorizeService()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AuthorizeService))
{
   // _device: init is done by member constructor
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AuthorizeService::Ipc2Bts_AuthorizeService(IN const Ipc2Bts_AuthorizeService& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _protocol = ref._protocol;
   _uuid = ref._uuid;
}

Ipc2Bts_AuthorizeService& Ipc2Bts_AuthorizeService::operator=(IN const Ipc2Bts_AuthorizeService& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _protocol = ref._protocol;
   _uuid = ref._uuid;

   return *this;
}

Ipc2Bts_AuthorizeService::~Ipc2Bts_AuthorizeService()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AuthorizeService::clone(void) const
{
   return new Ipc2Bts_AuthorizeService(*this);
}

Ipc2Bts_RequestAuthorization::Ipc2Bts_RequestAuthorization()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestAuthorization))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestAuthorization::Ipc2Bts_RequestAuthorization(IN const Ipc2Bts_RequestAuthorization& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_RequestAuthorization& Ipc2Bts_RequestAuthorization::operator=(IN const Ipc2Bts_RequestAuthorization& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_RequestAuthorization::~Ipc2Bts_RequestAuthorization()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestAuthorization::clone(void) const
{
   return new Ipc2Bts_RequestAuthorization(*this);
}

Ipc2Bts_RequestLinkkey::Ipc2Bts_RequestLinkkey()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestLinkkey))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestLinkkey::Ipc2Bts_RequestLinkkey(IN const Ipc2Bts_RequestLinkkey& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_RequestLinkkey& Ipc2Bts_RequestLinkkey::operator=(IN const Ipc2Bts_RequestLinkkey& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_RequestLinkkey::~Ipc2Bts_RequestLinkkey()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestLinkkey::clone(void) const
{
   return new Ipc2Bts_RequestLinkkey(*this);
}

Ipc2Bts_DisplayPasskey::Ipc2Bts_DisplayPasskey()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DisplayPasskey))
{
   // _device: init is done by member constructor
   // _passkey: init is done by member constructor
   _entered = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DisplayPasskey::Ipc2Bts_DisplayPasskey(IN const Ipc2Bts_DisplayPasskey& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _passkey = ref._passkey;
   _entered = ref._entered;
}

Ipc2Bts_DisplayPasskey& Ipc2Bts_DisplayPasskey::operator=(IN const Ipc2Bts_DisplayPasskey& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _passkey = ref._passkey;
   _entered = ref._entered;

   return *this;
}

Ipc2Bts_DisplayPasskey::~Ipc2Bts_DisplayPasskey()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DisplayPasskey::clone(void) const
{
   return new Ipc2Bts_DisplayPasskey(*this);
}

Ipc2Bts_StartDiscoveryResult::Ipc2Bts_StartDiscoveryResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_StartDiscoveryResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_StartDiscoveryResult::Ipc2Bts_StartDiscoveryResult(IN const Ipc2Bts_StartDiscoveryResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_StartDiscoveryResult& Ipc2Bts_StartDiscoveryResult::operator=(IN const Ipc2Bts_StartDiscoveryResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_StartDiscoveryResult::~Ipc2Bts_StartDiscoveryResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_StartDiscoveryResult::clone(void) const
{
   return new Ipc2Bts_StartDiscoveryResult(*this);
}

Ipc2Bts_StopDiscoveryResult::Ipc2Bts_StopDiscoveryResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_StopDiscoveryResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_StopDiscoveryResult::Ipc2Bts_StopDiscoveryResult(IN const Ipc2Bts_StopDiscoveryResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_StopDiscoveryResult& Ipc2Bts_StopDiscoveryResult::operator=(IN const Ipc2Bts_StopDiscoveryResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_StopDiscoveryResult::~Ipc2Bts_StopDiscoveryResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_StopDiscoveryResult::clone(void) const
{
   return new Ipc2Bts_StopDiscoveryResult(*this);
}

Ipc2Bts_RemoveDeviceResult::Ipc2Bts_RemoveDeviceResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RemoveDeviceResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RemoveDeviceResult::Ipc2Bts_RemoveDeviceResult(IN const Ipc2Bts_RemoveDeviceResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_RemoveDeviceResult& Ipc2Bts_RemoveDeviceResult::operator=(IN const Ipc2Bts_RemoveDeviceResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_RemoveDeviceResult::~Ipc2Bts_RemoveDeviceResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RemoveDeviceResult::clone(void) const
{
   return new Ipc2Bts_RemoveDeviceResult(*this);
}

Ipc2Bts_CreateDeviceResult::Ipc2Bts_CreateDeviceResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CreateDeviceResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CreateDeviceResult::Ipc2Bts_CreateDeviceResult(IN const Ipc2Bts_CreateDeviceResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_CreateDeviceResult& Ipc2Bts_CreateDeviceResult::operator=(IN const Ipc2Bts_CreateDeviceResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_CreateDeviceResult::~Ipc2Bts_CreateDeviceResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CreateDeviceResult::clone(void) const
{
   return new Ipc2Bts_CreateDeviceResult(*this);
}

Ipc2Bts_SendHCICmdResult::Ipc2Bts_SendHCICmdResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SendHCICmdResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SendHCICmdResult::Ipc2Bts_SendHCICmdResult(IN const Ipc2Bts_SendHCICmdResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_SendHCICmdResult& Ipc2Bts_SendHCICmdResult::operator=(IN const Ipc2Bts_SendHCICmdResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_SendHCICmdResult::~Ipc2Bts_SendHCICmdResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SendHCICmdResult::clone(void) const
{
   return new Ipc2Bts_SendHCICmdResult(*this);
}

Ipc2Bts_AdapterInitialization::Ipc2Bts_AdapterInitialization()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterInitialization))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterInitialization::Ipc2Bts_AdapterInitialization(IN const Ipc2Bts_AdapterInitialization& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_AdapterInitialization& Ipc2Bts_AdapterInitialization::operator=(IN const Ipc2Bts_AdapterInitialization& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_AdapterInitialization::~Ipc2Bts_AdapterInitialization()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterInitialization::clone(void) const
{
   return new Ipc2Bts_AdapterInitialization(*this);
}

Ipc2Bts_DeviceCreated::Ipc2Bts_DeviceCreated()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceCreated))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceCreated::Ipc2Bts_DeviceCreated(IN const Ipc2Bts_DeviceCreated& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceCreated& Ipc2Bts_DeviceCreated::operator=(IN const Ipc2Bts_DeviceCreated& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceCreated::~Ipc2Bts_DeviceCreated()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceCreated::clone(void) const
{
   return new Ipc2Bts_DeviceCreated(*this);
}

Ipc2Bts_DeviceRemoved::Ipc2Bts_DeviceRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceRemoved))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceRemoved::Ipc2Bts_DeviceRemoved(IN const Ipc2Bts_DeviceRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceRemoved& Ipc2Bts_DeviceRemoved::operator=(IN const Ipc2Bts_DeviceRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceRemoved::~Ipc2Bts_DeviceRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceRemoved::clone(void) const
{
   return new Ipc2Bts_DeviceRemoved(*this);
}

Ipc2Bts_BtStackLog::Ipc2Bts_BtStackLog()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtStackLog))
{
   _status = BTS_LOG_LAST;
   _logOpcode = 0;
   _logLength = 0;
   // _logData: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtStackLog::Ipc2Bts_BtStackLog(IN const Ipc2Bts_BtStackLog& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _logOpcode = ref._logOpcode;
   _logLength = ref._logLength;
   _logData = ref._logData;
}

Ipc2Bts_BtStackLog& Ipc2Bts_BtStackLog::operator=(IN const Ipc2Bts_BtStackLog& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _logOpcode = ref._logOpcode;
   _logLength = ref._logLength;
   _logData = ref._logData;

   return *this;
}

Ipc2Bts_BtStackLog::~Ipc2Bts_BtStackLog()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtStackLog::clone(void) const
{
   return new Ipc2Bts_BtStackLog(*this);
}

Ipc2Bts_HCIEvent::Ipc2Bts_HCIEvent()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_HCIEvent))
{
   _length = 0;
   // _data: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_HCIEvent::Ipc2Bts_HCIEvent(IN const Ipc2Bts_HCIEvent& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _length = ref._length;
   _data = ref._data;
}

Ipc2Bts_HCIEvent& Ipc2Bts_HCIEvent::operator=(IN const Ipc2Bts_HCIEvent& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _length = ref._length;
   _data = ref._data;

   return *this;
}

Ipc2Bts_HCIEvent::~Ipc2Bts_HCIEvent()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_HCIEvent::clone(void) const
{
   return new Ipc2Bts_HCIEvent(*this);
}

Ipc2Bts_DeviceFound::Ipc2Bts_DeviceFound()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceFound))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceFound::Ipc2Bts_DeviceFound(IN const Ipc2Bts_DeviceFound& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceFound& Ipc2Bts_DeviceFound::operator=(IN const Ipc2Bts_DeviceFound& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceFound::~Ipc2Bts_DeviceFound()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceFound::clone(void) const
{
   return new Ipc2Bts_DeviceFound(*this);
}

Ipc2Bts_AdapterAddressUpdate::Ipc2Bts_AdapterAddressUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterAddressUpdate))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterAddressUpdate::Ipc2Bts_AdapterAddressUpdate(IN const Ipc2Bts_AdapterAddressUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_AdapterAddressUpdate& Ipc2Bts_AdapterAddressUpdate::operator=(IN const Ipc2Bts_AdapterAddressUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_AdapterAddressUpdate::~Ipc2Bts_AdapterAddressUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterAddressUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterAddressUpdate(*this);
}

Ipc2Bts_AdapterClassUpdate::Ipc2Bts_AdapterClassUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterClassUpdate))
{
   _cod = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterClassUpdate::Ipc2Bts_AdapterClassUpdate(IN const Ipc2Bts_AdapterClassUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _cod = ref._cod;
}

Ipc2Bts_AdapterClassUpdate& Ipc2Bts_AdapterClassUpdate::operator=(IN const Ipc2Bts_AdapterClassUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _cod = ref._cod;

   return *this;
}

Ipc2Bts_AdapterClassUpdate::~Ipc2Bts_AdapterClassUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterClassUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterClassUpdate(*this);
}

Ipc2Bts_AdapterAliasUpdate::Ipc2Bts_AdapterAliasUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterAliasUpdate))
{
   // _alias: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterAliasUpdate::Ipc2Bts_AdapterAliasUpdate(IN const Ipc2Bts_AdapterAliasUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _alias = ref._alias;
}

Ipc2Bts_AdapterAliasUpdate& Ipc2Bts_AdapterAliasUpdate::operator=(IN const Ipc2Bts_AdapterAliasUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _alias = ref._alias;

   return *this;
}

Ipc2Bts_AdapterAliasUpdate::~Ipc2Bts_AdapterAliasUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterAliasUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterAliasUpdate(*this);
}

Ipc2Bts_AdapterPoweredUpdate::Ipc2Bts_AdapterPoweredUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterPoweredUpdate))
{
   _powered = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterPoweredUpdate::Ipc2Bts_AdapterPoweredUpdate(IN const Ipc2Bts_AdapterPoweredUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _powered = ref._powered;
}

Ipc2Bts_AdapterPoweredUpdate& Ipc2Bts_AdapterPoweredUpdate::operator=(IN const Ipc2Bts_AdapterPoweredUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _powered = ref._powered;

   return *this;
}

Ipc2Bts_AdapterPoweredUpdate::~Ipc2Bts_AdapterPoweredUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterPoweredUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterPoweredUpdate(*this);
}

Ipc2Bts_AdapterDiscoverableUpdate::Ipc2Bts_AdapterDiscoverableUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterDiscoverableUpdate))
{
   _discoverable = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterDiscoverableUpdate::Ipc2Bts_AdapterDiscoverableUpdate(IN const Ipc2Bts_AdapterDiscoverableUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _discoverable = ref._discoverable;
}

Ipc2Bts_AdapterDiscoverableUpdate& Ipc2Bts_AdapterDiscoverableUpdate::operator=(IN const Ipc2Bts_AdapterDiscoverableUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _discoverable = ref._discoverable;

   return *this;
}

Ipc2Bts_AdapterDiscoverableUpdate::~Ipc2Bts_AdapterDiscoverableUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterDiscoverableUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterDiscoverableUpdate(*this);
}

Ipc2Bts_AdapterDiscoverabletimeoutUpdate::Ipc2Bts_AdapterDiscoverabletimeoutUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterDiscoverabletimeoutUpdate))
{
   _discoverableTimeout = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterDiscoverabletimeoutUpdate::Ipc2Bts_AdapterDiscoverabletimeoutUpdate(IN const Ipc2Bts_AdapterDiscoverabletimeoutUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _discoverableTimeout = ref._discoverableTimeout;
}

Ipc2Bts_AdapterDiscoverabletimeoutUpdate& Ipc2Bts_AdapterDiscoverabletimeoutUpdate::operator=(IN const Ipc2Bts_AdapterDiscoverabletimeoutUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _discoverableTimeout = ref._discoverableTimeout;

   return *this;
}

Ipc2Bts_AdapterDiscoverabletimeoutUpdate::~Ipc2Bts_AdapterDiscoverabletimeoutUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterDiscoverabletimeoutUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterDiscoverabletimeoutUpdate(*this);
}

Ipc2Bts_AdapterPairableUpdate::Ipc2Bts_AdapterPairableUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterPairableUpdate))
{
   _pairable = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterPairableUpdate::Ipc2Bts_AdapterPairableUpdate(IN const Ipc2Bts_AdapterPairableUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _pairable = ref._pairable;
}

Ipc2Bts_AdapterPairableUpdate& Ipc2Bts_AdapterPairableUpdate::operator=(IN const Ipc2Bts_AdapterPairableUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _pairable = ref._pairable;

   return *this;
}

Ipc2Bts_AdapterPairableUpdate::~Ipc2Bts_AdapterPairableUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterPairableUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterPairableUpdate(*this);
}

Ipc2Bts_AdapterPairabletimeoutUpdate::Ipc2Bts_AdapterPairabletimeoutUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterPairabletimeoutUpdate))
{
   _pairableTimeout = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterPairabletimeoutUpdate::Ipc2Bts_AdapterPairabletimeoutUpdate(IN const Ipc2Bts_AdapterPairabletimeoutUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _pairableTimeout = ref._pairableTimeout;
}

Ipc2Bts_AdapterPairabletimeoutUpdate& Ipc2Bts_AdapterPairabletimeoutUpdate::operator=(IN const Ipc2Bts_AdapterPairabletimeoutUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _pairableTimeout = ref._pairableTimeout;

   return *this;
}

Ipc2Bts_AdapterPairabletimeoutUpdate::~Ipc2Bts_AdapterPairabletimeoutUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterPairabletimeoutUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterPairabletimeoutUpdate(*this);
}

Ipc2Bts_AdapterDiscoveringUpdate::Ipc2Bts_AdapterDiscoveringUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterDiscoveringUpdate))
{
   _discovering = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterDiscoveringUpdate::Ipc2Bts_AdapterDiscoveringUpdate(IN const Ipc2Bts_AdapterDiscoveringUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _discovering = ref._discovering;
}

Ipc2Bts_AdapterDiscoveringUpdate& Ipc2Bts_AdapterDiscoveringUpdate::operator=(IN const Ipc2Bts_AdapterDiscoveringUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _discovering = ref._discovering;

   return *this;
}

Ipc2Bts_AdapterDiscoveringUpdate::~Ipc2Bts_AdapterDiscoveringUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterDiscoveringUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterDiscoveringUpdate(*this);
}

Ipc2Bts_AdapterUuidsUpdate::Ipc2Bts_AdapterUuidsUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterUuidsUpdate))
{
   // _uuids is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterUuidsUpdate::Ipc2Bts_AdapterUuidsUpdate(IN const Ipc2Bts_AdapterUuidsUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _uuids = ref._uuids;
}

Ipc2Bts_AdapterUuidsUpdate& Ipc2Bts_AdapterUuidsUpdate::operator=(IN const Ipc2Bts_AdapterUuidsUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _uuids = ref._uuids;

   return *this;
}

Ipc2Bts_AdapterUuidsUpdate::~Ipc2Bts_AdapterUuidsUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterUuidsUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterUuidsUpdate(*this);
}

Ipc2Bts_AdapterWbsModeUpdate::Ipc2Bts_AdapterWbsModeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterWbsModeUpdate))
{
   _wbsMode = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterWbsModeUpdate::Ipc2Bts_AdapterWbsModeUpdate(IN const Ipc2Bts_AdapterWbsModeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _wbsMode = ref._wbsMode;
}

Ipc2Bts_AdapterWbsModeUpdate& Ipc2Bts_AdapterWbsModeUpdate::operator=(IN const Ipc2Bts_AdapterWbsModeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _wbsMode = ref._wbsMode;

   return *this;
}

Ipc2Bts_AdapterWbsModeUpdate::~Ipc2Bts_AdapterWbsModeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterWbsModeUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterWbsModeUpdate(*this);
}

Ipc2Bts_AdapterConnectableUpdate::Ipc2Bts_AdapterConnectableUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterConnectableUpdate))
{
   _connectable = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterConnectableUpdate::Ipc2Bts_AdapterConnectableUpdate(IN const Ipc2Bts_AdapterConnectableUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _connectable = ref._connectable;
}

Ipc2Bts_AdapterConnectableUpdate& Ipc2Bts_AdapterConnectableUpdate::operator=(IN const Ipc2Bts_AdapterConnectableUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _connectable = ref._connectable;

   return *this;
}

Ipc2Bts_AdapterConnectableUpdate::~Ipc2Bts_AdapterConnectableUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterConnectableUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterConnectableUpdate(*this);
}

Ipc2Bts_AdapterHcimodeUpdate::Ipc2Bts_AdapterHcimodeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterHcimodeUpdate))
{
   _hciMode = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterHcimodeUpdate::Ipc2Bts_AdapterHcimodeUpdate(IN const Ipc2Bts_AdapterHcimodeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _hciMode = ref._hciMode;
}

Ipc2Bts_AdapterHcimodeUpdate& Ipc2Bts_AdapterHcimodeUpdate::operator=(IN const Ipc2Bts_AdapterHcimodeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _hciMode = ref._hciMode;

   return *this;
}

Ipc2Bts_AdapterHcimodeUpdate::~Ipc2Bts_AdapterHcimodeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterHcimodeUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterHcimodeUpdate(*this);
}

Ipc2Bts_AdapterVersionUpdate::Ipc2Bts_AdapterVersionUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterVersionUpdate))
{
   // _stackVersion: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterVersionUpdate::Ipc2Bts_AdapterVersionUpdate(IN const Ipc2Bts_AdapterVersionUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _stackVersion = ref._stackVersion;
}

Ipc2Bts_AdapterVersionUpdate& Ipc2Bts_AdapterVersionUpdate::operator=(IN const Ipc2Bts_AdapterVersionUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _stackVersion = ref._stackVersion;

   return *this;
}

Ipc2Bts_AdapterVersionUpdate::~Ipc2Bts_AdapterVersionUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterVersionUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterVersionUpdate(*this);
}

Ipc2Bts_AdapterTraceLevelUpdate::Ipc2Bts_AdapterTraceLevelUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterTraceLevelUpdate))
{
   // _traceLevel: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterTraceLevelUpdate::Ipc2Bts_AdapterTraceLevelUpdate(IN const Ipc2Bts_AdapterTraceLevelUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _traceLevel = ref._traceLevel;
}

Ipc2Bts_AdapterTraceLevelUpdate& Ipc2Bts_AdapterTraceLevelUpdate::operator=(IN const Ipc2Bts_AdapterTraceLevelUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _traceLevel = ref._traceLevel;

   return *this;
}

Ipc2Bts_AdapterTraceLevelUpdate::~Ipc2Bts_AdapterTraceLevelUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterTraceLevelUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterTraceLevelUpdate(*this);
}

Ipc2Bts_AdapterTraceCategoryUpdate::Ipc2Bts_AdapterTraceCategoryUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterTraceCategoryUpdate))
{
   // _traceCategory: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterTraceCategoryUpdate::Ipc2Bts_AdapterTraceCategoryUpdate(IN const Ipc2Bts_AdapterTraceCategoryUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _traceCategory = ref._traceCategory;
}

Ipc2Bts_AdapterTraceCategoryUpdate& Ipc2Bts_AdapterTraceCategoryUpdate::operator=(IN const Ipc2Bts_AdapterTraceCategoryUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _traceCategory = ref._traceCategory;

   return *this;
}

Ipc2Bts_AdapterTraceCategoryUpdate::~Ipc2Bts_AdapterTraceCategoryUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterTraceCategoryUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterTraceCategoryUpdate(*this);
}

Ipc2Bts_AdapterAvailableSppServersUpdate::Ipc2Bts_AdapterAvailableSppServersUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AdapterAvailableSppServersUpdate))
{
   // _availableSppServers is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AdapterAvailableSppServersUpdate::Ipc2Bts_AdapterAvailableSppServersUpdate(IN const Ipc2Bts_AdapterAvailableSppServersUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _availableSppServers = ref._availableSppServers;
}

Ipc2Bts_AdapterAvailableSppServersUpdate& Ipc2Bts_AdapterAvailableSppServersUpdate::operator=(IN const Ipc2Bts_AdapterAvailableSppServersUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _availableSppServers = ref._availableSppServers;

   return *this;
}

Ipc2Bts_AdapterAvailableSppServersUpdate::~Ipc2Bts_AdapterAvailableSppServersUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AdapterAvailableSppServersUpdate::clone(void) const
{
   return new Ipc2Bts_AdapterAvailableSppServersUpdate(*this);
}

Ipc2Bts_RegisterAgentResult::Ipc2Bts_RegisterAgentResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RegisterAgentResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RegisterAgentResult::Ipc2Bts_RegisterAgentResult(IN const Ipc2Bts_RegisterAgentResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_RegisterAgentResult& Ipc2Bts_RegisterAgentResult::operator=(IN const Ipc2Bts_RegisterAgentResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_RegisterAgentResult::~Ipc2Bts_RegisterAgentResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RegisterAgentResult::clone(void) const
{
   return new Ipc2Bts_RegisterAgentResult(*this);
}

Ipc2Bts_UnregisterAgentResult::Ipc2Bts_UnregisterAgentResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_UnregisterAgentResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_UnregisterAgentResult::Ipc2Bts_UnregisterAgentResult(IN const Ipc2Bts_UnregisterAgentResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_UnregisterAgentResult& Ipc2Bts_UnregisterAgentResult::operator=(IN const Ipc2Bts_UnregisterAgentResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_UnregisterAgentResult::~Ipc2Bts_UnregisterAgentResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_UnregisterAgentResult::clone(void) const
{
   return new Ipc2Bts_UnregisterAgentResult(*this);
}

Ipc2Bts_RequestDefaultAgentResult::Ipc2Bts_RequestDefaultAgentResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RequestDefaultAgentResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RequestDefaultAgentResult::Ipc2Bts_RequestDefaultAgentResult(IN const Ipc2Bts_RequestDefaultAgentResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_RequestDefaultAgentResult& Ipc2Bts_RequestDefaultAgentResult::operator=(IN const Ipc2Bts_RequestDefaultAgentResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_RequestDefaultAgentResult::~Ipc2Bts_RequestDefaultAgentResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RequestDefaultAgentResult::clone(void) const
{
   return new Ipc2Bts_RequestDefaultAgentResult(*this);
}

Ipc2Bts_DeviceConnectResult::Ipc2Bts_DeviceConnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceConnectResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceConnectResult::Ipc2Bts_DeviceConnectResult(IN const Ipc2Bts_DeviceConnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceConnectResult& Ipc2Bts_DeviceConnectResult::operator=(IN const Ipc2Bts_DeviceConnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceConnectResult::~Ipc2Bts_DeviceConnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceConnectResult::clone(void) const
{
   return new Ipc2Bts_DeviceConnectResult(*this);
}

Ipc2Bts_DeviceDisconnectResult::Ipc2Bts_DeviceDisconnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceDisconnectResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceDisconnectResult::Ipc2Bts_DeviceDisconnectResult(IN const Ipc2Bts_DeviceDisconnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceDisconnectResult& Ipc2Bts_DeviceDisconnectResult::operator=(IN const Ipc2Bts_DeviceDisconnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceDisconnectResult::~Ipc2Bts_DeviceDisconnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceDisconnectResult::clone(void) const
{
   return new Ipc2Bts_DeviceDisconnectResult(*this);
}

Ipc2Bts_PairResult::Ipc2Bts_PairResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_PairResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_PairResult::Ipc2Bts_PairResult(IN const Ipc2Bts_PairResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_PairResult& Ipc2Bts_PairResult::operator=(IN const Ipc2Bts_PairResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_PairResult::~Ipc2Bts_PairResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_PairResult::clone(void) const
{
   return new Ipc2Bts_PairResult(*this);
}

Ipc2Bts_CancelPairingResult::Ipc2Bts_CancelPairingResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CancelPairingResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CancelPairingResult::Ipc2Bts_CancelPairingResult(IN const Ipc2Bts_CancelPairingResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_CancelPairingResult& Ipc2Bts_CancelPairingResult::operator=(IN const Ipc2Bts_CancelPairingResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_CancelPairingResult::~Ipc2Bts_CancelPairingResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CancelPairingResult::clone(void) const
{
   return new Ipc2Bts_CancelPairingResult(*this);
}

Ipc2Bts_DiscoverServicesResult::Ipc2Bts_DiscoverServicesResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DiscoverServicesResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DiscoverServicesResult::Ipc2Bts_DiscoverServicesResult(IN const Ipc2Bts_DiscoverServicesResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DiscoverServicesResult& Ipc2Bts_DiscoverServicesResult::operator=(IN const Ipc2Bts_DiscoverServicesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DiscoverServicesResult::~Ipc2Bts_DiscoverServicesResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DiscoverServicesResult::clone(void) const
{
   return new Ipc2Bts_DiscoverServicesResult(*this);
}

Ipc2Bts_CancelDiscoveryResult::Ipc2Bts_CancelDiscoveryResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CancelDiscoveryResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CancelDiscoveryResult::Ipc2Bts_CancelDiscoveryResult(IN const Ipc2Bts_CancelDiscoveryResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_CancelDiscoveryResult& Ipc2Bts_CancelDiscoveryResult::operator=(IN const Ipc2Bts_CancelDiscoveryResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_CancelDiscoveryResult::~Ipc2Bts_CancelDiscoveryResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CancelDiscoveryResult::clone(void) const
{
   return new Ipc2Bts_CancelDiscoveryResult(*this);
}

Ipc2Bts_ReportLinkkey::Ipc2Bts_ReportLinkkey()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ReportLinkkey))
{
   // _device: init is done by member constructor
   // _linkKey: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ReportLinkkey::Ipc2Bts_ReportLinkkey(IN const Ipc2Bts_ReportLinkkey& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _linkKey = ref._linkKey;
}

Ipc2Bts_ReportLinkkey& Ipc2Bts_ReportLinkkey::operator=(IN const Ipc2Bts_ReportLinkkey& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _linkKey = ref._linkKey;

   return *this;
}

Ipc2Bts_ReportLinkkey::~Ipc2Bts_ReportLinkkey()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ReportLinkkey::clone(void) const
{
   return new Ipc2Bts_ReportLinkkey(*this);
}

Ipc2Bts_IncomingPairingComp::Ipc2Bts_IncomingPairingComp()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_IncomingPairingComp))
{
   // _device: init is done by member constructor
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_IncomingPairingComp::Ipc2Bts_IncomingPairingComp(IN const Ipc2Bts_IncomingPairingComp& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _status = ref._status;
}

Ipc2Bts_IncomingPairingComp& Ipc2Bts_IncomingPairingComp::operator=(IN const Ipc2Bts_IncomingPairingComp& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _status = ref._status;

   return *this;
}

Ipc2Bts_IncomingPairingComp::~Ipc2Bts_IncomingPairingComp()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_IncomingPairingComp::clone(void) const
{
   return new Ipc2Bts_IncomingPairingComp(*this);
}

Ipc2Bts_SDPProcessReport::Ipc2Bts_SDPProcessReport()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SDPProcessReport))
{
   // _device: init is done by member constructor
   _active = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SDPProcessReport::Ipc2Bts_SDPProcessReport(IN const Ipc2Bts_SDPProcessReport& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _active = ref._active;
}

Ipc2Bts_SDPProcessReport& Ipc2Bts_SDPProcessReport::operator=(IN const Ipc2Bts_SDPProcessReport& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _active = ref._active;

   return *this;
}

Ipc2Bts_SDPProcessReport::~Ipc2Bts_SDPProcessReport()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SDPProcessReport::clone(void) const
{
   return new Ipc2Bts_SDPProcessReport(*this);
}

Ipc2Bts_DeviceAddressUpdate::Ipc2Bts_DeviceAddressUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceAddressUpdate))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceAddressUpdate::Ipc2Bts_DeviceAddressUpdate(IN const Ipc2Bts_DeviceAddressUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_DeviceAddressUpdate& Ipc2Bts_DeviceAddressUpdate::operator=(IN const Ipc2Bts_DeviceAddressUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceAddressUpdate::~Ipc2Bts_DeviceAddressUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceAddressUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceAddressUpdate(*this);
}

Ipc2Bts_DeviceClassUpdate::Ipc2Bts_DeviceClassUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceClassUpdate))
{
   _cod = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceClassUpdate::Ipc2Bts_DeviceClassUpdate(IN const Ipc2Bts_DeviceClassUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _cod = ref._cod;
   _device = ref._device;
}

Ipc2Bts_DeviceClassUpdate& Ipc2Bts_DeviceClassUpdate::operator=(IN const Ipc2Bts_DeviceClassUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _cod = ref._cod;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceClassUpdate::~Ipc2Bts_DeviceClassUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceClassUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceClassUpdate(*this);
}

Ipc2Bts_DeviceIconUpdate::Ipc2Bts_DeviceIconUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceIconUpdate))
{
   // _icon: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceIconUpdate::Ipc2Bts_DeviceIconUpdate(IN const Ipc2Bts_DeviceIconUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _icon = ref._icon;
   _device = ref._device;
}

Ipc2Bts_DeviceIconUpdate& Ipc2Bts_DeviceIconUpdate::operator=(IN const Ipc2Bts_DeviceIconUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _icon = ref._icon;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceIconUpdate::~Ipc2Bts_DeviceIconUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceIconUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceIconUpdate(*this);
}

Ipc2Bts_DeviceUuidsUpdate::Ipc2Bts_DeviceUuidsUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceUuidsUpdate))
{
   // _supportedServices: init is done by member constructor
   // _uuidList is empty per default
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceUuidsUpdate::Ipc2Bts_DeviceUuidsUpdate(IN const Ipc2Bts_DeviceUuidsUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _supportedServices = ref._supportedServices;
   _uuidList = ref._uuidList;
   _device = ref._device;
}

Ipc2Bts_DeviceUuidsUpdate& Ipc2Bts_DeviceUuidsUpdate::operator=(IN const Ipc2Bts_DeviceUuidsUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _supportedServices = ref._supportedServices;
   _uuidList = ref._uuidList;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceUuidsUpdate::~Ipc2Bts_DeviceUuidsUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceUuidsUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceUuidsUpdate(*this);
}

Ipc2Bts_DevicePairedUpdate::Ipc2Bts_DevicePairedUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DevicePairedUpdate))
{
   _paired = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DevicePairedUpdate::Ipc2Bts_DevicePairedUpdate(IN const Ipc2Bts_DevicePairedUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _paired = ref._paired;
   _device = ref._device;
}

Ipc2Bts_DevicePairedUpdate& Ipc2Bts_DevicePairedUpdate::operator=(IN const Ipc2Bts_DevicePairedUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _paired = ref._paired;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DevicePairedUpdate::~Ipc2Bts_DevicePairedUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DevicePairedUpdate::clone(void) const
{
   return new Ipc2Bts_DevicePairedUpdate(*this);
}

Ipc2Bts_DeviceConnectedUpdate::Ipc2Bts_DeviceConnectedUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceConnectedUpdate))
{
   _connected = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceConnectedUpdate::Ipc2Bts_DeviceConnectedUpdate(IN const Ipc2Bts_DeviceConnectedUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _connected = ref._connected;
   _device = ref._device;
}

Ipc2Bts_DeviceConnectedUpdate& Ipc2Bts_DeviceConnectedUpdate::operator=(IN const Ipc2Bts_DeviceConnectedUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _connected = ref._connected;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceConnectedUpdate::~Ipc2Bts_DeviceConnectedUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceConnectedUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceConnectedUpdate(*this);
}

Ipc2Bts_DeviceTrustedUpdate::Ipc2Bts_DeviceTrustedUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceTrustedUpdate))
{
   _trusted = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceTrustedUpdate::Ipc2Bts_DeviceTrustedUpdate(IN const Ipc2Bts_DeviceTrustedUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _trusted = ref._trusted;
   _device = ref._device;
}

Ipc2Bts_DeviceTrustedUpdate& Ipc2Bts_DeviceTrustedUpdate::operator=(IN const Ipc2Bts_DeviceTrustedUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _trusted = ref._trusted;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceTrustedUpdate::~Ipc2Bts_DeviceTrustedUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceTrustedUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceTrustedUpdate(*this);
}

Ipc2Bts_DeviceBlockedUpdate::Ipc2Bts_DeviceBlockedUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceBlockedUpdate))
{
   _blocked = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceBlockedUpdate::Ipc2Bts_DeviceBlockedUpdate(IN const Ipc2Bts_DeviceBlockedUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _blocked = ref._blocked;
   _device = ref._device;
}

Ipc2Bts_DeviceBlockedUpdate& Ipc2Bts_DeviceBlockedUpdate::operator=(IN const Ipc2Bts_DeviceBlockedUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _blocked = ref._blocked;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceBlockedUpdate::~Ipc2Bts_DeviceBlockedUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceBlockedUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceBlockedUpdate(*this);
}

Ipc2Bts_DeviceAliasUpdate::Ipc2Bts_DeviceAliasUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceAliasUpdate))
{
   // _alias: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceAliasUpdate::Ipc2Bts_DeviceAliasUpdate(IN const Ipc2Bts_DeviceAliasUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _alias = ref._alias;
   _device = ref._device;
}

Ipc2Bts_DeviceAliasUpdate& Ipc2Bts_DeviceAliasUpdate::operator=(IN const Ipc2Bts_DeviceAliasUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _alias = ref._alias;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceAliasUpdate::~Ipc2Bts_DeviceAliasUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceAliasUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceAliasUpdate(*this);
}

Ipc2Bts_DeviceAdapterUpdate::Ipc2Bts_DeviceAdapterUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceAdapterUpdate))
{
   // _adapter: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceAdapterUpdate::Ipc2Bts_DeviceAdapterUpdate(IN const Ipc2Bts_DeviceAdapterUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _adapter = ref._adapter;
   _device = ref._device;
}

Ipc2Bts_DeviceAdapterUpdate& Ipc2Bts_DeviceAdapterUpdate::operator=(IN const Ipc2Bts_DeviceAdapterUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _adapter = ref._adapter;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceAdapterUpdate::~Ipc2Bts_DeviceAdapterUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceAdapterUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceAdapterUpdate(*this);
}

Ipc2Bts_DeviceModaliasUpdate::Ipc2Bts_DeviceModaliasUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceModaliasUpdate))
{
   // _modalias: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceModaliasUpdate::Ipc2Bts_DeviceModaliasUpdate(IN const Ipc2Bts_DeviceModaliasUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _modalias = ref._modalias;
   _device = ref._device;
}

Ipc2Bts_DeviceModaliasUpdate& Ipc2Bts_DeviceModaliasUpdate::operator=(IN const Ipc2Bts_DeviceModaliasUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _modalias = ref._modalias;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceModaliasUpdate::~Ipc2Bts_DeviceModaliasUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceModaliasUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceModaliasUpdate(*this);
}

Ipc2Bts_DeviceRssiUpdate::Ipc2Bts_DeviceRssiUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceRssiUpdate))
{
   _rssi = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceRssiUpdate::Ipc2Bts_DeviceRssiUpdate(IN const Ipc2Bts_DeviceRssiUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _rssi = ref._rssi;
   _device = ref._device;
}

Ipc2Bts_DeviceRssiUpdate& Ipc2Bts_DeviceRssiUpdate::operator=(IN const Ipc2Bts_DeviceRssiUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _rssi = ref._rssi;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceRssiUpdate::~Ipc2Bts_DeviceRssiUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceRssiUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceRssiUpdate(*this);
}

Ipc2Bts_DeviceVendorIdUpdate::Ipc2Bts_DeviceVendorIdUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceVendorIdUpdate))
{
   _vendorId = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceVendorIdUpdate::Ipc2Bts_DeviceVendorIdUpdate(IN const Ipc2Bts_DeviceVendorIdUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _vendorId = ref._vendorId;
   _device = ref._device;
}

Ipc2Bts_DeviceVendorIdUpdate& Ipc2Bts_DeviceVendorIdUpdate::operator=(IN const Ipc2Bts_DeviceVendorIdUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _vendorId = ref._vendorId;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceVendorIdUpdate::~Ipc2Bts_DeviceVendorIdUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceVendorIdUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceVendorIdUpdate(*this);
}

Ipc2Bts_DeviceVendorIdSourceUpdate::Ipc2Bts_DeviceVendorIdSourceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceVendorIdSourceUpdate))
{
   _vendorIdSource = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceVendorIdSourceUpdate::Ipc2Bts_DeviceVendorIdSourceUpdate(IN const Ipc2Bts_DeviceVendorIdSourceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _vendorIdSource = ref._vendorIdSource;
   _device = ref._device;
}

Ipc2Bts_DeviceVendorIdSourceUpdate& Ipc2Bts_DeviceVendorIdSourceUpdate::operator=(IN const Ipc2Bts_DeviceVendorIdSourceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _vendorIdSource = ref._vendorIdSource;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceVendorIdSourceUpdate::~Ipc2Bts_DeviceVendorIdSourceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceVendorIdSourceUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceVendorIdSourceUpdate(*this);
}

Ipc2Bts_DeviceProductIdUpdate::Ipc2Bts_DeviceProductIdUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceProductIdUpdate))
{
   _productId = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceProductIdUpdate::Ipc2Bts_DeviceProductIdUpdate(IN const Ipc2Bts_DeviceProductIdUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _productId = ref._productId;
   _device = ref._device;
}

Ipc2Bts_DeviceProductIdUpdate& Ipc2Bts_DeviceProductIdUpdate::operator=(IN const Ipc2Bts_DeviceProductIdUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _productId = ref._productId;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceProductIdUpdate::~Ipc2Bts_DeviceProductIdUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceProductIdUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceProductIdUpdate(*this);
}

Ipc2Bts_DeviceMapInfoUpdate::Ipc2Bts_DeviceMapInfoUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceMapInfoUpdate))
{
   _valid = false;
   // _mapInfoList is empty per default
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceMapInfoUpdate::Ipc2Bts_DeviceMapInfoUpdate(IN const Ipc2Bts_DeviceMapInfoUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _valid = ref._valid;
   _mapInfoList = ref._mapInfoList;
   _device = ref._device;
}

Ipc2Bts_DeviceMapInfoUpdate& Ipc2Bts_DeviceMapInfoUpdate::operator=(IN const Ipc2Bts_DeviceMapInfoUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _valid = ref._valid;
   _mapInfoList = ref._mapInfoList;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceMapInfoUpdate::~Ipc2Bts_DeviceMapInfoUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceMapInfoUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceMapInfoUpdate(*this);
}

Ipc2Bts_DeviceConnectedServiceUpdate::Ipc2Bts_DeviceConnectedServiceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceConnectedServiceUpdate))
{
   // _connectedService: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceConnectedServiceUpdate::Ipc2Bts_DeviceConnectedServiceUpdate(IN const Ipc2Bts_DeviceConnectedServiceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _connectedService = ref._connectedService;
   _device = ref._device;
}

Ipc2Bts_DeviceConnectedServiceUpdate& Ipc2Bts_DeviceConnectedServiceUpdate::operator=(IN const Ipc2Bts_DeviceConnectedServiceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _connectedService = ref._connectedService;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceConnectedServiceUpdate::~Ipc2Bts_DeviceConnectedServiceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceConnectedServiceUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceConnectedServiceUpdate(*this);
}

Ipc2Bts_DeviceVersionUpdate::Ipc2Bts_DeviceVersionUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceVersionUpdate))
{
   _version = 0;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceVersionUpdate::Ipc2Bts_DeviceVersionUpdate(IN const Ipc2Bts_DeviceVersionUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _version = ref._version;
   _device = ref._device;
}

Ipc2Bts_DeviceVersionUpdate& Ipc2Bts_DeviceVersionUpdate::operator=(IN const Ipc2Bts_DeviceVersionUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _version = ref._version;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceVersionUpdate::~Ipc2Bts_DeviceVersionUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceVersionUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceVersionUpdate(*this);
}

Ipc2Bts_DevicePbapInfoUpdate::Ipc2Bts_DevicePbapInfoUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DevicePbapInfoUpdate))
{
   _valid = false;
   // _pbapInfo: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DevicePbapInfoUpdate::Ipc2Bts_DevicePbapInfoUpdate(IN const Ipc2Bts_DevicePbapInfoUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _valid = ref._valid;
   _pbapInfo = ref._pbapInfo;
   _device = ref._device;
}

Ipc2Bts_DevicePbapInfoUpdate& Ipc2Bts_DevicePbapInfoUpdate::operator=(IN const Ipc2Bts_DevicePbapInfoUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _valid = ref._valid;
   _pbapInfo = ref._pbapInfo;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DevicePbapInfoUpdate::~Ipc2Bts_DevicePbapInfoUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DevicePbapInfoUpdate::clone(void) const
{
   return new Ipc2Bts_DevicePbapInfoUpdate(*this);
}

Ipc2Bts_DeviceModeUpdate::Ipc2Bts_DeviceModeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceModeUpdate))
{
   _mode = BTS_BT_POWER_MODE_LAST;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceModeUpdate::Ipc2Bts_DeviceModeUpdate(IN const Ipc2Bts_DeviceModeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _mode = ref._mode;
   _device = ref._device;
}

Ipc2Bts_DeviceModeUpdate& Ipc2Bts_DeviceModeUpdate::operator=(IN const Ipc2Bts_DeviceModeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _mode = ref._mode;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceModeUpdate::~Ipc2Bts_DeviceModeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceModeUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceModeUpdate(*this);
}

Ipc2Bts_DeviceRoleUpdate::Ipc2Bts_DeviceRoleUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceRoleUpdate))
{
   _master = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceRoleUpdate::Ipc2Bts_DeviceRoleUpdate(IN const Ipc2Bts_DeviceRoleUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _master = ref._master;
   _device = ref._device;
}

Ipc2Bts_DeviceRoleUpdate& Ipc2Bts_DeviceRoleUpdate::operator=(IN const Ipc2Bts_DeviceRoleUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _master = ref._master;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceRoleUpdate::~Ipc2Bts_DeviceRoleUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceRoleUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceRoleUpdate(*this);
}

Ipc2Bts_DeviceEnableAvpPauseUpdate::Ipc2Bts_DeviceEnableAvpPauseUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DeviceEnableAvpPauseUpdate))
{
   _enableAvpPause = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DeviceEnableAvpPauseUpdate::Ipc2Bts_DeviceEnableAvpPauseUpdate(IN const Ipc2Bts_DeviceEnableAvpPauseUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _enableAvpPause = ref._enableAvpPause;
   _device = ref._device;
}

Ipc2Bts_DeviceEnableAvpPauseUpdate& Ipc2Bts_DeviceEnableAvpPauseUpdate::operator=(IN const Ipc2Bts_DeviceEnableAvpPauseUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _enableAvpPause = ref._enableAvpPause;
   _device = ref._device;

   return *this;
}

Ipc2Bts_DeviceEnableAvpPauseUpdate::~Ipc2Bts_DeviceEnableAvpPauseUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DeviceEnableAvpPauseUpdate::clone(void) const
{
   return new Ipc2Bts_DeviceEnableAvpPauseUpdate(*this);
}

Ipc2Bts_BtApplDeviceConnectReqResult::Ipc2Bts_BtApplDeviceConnectReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceConnectReqResult))
{
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceConnectReqResult::Ipc2Bts_BtApplDeviceConnectReqResult(IN const Ipc2Bts_BtApplDeviceConnectReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceConnectReqResult& Ipc2Bts_BtApplDeviceConnectReqResult::operator=(IN const Ipc2Bts_BtApplDeviceConnectReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceConnectReqResult::~Ipc2Bts_BtApplDeviceConnectReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceConnectReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceConnectReqResult(*this);
}

Ipc2Bts_BtApplDeviceDisconnectReqResult::Ipc2Bts_BtApplDeviceDisconnectReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceDisconnectReqResult))
{
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceDisconnectReqResult::Ipc2Bts_BtApplDeviceDisconnectReqResult(IN const Ipc2Bts_BtApplDeviceDisconnectReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceDisconnectReqResult& Ipc2Bts_BtApplDeviceDisconnectReqResult::operator=(IN const Ipc2Bts_BtApplDeviceDisconnectReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceDisconnectReqResult::~Ipc2Bts_BtApplDeviceDisconnectReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceDisconnectReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceDisconnectReqResult(*this);
}

Ipc2Bts_BtApplCancelConnectReqResult::Ipc2Bts_BtApplCancelConnectReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplCancelConnectReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplCancelConnectReqResult::Ipc2Bts_BtApplCancelConnectReqResult(IN const Ipc2Bts_BtApplCancelConnectReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplCancelConnectReqResult& Ipc2Bts_BtApplCancelConnectReqResult::operator=(IN const Ipc2Bts_BtApplCancelConnectReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplCancelConnectReqResult::~Ipc2Bts_BtApplCancelConnectReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplCancelConnectReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplCancelConnectReqResult(*this);
}

Ipc2Bts_BtApplGetHwVersionReqResult::Ipc2Bts_BtApplGetHwVersionReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplGetHwVersionReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplGetHwVersionReqResult::Ipc2Bts_BtApplGetHwVersionReqResult(IN const Ipc2Bts_BtApplGetHwVersionReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplGetHwVersionReqResult& Ipc2Bts_BtApplGetHwVersionReqResult::operator=(IN const Ipc2Bts_BtApplGetHwVersionReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplGetHwVersionReqResult::~Ipc2Bts_BtApplGetHwVersionReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplGetHwVersionReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplGetHwVersionReqResult(*this);
}

Ipc2Bts_BtApplSetConfigurationReqResult::Ipc2Bts_BtApplSetConfigurationReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplSetConfigurationReqResult))
{
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplSetConfigurationReqResult::Ipc2Bts_BtApplSetConfigurationReqResult(IN const Ipc2Bts_BtApplSetConfigurationReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _instance = ref._instance;
   _configId = ref._configId;
}

Ipc2Bts_BtApplSetConfigurationReqResult& Ipc2Bts_BtApplSetConfigurationReqResult::operator=(IN const Ipc2Bts_BtApplSetConfigurationReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _configId = ref._configId;

   return *this;
}

Ipc2Bts_BtApplSetConfigurationReqResult::~Ipc2Bts_BtApplSetConfigurationReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplSetConfigurationReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplSetConfigurationReqResult(*this);
}

Ipc2Bts_BtApplReadConfigurationReqResult::Ipc2Bts_BtApplReadConfigurationReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplReadConfigurationReqResult))
{
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplReadConfigurationReqResult::Ipc2Bts_BtApplReadConfigurationReqResult(IN const Ipc2Bts_BtApplReadConfigurationReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _instance = ref._instance;
   _configId = ref._configId;
}

Ipc2Bts_BtApplReadConfigurationReqResult& Ipc2Bts_BtApplReadConfigurationReqResult::operator=(IN const Ipc2Bts_BtApplReadConfigurationReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _configId = ref._configId;

   return *this;
}

Ipc2Bts_BtApplReadConfigurationReqResult::~Ipc2Bts_BtApplReadConfigurationReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplReadConfigurationReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplReadConfigurationReqResult(*this);
}

Ipc2Bts_BtApplTestModeReqResult::Ipc2Bts_BtApplTestModeReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplTestModeReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplTestModeReqResult::Ipc2Bts_BtApplTestModeReqResult(IN const Ipc2Bts_BtApplTestModeReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplTestModeReqResult& Ipc2Bts_BtApplTestModeReqResult::operator=(IN const Ipc2Bts_BtApplTestModeReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplTestModeReqResult::~Ipc2Bts_BtApplTestModeReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplTestModeReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplTestModeReqResult(*this);
}

Ipc2Bts_BtApplTestModeLinkQualityReqResult::Ipc2Bts_BtApplTestModeLinkQualityReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplTestModeLinkQualityReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplTestModeLinkQualityReqResult::Ipc2Bts_BtApplTestModeLinkQualityReqResult(IN const Ipc2Bts_BtApplTestModeLinkQualityReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplTestModeLinkQualityReqResult& Ipc2Bts_BtApplTestModeLinkQualityReqResult::operator=(IN const Ipc2Bts_BtApplTestModeLinkQualityReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplTestModeLinkQualityReqResult::~Ipc2Bts_BtApplTestModeLinkQualityReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplTestModeLinkQualityReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplTestModeLinkQualityReqResult(*this);
}

Ipc2Bts_BtApplDeviceConnectCfm::Ipc2Bts_BtApplDeviceConnectCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceConnectCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceConnectCfm::Ipc2Bts_BtApplDeviceConnectCfm(IN const Ipc2Bts_BtApplDeviceConnectCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceConnectCfm& Ipc2Bts_BtApplDeviceConnectCfm::operator=(IN const Ipc2Bts_BtApplDeviceConnectCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceConnectCfm::~Ipc2Bts_BtApplDeviceConnectCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceConnectCfm::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceConnectCfm(*this);
}

Ipc2Bts_BtApplDeviceConnectInd::Ipc2Bts_BtApplDeviceConnectInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceConnectInd))
{
   _status = BTS_STATUS_CODE_LAST;
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceConnectInd::Ipc2Bts_BtApplDeviceConnectInd(IN const Ipc2Bts_BtApplDeviceConnectInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
}

Ipc2Bts_BtApplDeviceConnectInd& Ipc2Bts_BtApplDeviceConnectInd::operator=(IN const Ipc2Bts_BtApplDeviceConnectInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;

   return *this;
}

Ipc2Bts_BtApplDeviceConnectInd::~Ipc2Bts_BtApplDeviceConnectInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceConnectInd::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceConnectInd(*this);
}

Ipc2Bts_BtApplDeviceDisconnectCfm::Ipc2Bts_BtApplDeviceDisconnectCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceDisconnectCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceDisconnectCfm::Ipc2Bts_BtApplDeviceDisconnectCfm(IN const Ipc2Bts_BtApplDeviceDisconnectCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceDisconnectCfm& Ipc2Bts_BtApplDeviceDisconnectCfm::operator=(IN const Ipc2Bts_BtApplDeviceDisconnectCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceDisconnectCfm::~Ipc2Bts_BtApplDeviceDisconnectCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceDisconnectCfm::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceDisconnectCfm(*this);
}

Ipc2Bts_BtApplDeviceDisconnectInd::Ipc2Bts_BtApplDeviceDisconnectInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceDisconnectInd))
{
   _status = BTS_STATUS_CODE_LAST;
   _reason = BTS_BT_APPL_DISCONNECT_REASON_LAST;
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceDisconnectInd::Ipc2Bts_BtApplDeviceDisconnectInd(IN const Ipc2Bts_BtApplDeviceDisconnectInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _reason = ref._reason;
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
}

Ipc2Bts_BtApplDeviceDisconnectInd& Ipc2Bts_BtApplDeviceDisconnectInd::operator=(IN const Ipc2Bts_BtApplDeviceDisconnectInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _reason = ref._reason;
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;

   return *this;
}

Ipc2Bts_BtApplDeviceDisconnectInd::~Ipc2Bts_BtApplDeviceDisconnectInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceDisconnectInd::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceDisconnectInd(*this);
}

Ipc2Bts_BtApplDeviceDisconnectCompInd::Ipc2Bts_BtApplDeviceDisconnectCompInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceDisconnectCompInd))
{
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceDisconnectCompInd::Ipc2Bts_BtApplDeviceDisconnectCompInd(IN const Ipc2Bts_BtApplDeviceDisconnectCompInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceDisconnectCompInd& Ipc2Bts_BtApplDeviceDisconnectCompInd::operator=(IN const Ipc2Bts_BtApplDeviceDisconnectCompInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceDisconnectCompInd::~Ipc2Bts_BtApplDeviceDisconnectCompInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceDisconnectCompInd::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceDisconnectCompInd(*this);
}

Ipc2Bts_BtApplDeviceConnectCompInd::Ipc2Bts_BtApplDeviceConnectCompInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDeviceConnectCompInd))
{
   _opId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDeviceConnectCompInd::Ipc2Bts_BtApplDeviceConnectCompInd(IN const Ipc2Bts_BtApplDeviceConnectCompInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _opId = ref._opId;
}

Ipc2Bts_BtApplDeviceConnectCompInd& Ipc2Bts_BtApplDeviceConnectCompInd::operator=(IN const Ipc2Bts_BtApplDeviceConnectCompInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _opId = ref._opId;

   return *this;
}

Ipc2Bts_BtApplDeviceConnectCompInd::~Ipc2Bts_BtApplDeviceConnectCompInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDeviceConnectCompInd::clone(void) const
{
   return new Ipc2Bts_BtApplDeviceConnectCompInd(*this);
}

Ipc2Bts_BtApplCancelConnectCfm::Ipc2Bts_BtApplCancelConnectCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplCancelConnectCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplCancelConnectCfm::Ipc2Bts_BtApplCancelConnectCfm(IN const Ipc2Bts_BtApplCancelConnectCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
}

Ipc2Bts_BtApplCancelConnectCfm& Ipc2Bts_BtApplCancelConnectCfm::operator=(IN const Ipc2Bts_BtApplCancelConnectCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;

   return *this;
}

Ipc2Bts_BtApplCancelConnectCfm::~Ipc2Bts_BtApplCancelConnectCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplCancelConnectCfm::clone(void) const
{
   return new Ipc2Bts_BtApplCancelConnectCfm(*this);
}

Ipc2Bts_BtApplStatusNotificationInd::Ipc2Bts_BtApplStatusNotificationInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplStatusNotificationInd))
{
   // _deviceName: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplStatusNotificationInd::Ipc2Bts_BtApplStatusNotificationInd(IN const Ipc2Bts_BtApplStatusNotificationInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
}

Ipc2Bts_BtApplStatusNotificationInd& Ipc2Bts_BtApplStatusNotificationInd::operator=(IN const Ipc2Bts_BtApplStatusNotificationInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;

   return *this;
}

Ipc2Bts_BtApplStatusNotificationInd::~Ipc2Bts_BtApplStatusNotificationInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplStatusNotificationInd::clone(void) const
{
   return new Ipc2Bts_BtApplStatusNotificationInd(*this);
}

Ipc2Bts_BtApplGetHwVersionCfm::Ipc2Bts_BtApplGetHwVersionCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplGetHwVersionCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _btCoreVersion = BTS_BT_CORE_LAST;
   _manufacturer = 0;
   _hwSubVersion = 0;
   // _extInfo: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplGetHwVersionCfm::Ipc2Bts_BtApplGetHwVersionCfm(IN const Ipc2Bts_BtApplGetHwVersionCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _btCoreVersion = ref._btCoreVersion;
   _manufacturer = ref._manufacturer;
   _hwSubVersion = ref._hwSubVersion;
   _extInfo = ref._extInfo;
}

Ipc2Bts_BtApplGetHwVersionCfm& Ipc2Bts_BtApplGetHwVersionCfm::operator=(IN const Ipc2Bts_BtApplGetHwVersionCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _btCoreVersion = ref._btCoreVersion;
   _manufacturer = ref._manufacturer;
   _hwSubVersion = ref._hwSubVersion;
   _extInfo = ref._extInfo;

   return *this;
}

Ipc2Bts_BtApplGetHwVersionCfm::~Ipc2Bts_BtApplGetHwVersionCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplGetHwVersionCfm::clone(void) const
{
   return new Ipc2Bts_BtApplGetHwVersionCfm(*this);
}

Ipc2Bts_BtApplSetConfigurationCfm::Ipc2Bts_BtApplSetConfigurationCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplSetConfigurationCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplSetConfigurationCfm::Ipc2Bts_BtApplSetConfigurationCfm(IN const Ipc2Bts_BtApplSetConfigurationCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _instance = ref._instance;
   _configId = ref._configId;
}

Ipc2Bts_BtApplSetConfigurationCfm& Ipc2Bts_BtApplSetConfigurationCfm::operator=(IN const Ipc2Bts_BtApplSetConfigurationCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _instance = ref._instance;
   _configId = ref._configId;

   return *this;
}

Ipc2Bts_BtApplSetConfigurationCfm::~Ipc2Bts_BtApplSetConfigurationCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplSetConfigurationCfm::clone(void) const
{
   return new Ipc2Bts_BtApplSetConfigurationCfm(*this);
}

Ipc2Bts_BtApplReadConfigurationCfm::Ipc2Bts_BtApplReadConfigurationCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplReadConfigurationCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   // _data: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplReadConfigurationCfm::Ipc2Bts_BtApplReadConfigurationCfm(IN const Ipc2Bts_BtApplReadConfigurationCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _instance = ref._instance;
   _configId = ref._configId;
   _data = ref._data;
}

Ipc2Bts_BtApplReadConfigurationCfm& Ipc2Bts_BtApplReadConfigurationCfm::operator=(IN const Ipc2Bts_BtApplReadConfigurationCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _instance = ref._instance;
   _configId = ref._configId;
   _data = ref._data;

   return *this;
}

Ipc2Bts_BtApplReadConfigurationCfm::~Ipc2Bts_BtApplReadConfigurationCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplReadConfigurationCfm::clone(void) const
{
   return new Ipc2Bts_BtApplReadConfigurationCfm(*this);
}

Ipc2Bts_BtApplTestModeCfm::Ipc2Bts_BtApplTestModeCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplTestModeCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplTestModeCfm::Ipc2Bts_BtApplTestModeCfm(IN const Ipc2Bts_BtApplTestModeCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
}

Ipc2Bts_BtApplTestModeCfm& Ipc2Bts_BtApplTestModeCfm::operator=(IN const Ipc2Bts_BtApplTestModeCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;

   return *this;
}

Ipc2Bts_BtApplTestModeCfm::~Ipc2Bts_BtApplTestModeCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplTestModeCfm::clone(void) const
{
   return new Ipc2Bts_BtApplTestModeCfm(*this);
}

Ipc2Bts_BtApplTestModeCompInd::Ipc2Bts_BtApplTestModeCompInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplTestModeCompInd))
{
   _enable = false;
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplTestModeCompInd::Ipc2Bts_BtApplTestModeCompInd(IN const Ipc2Bts_BtApplTestModeCompInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _enable = ref._enable;
   _status = ref._status;
}

Ipc2Bts_BtApplTestModeCompInd& Ipc2Bts_BtApplTestModeCompInd::operator=(IN const Ipc2Bts_BtApplTestModeCompInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _enable = ref._enable;
   _status = ref._status;

   return *this;
}

Ipc2Bts_BtApplTestModeCompInd::~Ipc2Bts_BtApplTestModeCompInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplTestModeCompInd::clone(void) const
{
   return new Ipc2Bts_BtApplTestModeCompInd(*this);
}

Ipc2Bts_BtApplTestModeLinkQualityCfm::Ipc2Bts_BtApplTestModeLinkQualityCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplTestModeLinkQualityCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   _rssi = 0;
   _linkQuality = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplTestModeLinkQualityCfm::Ipc2Bts_BtApplTestModeLinkQualityCfm(IN const Ipc2Bts_BtApplTestModeLinkQualityCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;
}

Ipc2Bts_BtApplTestModeLinkQualityCfm& Ipc2Bts_BtApplTestModeLinkQualityCfm::operator=(IN const Ipc2Bts_BtApplTestModeLinkQualityCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _rssi = ref._rssi;
   _linkQuality = ref._linkQuality;

   return *this;
}

Ipc2Bts_BtApplTestModeLinkQualityCfm::~Ipc2Bts_BtApplTestModeLinkQualityCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplTestModeLinkQualityCfm::clone(void) const
{
   return new Ipc2Bts_BtApplTestModeLinkQualityCfm(*this);
}

Ipc2Bts_ConnectResult::Ipc2Bts_ConnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnectResult))
{
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnectResult::Ipc2Bts_ConnectResult(IN const Ipc2Bts_ConnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _service = ref._service;
}

Ipc2Bts_ConnectResult& Ipc2Bts_ConnectResult::operator=(IN const Ipc2Bts_ConnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _service = ref._service;

   return *this;
}

Ipc2Bts_ConnectResult::~Ipc2Bts_ConnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnectResult::clone(void) const
{
   return new Ipc2Bts_ConnectResult(*this);
}

Ipc2Bts_DisconnectResult::Ipc2Bts_DisconnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DisconnectResult))
{
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DisconnectResult::Ipc2Bts_DisconnectResult(IN const Ipc2Bts_DisconnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _service = ref._service;
}

Ipc2Bts_DisconnectResult& Ipc2Bts_DisconnectResult::operator=(IN const Ipc2Bts_DisconnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _service = ref._service;

   return *this;
}

Ipc2Bts_DisconnectResult::~Ipc2Bts_DisconnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DisconnectResult::clone(void) const
{
   return new Ipc2Bts_DisconnectResult(*this);
}

Ipc2Bts_ServiceRemoteUuidUpdate::Ipc2Bts_ServiceRemoteUuidUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceRemoteUuidUpdate))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ServiceRemoteUuidUpdate::Ipc2Bts_ServiceRemoteUuidUpdate(IN const Ipc2Bts_ServiceRemoteUuidUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Ipc2Bts_ServiceRemoteUuidUpdate& Ipc2Bts_ServiceRemoteUuidUpdate::operator=(IN const Ipc2Bts_ServiceRemoteUuidUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Ipc2Bts_ServiceRemoteUuidUpdate::~Ipc2Bts_ServiceRemoteUuidUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceRemoteUuidUpdate::clone(void) const
{
   return new Ipc2Bts_ServiceRemoteUuidUpdate(*this);
}

Ipc2Bts_ServiceStateUpdate::Ipc2Bts_ServiceStateUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceStateUpdate))
{
   _serviceState = BTS_SERVICE_STATE_LAST;
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ServiceStateUpdate::Ipc2Bts_ServiceStateUpdate(IN const Ipc2Bts_ServiceStateUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _serviceState = ref._serviceState;
   _service = ref._service;
}

Ipc2Bts_ServiceStateUpdate& Ipc2Bts_ServiceStateUpdate::operator=(IN const Ipc2Bts_ServiceStateUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _serviceState = ref._serviceState;
   _service = ref._service;

   return *this;
}

Ipc2Bts_ServiceStateUpdate::~Ipc2Bts_ServiceStateUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceStateUpdate::clone(void) const
{
   return new Ipc2Bts_ServiceStateUpdate(*this);
}

Ipc2Bts_ServiceDeviceUpdate::Ipc2Bts_ServiceDeviceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceDeviceUpdate))
{
   // _device: init is done by member constructor
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ServiceDeviceUpdate::Ipc2Bts_ServiceDeviceUpdate(IN const Ipc2Bts_ServiceDeviceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _service = ref._service;
}

Ipc2Bts_ServiceDeviceUpdate& Ipc2Bts_ServiceDeviceUpdate::operator=(IN const Ipc2Bts_ServiceDeviceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _service = ref._service;

   return *this;
}

Ipc2Bts_ServiceDeviceUpdate::~Ipc2Bts_ServiceDeviceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceDeviceUpdate::clone(void) const
{
   return new Ipc2Bts_ServiceDeviceUpdate(*this);
}

Ipc2Bts_ServiceVersionUpdate::Ipc2Bts_ServiceVersionUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ServiceVersionUpdate))
{
   _version = 0;
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ServiceVersionUpdate::Ipc2Bts_ServiceVersionUpdate(IN const Ipc2Bts_ServiceVersionUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _version = ref._version;
   _service = ref._service;
}

Ipc2Bts_ServiceVersionUpdate& Ipc2Bts_ServiceVersionUpdate::operator=(IN const Ipc2Bts_ServiceVersionUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _version = ref._version;
   _service = ref._service;

   return *this;
}

Ipc2Bts_ServiceVersionUpdate::~Ipc2Bts_ServiceVersionUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ServiceVersionUpdate::clone(void) const
{
   return new Ipc2Bts_ServiceVersionUpdate(*this);
}

Ipc2Bts_DebugTraceConfigResult::Ipc2Bts_DebugTraceConfigResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DebugTraceConfigResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DebugTraceConfigResult::Ipc2Bts_DebugTraceConfigResult(IN const Ipc2Bts_DebugTraceConfigResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_DebugTraceConfigResult& Ipc2Bts_DebugTraceConfigResult::operator=(IN const Ipc2Bts_DebugTraceConfigResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_DebugTraceConfigResult::~Ipc2Bts_DebugTraceConfigResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DebugTraceConfigResult::clone(void) const
{
   return new Ipc2Bts_DebugTraceConfigResult(*this);
}

Ipc2Bts_ProtocolTraceConfigResult::Ipc2Bts_ProtocolTraceConfigResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ProtocolTraceConfigResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ProtocolTraceConfigResult::Ipc2Bts_ProtocolTraceConfigResult(IN const Ipc2Bts_ProtocolTraceConfigResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_ProtocolTraceConfigResult& Ipc2Bts_ProtocolTraceConfigResult::operator=(IN const Ipc2Bts_ProtocolTraceConfigResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_ProtocolTraceConfigResult::~Ipc2Bts_ProtocolTraceConfigResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ProtocolTraceConfigResult::clone(void) const
{
   return new Ipc2Bts_ProtocolTraceConfigResult(*this);
}

Ipc2Bts_ReportDebugTrace::Ipc2Bts_ReportDebugTrace()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ReportDebugTrace))
{
   _traceLocation = 0;
   _traceLevel = 0;
   _traceCategory = BTS_DEBUG_TRACE_CAT_LAST;
   _errorCode = 0;
   _traceLength = 0;
   // _traceData: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ReportDebugTrace::Ipc2Bts_ReportDebugTrace(IN const Ipc2Bts_ReportDebugTrace& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _traceLocation = ref._traceLocation;
   _traceLevel = ref._traceLevel;
   _traceCategory = ref._traceCategory;
   _errorCode = ref._errorCode;
   _traceLength = ref._traceLength;
   _traceData = ref._traceData;
}

Ipc2Bts_ReportDebugTrace& Ipc2Bts_ReportDebugTrace::operator=(IN const Ipc2Bts_ReportDebugTrace& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _traceLocation = ref._traceLocation;
   _traceLevel = ref._traceLevel;
   _traceCategory = ref._traceCategory;
   _errorCode = ref._errorCode;
   _traceLength = ref._traceLength;
   _traceData = ref._traceData;

   return *this;
}

Ipc2Bts_ReportDebugTrace::~Ipc2Bts_ReportDebugTrace()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ReportDebugTrace::clone(void) const
{
   return new Ipc2Bts_ReportDebugTrace(*this);
}

Ipc2Bts_ReportProtocolTrace::Ipc2Bts_ReportProtocolTrace()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ReportProtocolTrace))
{
   _traceType = 0;
   _traceDirection = BTS_DEBUG_TRACE_DIRECTION_LAST;
   _traceLength = 0;
   // _traceData: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ReportProtocolTrace::Ipc2Bts_ReportProtocolTrace(IN const Ipc2Bts_ReportProtocolTrace& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _traceType = ref._traceType;
   _traceDirection = ref._traceDirection;
   _traceLength = ref._traceLength;
   _traceData = ref._traceData;
}

Ipc2Bts_ReportProtocolTrace& Ipc2Bts_ReportProtocolTrace::operator=(IN const Ipc2Bts_ReportProtocolTrace& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _traceType = ref._traceType;
   _traceDirection = ref._traceDirection;
   _traceLength = ref._traceLength;
   _traceData = ref._traceData;

   return *this;
}

Ipc2Bts_ReportProtocolTrace::~Ipc2Bts_ReportProtocolTrace()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ReportProtocolTrace::clone(void) const
{
   return new Ipc2Bts_ReportProtocolTrace(*this);
}

Ipc2Bts_FatalError::Ipc2Bts_FatalError()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_FatalError))
{
   _errLocation = 0;
   _errType = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_FatalError::Ipc2Bts_FatalError(IN const Ipc2Bts_FatalError& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _errLocation = ref._errLocation;
   _errType = ref._errType;
}

Ipc2Bts_FatalError& Ipc2Bts_FatalError::operator=(IN const Ipc2Bts_FatalError& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _errLocation = ref._errLocation;
   _errType = ref._errType;

   return *this;
}

Ipc2Bts_FatalError::~Ipc2Bts_FatalError()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_FatalError::clone(void) const
{
   return new Ipc2Bts_FatalError(*this);
}

Ipc2Bts_GeneralError::Ipc2Bts_GeneralError()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GeneralError))
{
   _status = BTS_STATUS_CODE_LAST;
   _binaryStatus = 0;
   _opcode = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GeneralError::Ipc2Bts_GeneralError(IN const Ipc2Bts_GeneralError& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _binaryStatus = ref._binaryStatus;
   _opcode = ref._opcode;
}

Ipc2Bts_GeneralError& Ipc2Bts_GeneralError::operator=(IN const Ipc2Bts_GeneralError& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _binaryStatus = ref._binaryStatus;
   _opcode = ref._opcode;

   return *this;
}

Ipc2Bts_GeneralError::~Ipc2Bts_GeneralError()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GeneralError::clone(void) const
{
   return new Ipc2Bts_GeneralError(*this);
}

Ipc2Bts_ReportGeniviDebugTrace::Ipc2Bts_ReportGeniviDebugTrace()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ReportGeniviDebugTrace))
{
   _errFile = 0;
   _errLine = 0;
   _level = 0;
   _category = 0;
   _errorCode = 0;
   // _data: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ReportGeniviDebugTrace::Ipc2Bts_ReportGeniviDebugTrace(IN const Ipc2Bts_ReportGeniviDebugTrace& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _errFile = ref._errFile;
   _errLine = ref._errLine;
   _level = ref._level;
   _category = ref._category;
   _errorCode = ref._errorCode;
   _data = ref._data;
}

Ipc2Bts_ReportGeniviDebugTrace& Ipc2Bts_ReportGeniviDebugTrace::operator=(IN const Ipc2Bts_ReportGeniviDebugTrace& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _errFile = ref._errFile;
   _errLine = ref._errLine;
   _level = ref._level;
   _category = ref._category;
   _errorCode = ref._errorCode;
   _data = ref._data;

   return *this;
}

Ipc2Bts_ReportGeniviDebugTrace::~Ipc2Bts_ReportGeniviDebugTrace()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ReportGeniviDebugTrace::clone(void) const
{
   return new Ipc2Bts_ReportGeniviDebugTrace(*this);
}

Ipc2Bts_GeniviFatalError::Ipc2Bts_GeniviFatalError()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GeniviFatalError))
{
   _errFile = 0;
   _errLine = 0;
   _errCode = 0;
   // _fmt: init is done by member constructor
   // _errValue: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GeniviFatalError::Ipc2Bts_GeniviFatalError(IN const Ipc2Bts_GeniviFatalError& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _errFile = ref._errFile;
   _errLine = ref._errLine;
   _errCode = ref._errCode;
   _fmt = ref._fmt;
   _errValue = ref._errValue;
}

Ipc2Bts_GeniviFatalError& Ipc2Bts_GeniviFatalError::operator=(IN const Ipc2Bts_GeniviFatalError& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _errFile = ref._errFile;
   _errLine = ref._errLine;
   _errCode = ref._errCode;
   _fmt = ref._fmt;
   _errValue = ref._errValue;

   return *this;
}

Ipc2Bts_GeniviFatalError::~Ipc2Bts_GeniviFatalError()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GeniviFatalError::clone(void) const
{
   return new Ipc2Bts_GeniviFatalError(*this);
}

Ipc2Bts_BtApplDidSetReqResult::Ipc2Bts_BtApplDidSetReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDidSetReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDidSetReqResult::Ipc2Bts_BtApplDidSetReqResult(IN const Ipc2Bts_BtApplDidSetReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplDidSetReqResult& Ipc2Bts_BtApplDidSetReqResult::operator=(IN const Ipc2Bts_BtApplDidSetReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplDidSetReqResult::~Ipc2Bts_BtApplDidSetReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDidSetReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplDidSetReqResult(*this);
}

Ipc2Bts_BtApplDidSetCfm::Ipc2Bts_BtApplDidSetCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplDidSetCfm))
{
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplDidSetCfm::Ipc2Bts_BtApplDidSetCfm(IN const Ipc2Bts_BtApplDidSetCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
}

Ipc2Bts_BtApplDidSetCfm& Ipc2Bts_BtApplDidSetCfm::operator=(IN const Ipc2Bts_BtApplDidSetCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;

   return *this;
}

Ipc2Bts_BtApplDidSetCfm::~Ipc2Bts_BtApplDidSetCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplDidSetCfm::clone(void) const
{
   return new Ipc2Bts_BtApplDidSetCfm(*this);
}

Ipc2Bts_DunDeviceFilePathUpdate::Ipc2Bts_DunDeviceFilePathUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DunDeviceFilePathUpdate))
{
   // _deviceName: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DunDeviceFilePathUpdate::Ipc2Bts_DunDeviceFilePathUpdate(IN const Ipc2Bts_DunDeviceFilePathUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
}

Ipc2Bts_DunDeviceFilePathUpdate& Ipc2Bts_DunDeviceFilePathUpdate::operator=(IN const Ipc2Bts_DunDeviceFilePathUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;

   return *this;
}

Ipc2Bts_DunDeviceFilePathUpdate::~Ipc2Bts_DunDeviceFilePathUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DunDeviceFilePathUpdate::clone(void) const
{
   return new Ipc2Bts_DunDeviceFilePathUpdate(*this);
}

Ipc2Bts_BtApplSppSetUuidReqResult::Ipc2Bts_BtApplSppSetUuidReqResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplSppSetUuidReqResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplSppSetUuidReqResult::Ipc2Bts_BtApplSppSetUuidReqResult(IN const Ipc2Bts_BtApplSppSetUuidReqResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_BtApplSppSetUuidReqResult& Ipc2Bts_BtApplSppSetUuidReqResult::operator=(IN const Ipc2Bts_BtApplSppSetUuidReqResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_BtApplSppSetUuidReqResult::~Ipc2Bts_BtApplSppSetUuidReqResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplSppSetUuidReqResult::clone(void) const
{
   return new Ipc2Bts_BtApplSppSetUuidReqResult(*this);
}

Ipc2Bts_BtApplSppSetUuidCfm::Ipc2Bts_BtApplSppSetUuidCfm()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplSppSetUuidCfm))
{
   _instance = 0;
   _status = BTS_STATUS_CODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplSppSetUuidCfm::Ipc2Bts_BtApplSppSetUuidCfm(IN const Ipc2Bts_BtApplSppSetUuidCfm& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _instance = ref._instance;
   _status = ref._status;
}

Ipc2Bts_BtApplSppSetUuidCfm& Ipc2Bts_BtApplSppSetUuidCfm::operator=(IN const Ipc2Bts_BtApplSppSetUuidCfm& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _status = ref._status;

   return *this;
}

Ipc2Bts_BtApplSppSetUuidCfm::~Ipc2Bts_BtApplSppSetUuidCfm()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplSppSetUuidCfm::clone(void) const
{
   return new Ipc2Bts_BtApplSppSetUuidCfm(*this);
}

Ipc2Bts_BtApplSppVirtualDeviceInd::Ipc2Bts_BtApplSppVirtualDeviceInd()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_BtApplSppVirtualDeviceInd))
{
   _instance = 0;
   // _deviceName: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_BtApplSppVirtualDeviceInd::Ipc2Bts_BtApplSppVirtualDeviceInd(IN const Ipc2Bts_BtApplSppVirtualDeviceInd& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _instance = ref._instance;
   _deviceName = ref._deviceName;
}

Ipc2Bts_BtApplSppVirtualDeviceInd& Ipc2Bts_BtApplSppVirtualDeviceInd::operator=(IN const Ipc2Bts_BtApplSppVirtualDeviceInd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _deviceName = ref._deviceName;

   return *this;
}

Ipc2Bts_BtApplSppVirtualDeviceInd::~Ipc2Bts_BtApplSppVirtualDeviceInd()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_BtApplSppVirtualDeviceInd::clone(void) const
{
   return new Ipc2Bts_BtApplSppVirtualDeviceInd(*this);
}

Ipc2Bts_CreateSessionResult::Ipc2Bts_CreateSessionResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CreateSessionResult))
{
   _protocolId = BTS_PROTO_LAST;
   _instanceId = 0;
   // _session: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CreateSessionResult::Ipc2Bts_CreateSessionResult(IN const Ipc2Bts_CreateSessionResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
   _session = ref._session;
}

Ipc2Bts_CreateSessionResult& Ipc2Bts_CreateSessionResult::operator=(IN const Ipc2Bts_CreateSessionResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
   _session = ref._session;

   return *this;
}

Ipc2Bts_CreateSessionResult::~Ipc2Bts_CreateSessionResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CreateSessionResult::clone(void) const
{
   return new Ipc2Bts_CreateSessionResult(*this);
}

Ipc2Bts_RemoveSessionResult::Ipc2Bts_RemoveSessionResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RemoveSessionResult))
{
   _protocolId = BTS_PROTO_LAST;
   _instanceId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RemoveSessionResult::Ipc2Bts_RemoveSessionResult(IN const Ipc2Bts_RemoveSessionResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
}

Ipc2Bts_RemoveSessionResult& Ipc2Bts_RemoveSessionResult::operator=(IN const Ipc2Bts_RemoveSessionResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;

   return *this;
}

Ipc2Bts_RemoveSessionResult::~Ipc2Bts_RemoveSessionResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RemoveSessionResult::clone(void) const
{
   return new Ipc2Bts_RemoveSessionResult(*this);
}

Ipc2Bts_CancelSessionResult::Ipc2Bts_CancelSessionResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CancelSessionResult))
{
   _protocolId = BTS_PROTO_LAST;
   _instanceId = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CancelSessionResult::Ipc2Bts_CancelSessionResult(IN const Ipc2Bts_CancelSessionResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
}

Ipc2Bts_CancelSessionResult& Ipc2Bts_CancelSessionResult::operator=(IN const Ipc2Bts_CancelSessionResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;

   return *this;
}

Ipc2Bts_CancelSessionResult::~Ipc2Bts_CancelSessionResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CancelSessionResult::clone(void) const
{
   return new Ipc2Bts_CancelSessionResult(*this);
}

Ipc2Bts_SessionCreated::Ipc2Bts_SessionCreated()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SessionCreated))
{
   // _session: init is done by member constructor
   _instanceId = 0;
   _protocol = BTS_PROTO_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SessionCreated::Ipc2Bts_SessionCreated(IN const Ipc2Bts_SessionCreated& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _session = ref._session;
   _instanceId = ref._instanceId;
   _protocol = ref._protocol;
}

Ipc2Bts_SessionCreated& Ipc2Bts_SessionCreated::operator=(IN const Ipc2Bts_SessionCreated& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _session = ref._session;
   _instanceId = ref._instanceId;
   _protocol = ref._protocol;

   return *this;
}

Ipc2Bts_SessionCreated::~Ipc2Bts_SessionCreated()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SessionCreated::clone(void) const
{
   return new Ipc2Bts_SessionCreated(*this);
}

Ipc2Bts_SessionRemoved::Ipc2Bts_SessionRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SessionRemoved))
{
   // _session: init is done by member constructor
   _instanceId = 0;
   _protocol = BTS_PROTO_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SessionRemoved::Ipc2Bts_SessionRemoved(IN const Ipc2Bts_SessionRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _session = ref._session;
   _instanceId = ref._instanceId;
   _protocol = ref._protocol;
}

Ipc2Bts_SessionRemoved& Ipc2Bts_SessionRemoved::operator=(IN const Ipc2Bts_SessionRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _session = ref._session;
   _instanceId = ref._instanceId;
   _protocol = ref._protocol;

   return *this;
}

Ipc2Bts_SessionRemoved::~Ipc2Bts_SessionRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SessionRemoved::clone(void) const
{
   return new Ipc2Bts_SessionRemoved(*this);
}

Ipc2Bts_AddTechnologyObjectPath::Ipc2Bts_AddTechnologyObjectPath()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddTechnologyObjectPath))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddTechnologyObjectPath::Ipc2Bts_AddTechnologyObjectPath(IN const Ipc2Bts_AddTechnologyObjectPath& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddTechnologyObjectPath& Ipc2Bts_AddTechnologyObjectPath::operator=(IN const Ipc2Bts_AddTechnologyObjectPath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddTechnologyObjectPath::~Ipc2Bts_AddTechnologyObjectPath()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddTechnologyObjectPath::clone(void) const
{
   return new Ipc2Bts_AddTechnologyObjectPath(*this);
}

Ipc2Bts_DelTechnologyObjectPath::Ipc2Bts_DelTechnologyObjectPath()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelTechnologyObjectPath))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelTechnologyObjectPath::Ipc2Bts_DelTechnologyObjectPath(IN const Ipc2Bts_DelTechnologyObjectPath& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelTechnologyObjectPath& Ipc2Bts_DelTechnologyObjectPath::operator=(IN const Ipc2Bts_DelTechnologyObjectPath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelTechnologyObjectPath::~Ipc2Bts_DelTechnologyObjectPath()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelTechnologyObjectPath::clone(void) const
{
   return new Ipc2Bts_DelTechnologyObjectPath(*this);
}

Ipc2Bts_AddNetworkObjectPathMapping::Ipc2Bts_AddNetworkObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddNetworkObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddNetworkObjectPathMapping::Ipc2Bts_AddNetworkObjectPathMapping(IN const Ipc2Bts_AddNetworkObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddNetworkObjectPathMapping& Ipc2Bts_AddNetworkObjectPathMapping::operator=(IN const Ipc2Bts_AddNetworkObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddNetworkObjectPathMapping::~Ipc2Bts_AddNetworkObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddNetworkObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddNetworkObjectPathMapping(*this);
}

Ipc2Bts_DelNetworkObjectPathMapping::Ipc2Bts_DelNetworkObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelNetworkObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelNetworkObjectPathMapping::Ipc2Bts_DelNetworkObjectPathMapping(IN const Ipc2Bts_DelNetworkObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelNetworkObjectPathMapping& Ipc2Bts_DelNetworkObjectPathMapping::operator=(IN const Ipc2Bts_DelNetworkObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelNetworkObjectPathMapping::~Ipc2Bts_DelNetworkObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelNetworkObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelNetworkObjectPathMapping(*this);
}

Ipc2Bts_GetConnManManagerPropertiesResult::Ipc2Bts_GetConnManManagerPropertiesResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GetConnManManagerPropertiesResult))
{
   // _properties: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GetConnManManagerPropertiesResult::Ipc2Bts_GetConnManManagerPropertiesResult(IN const Ipc2Bts_GetConnManManagerPropertiesResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _properties = ref._properties;
}

Ipc2Bts_GetConnManManagerPropertiesResult& Ipc2Bts_GetConnManManagerPropertiesResult::operator=(IN const Ipc2Bts_GetConnManManagerPropertiesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _properties = ref._properties;

   return *this;
}

Ipc2Bts_GetConnManManagerPropertiesResult::~Ipc2Bts_GetConnManManagerPropertiesResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetConnManManagerPropertiesResult::clone(void) const
{
   return new Ipc2Bts_GetConnManManagerPropertiesResult(*this);
}

Ipc2Bts_GetConnManTechnologiesResult::Ipc2Bts_GetConnManTechnologiesResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GetConnManTechnologiesResult))
{
   // _technologies is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GetConnManTechnologiesResult::Ipc2Bts_GetConnManTechnologiesResult(IN const Ipc2Bts_GetConnManTechnologiesResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _technologies = ref._technologies;
}

Ipc2Bts_GetConnManTechnologiesResult& Ipc2Bts_GetConnManTechnologiesResult::operator=(IN const Ipc2Bts_GetConnManTechnologiesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _technologies = ref._technologies;

   return *this;
}

Ipc2Bts_GetConnManTechnologiesResult::~Ipc2Bts_GetConnManTechnologiesResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetConnManTechnologiesResult::clone(void) const
{
   return new Ipc2Bts_GetConnManTechnologiesResult(*this);
}

Ipc2Bts_GetConnManServicesResult::Ipc2Bts_GetConnManServicesResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GetConnManServicesResult))
{
   // _services is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GetConnManServicesResult::Ipc2Bts_GetConnManServicesResult(IN const Ipc2Bts_GetConnManServicesResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _services = ref._services;
}

Ipc2Bts_GetConnManServicesResult& Ipc2Bts_GetConnManServicesResult::operator=(IN const Ipc2Bts_GetConnManServicesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _services = ref._services;

   return *this;
}

Ipc2Bts_GetConnManServicesResult::~Ipc2Bts_GetConnManServicesResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetConnManServicesResult::clone(void) const
{
   return new Ipc2Bts_GetConnManServicesResult(*this);
}

Ipc2Bts_ConnManTechnologyAdded::Ipc2Bts_ConnManTechnologyAdded()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManTechnologyAdded))
{
   // _path: init is done by member constructor
   // _properties: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManTechnologyAdded::Ipc2Bts_ConnManTechnologyAdded(IN const Ipc2Bts_ConnManTechnologyAdded& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _path = ref._path;
   _properties = ref._properties;
}

Ipc2Bts_ConnManTechnologyAdded& Ipc2Bts_ConnManTechnologyAdded::operator=(IN const Ipc2Bts_ConnManTechnologyAdded& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _path = ref._path;
   _properties = ref._properties;

   return *this;
}

Ipc2Bts_ConnManTechnologyAdded::~Ipc2Bts_ConnManTechnologyAdded()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManTechnologyAdded::clone(void) const
{
   return new Ipc2Bts_ConnManTechnologyAdded(*this);
}

Ipc2Bts_ConnManTechnologyRemoved::Ipc2Bts_ConnManTechnologyRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManTechnologyRemoved))
{
   // _path: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManTechnologyRemoved::Ipc2Bts_ConnManTechnologyRemoved(IN const Ipc2Bts_ConnManTechnologyRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _path = ref._path;
}

Ipc2Bts_ConnManTechnologyRemoved& Ipc2Bts_ConnManTechnologyRemoved::operator=(IN const Ipc2Bts_ConnManTechnologyRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _path = ref._path;

   return *this;
}

Ipc2Bts_ConnManTechnologyRemoved::~Ipc2Bts_ConnManTechnologyRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManTechnologyRemoved::clone(void) const
{
   return new Ipc2Bts_ConnManTechnologyRemoved(*this);
}

Ipc2Bts_ConnManServicesChanged::Ipc2Bts_ConnManServicesChanged()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServicesChanged))
{
   // _services is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServicesChanged::Ipc2Bts_ConnManServicesChanged(IN const Ipc2Bts_ConnManServicesChanged& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _services = ref._services;
}

Ipc2Bts_ConnManServicesChanged& Ipc2Bts_ConnManServicesChanged::operator=(IN const Ipc2Bts_ConnManServicesChanged& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _services = ref._services;

   return *this;
}

Ipc2Bts_ConnManServicesChanged::~Ipc2Bts_ConnManServicesChanged()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServicesChanged::clone(void) const
{
   return new Ipc2Bts_ConnManServicesChanged(*this);
}

Ipc2Bts_ConnManServicesRemoved::Ipc2Bts_ConnManServicesRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServicesRemoved))
{
   // _services is empty per default
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServicesRemoved::Ipc2Bts_ConnManServicesRemoved(IN const Ipc2Bts_ConnManServicesRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _services = ref._services;
}

Ipc2Bts_ConnManServicesRemoved& Ipc2Bts_ConnManServicesRemoved::operator=(IN const Ipc2Bts_ConnManServicesRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _services = ref._services;

   return *this;
}

Ipc2Bts_ConnManServicesRemoved::~Ipc2Bts_ConnManServicesRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServicesRemoved::clone(void) const
{
   return new Ipc2Bts_ConnManServicesRemoved(*this);
}

Ipc2Bts_GetConnManServicePropertiesResult::Ipc2Bts_GetConnManServicePropertiesResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_GetConnManServicePropertiesResult))
{
   // _properties: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_GetConnManServicePropertiesResult::Ipc2Bts_GetConnManServicePropertiesResult(IN const Ipc2Bts_GetConnManServicePropertiesResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _properties = ref._properties;
   _device = ref._device;
}

Ipc2Bts_GetConnManServicePropertiesResult& Ipc2Bts_GetConnManServicePropertiesResult::operator=(IN const Ipc2Bts_GetConnManServicePropertiesResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _properties = ref._properties;
   _device = ref._device;

   return *this;
}

Ipc2Bts_GetConnManServicePropertiesResult::~Ipc2Bts_GetConnManServicePropertiesResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_GetConnManServicePropertiesResult::clone(void) const
{
   return new Ipc2Bts_GetConnManServicePropertiesResult(*this);
}

Ipc2Bts_ConnManServiceConnectResult::Ipc2Bts_ConnManServiceConnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServiceConnectResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServiceConnectResult::Ipc2Bts_ConnManServiceConnectResult(IN const Ipc2Bts_ConnManServiceConnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_ConnManServiceConnectResult& Ipc2Bts_ConnManServiceConnectResult::operator=(IN const Ipc2Bts_ConnManServiceConnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_ConnManServiceConnectResult::~Ipc2Bts_ConnManServiceConnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServiceConnectResult::clone(void) const
{
   return new Ipc2Bts_ConnManServiceConnectResult(*this);
}

Ipc2Bts_ConnManServiceDisconnectResult::Ipc2Bts_ConnManServiceDisconnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServiceDisconnectResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServiceDisconnectResult::Ipc2Bts_ConnManServiceDisconnectResult(IN const Ipc2Bts_ConnManServiceDisconnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_ConnManServiceDisconnectResult& Ipc2Bts_ConnManServiceDisconnectResult::operator=(IN const Ipc2Bts_ConnManServiceDisconnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_ConnManServiceDisconnectResult::~Ipc2Bts_ConnManServiceDisconnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServiceDisconnectResult::clone(void) const
{
   return new Ipc2Bts_ConnManServiceDisconnectResult(*this);
}

Ipc2Bts_ConnManServiceStateUpdate::Ipc2Bts_ConnManServiceStateUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServiceStateUpdate))
{
   _value = ::ccdbusif::connman::SERVICE_STATE_UNKNOWN;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServiceStateUpdate::Ipc2Bts_ConnManServiceStateUpdate(IN const Ipc2Bts_ConnManServiceStateUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _value = ref._value;
   _device = ref._device;
}

Ipc2Bts_ConnManServiceStateUpdate& Ipc2Bts_ConnManServiceStateUpdate::operator=(IN const Ipc2Bts_ConnManServiceStateUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _value = ref._value;
   _device = ref._device;

   return *this;
}

Ipc2Bts_ConnManServiceStateUpdate::~Ipc2Bts_ConnManServiceStateUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServiceStateUpdate::clone(void) const
{
   return new Ipc2Bts_ConnManServiceStateUpdate(*this);
}

Ipc2Bts_ConnManServiceInterfaceUpdate::Ipc2Bts_ConnManServiceInterfaceUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_ConnManServiceInterfaceUpdate))
{
   // _interface: init is done by member constructor
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_ConnManServiceInterfaceUpdate::Ipc2Bts_ConnManServiceInterfaceUpdate(IN const Ipc2Bts_ConnManServiceInterfaceUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _interface = ref._interface;
   _device = ref._device;
}

Ipc2Bts_ConnManServiceInterfaceUpdate& Ipc2Bts_ConnManServiceInterfaceUpdate::operator=(IN const Ipc2Bts_ConnManServiceInterfaceUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _interface = ref._interface;
   _device = ref._device;

   return *this;
}

Ipc2Bts_ConnManServiceInterfaceUpdate::~Ipc2Bts_ConnManServiceInterfaceUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_ConnManServiceInterfaceUpdate::clone(void) const
{
   return new Ipc2Bts_ConnManServiceInterfaceUpdate(*this);
}

Ipc2Bts_SerialDeviceFilePath::Ipc2Bts_SerialDeviceFilePath()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SerialDeviceFilePath))
{
   // _deviceName: init is done by member constructor
   // _service: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SerialDeviceFilePath::Ipc2Bts_SerialDeviceFilePath(IN const Ipc2Bts_SerialDeviceFilePath& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
   _service = ref._service;
}

Ipc2Bts_SerialDeviceFilePath& Ipc2Bts_SerialDeviceFilePath::operator=(IN const Ipc2Bts_SerialDeviceFilePath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;
   _service = ref._service;

   return *this;
}

Ipc2Bts_SerialDeviceFilePath::~Ipc2Bts_SerialDeviceFilePath()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SerialDeviceFilePath::clone(void) const
{
   return new Ipc2Bts_SerialDeviceFilePath(*this);
}

Ipc2Bts_CharacterDeviceAddedRemoved::Ipc2Bts_CharacterDeviceAddedRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CharacterDeviceAddedRemoved))
{
   // _deviceName: init is done by member constructor
   _added = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CharacterDeviceAddedRemoved::Ipc2Bts_CharacterDeviceAddedRemoved(IN const Ipc2Bts_CharacterDeviceAddedRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _deviceName = ref._deviceName;
   _added = ref._added;
}

Ipc2Bts_CharacterDeviceAddedRemoved& Ipc2Bts_CharacterDeviceAddedRemoved::operator=(IN const Ipc2Bts_CharacterDeviceAddedRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _deviceName = ref._deviceName;
   _added = ref._added;

   return *this;
}

Ipc2Bts_CharacterDeviceAddedRemoved::~Ipc2Bts_CharacterDeviceAddedRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CharacterDeviceAddedRemoved::clone(void) const
{
   return new Ipc2Bts_CharacterDeviceAddedRemoved(*this);
}

Ipc2Bts_CreateLeDeviceResult::Ipc2Bts_CreateLeDeviceResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_CreateLeDeviceResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_CreateLeDeviceResult::Ipc2Bts_CreateLeDeviceResult(IN const Ipc2Bts_CreateLeDeviceResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_CreateLeDeviceResult& Ipc2Bts_CreateLeDeviceResult::operator=(IN const Ipc2Bts_CreateLeDeviceResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_CreateLeDeviceResult::~Ipc2Bts_CreateLeDeviceResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_CreateLeDeviceResult::clone(void) const
{
   return new Ipc2Bts_CreateLeDeviceResult(*this);
}

Ipc2Bts_RemoveLeDeviceResult::Ipc2Bts_RemoveLeDeviceResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_RemoveLeDeviceResult))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_RemoveLeDeviceResult::Ipc2Bts_RemoveLeDeviceResult(IN const Ipc2Bts_RemoveLeDeviceResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_RemoveLeDeviceResult& Ipc2Bts_RemoveLeDeviceResult::operator=(IN const Ipc2Bts_RemoveLeDeviceResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_RemoveLeDeviceResult::~Ipc2Bts_RemoveLeDeviceResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_RemoveLeDeviceResult::clone(void) const
{
   return new Ipc2Bts_RemoveLeDeviceResult(*this);
}

Ipc2Bts_LeAdapterInitialization::Ipc2Bts_LeAdapterInitialization()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterInitialization))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterInitialization::Ipc2Bts_LeAdapterInitialization(IN const Ipc2Bts_LeAdapterInitialization& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_LeAdapterInitialization& Ipc2Bts_LeAdapterInitialization::operator=(IN const Ipc2Bts_LeAdapterInitialization& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_LeAdapterInitialization::~Ipc2Bts_LeAdapterInitialization()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterInitialization::clone(void) const
{
   return new Ipc2Bts_LeAdapterInitialization(*this);
}

Ipc2Bts_LeDeviceCreated::Ipc2Bts_LeDeviceCreated()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceCreated))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceCreated::Ipc2Bts_LeDeviceCreated(IN const Ipc2Bts_LeDeviceCreated& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_LeDeviceCreated& Ipc2Bts_LeDeviceCreated::operator=(IN const Ipc2Bts_LeDeviceCreated& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceCreated::~Ipc2Bts_LeDeviceCreated()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceCreated::clone(void) const
{
   return new Ipc2Bts_LeDeviceCreated(*this);
}

Ipc2Bts_LeDeviceRemoved::Ipc2Bts_LeDeviceRemoved()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceRemoved))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceRemoved::Ipc2Bts_LeDeviceRemoved(IN const Ipc2Bts_LeDeviceRemoved& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_LeDeviceRemoved& Ipc2Bts_LeDeviceRemoved::operator=(IN const Ipc2Bts_LeDeviceRemoved& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceRemoved::~Ipc2Bts_LeDeviceRemoved()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceRemoved::clone(void) const
{
   return new Ipc2Bts_LeDeviceRemoved(*this);
}

Ipc2Bts_LeAdapterAddressTypeUpdate::Ipc2Bts_LeAdapterAddressTypeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAddressTypeUpdate))
{
   _addressType = BTS_BLE_DEV_ADDRESS_TYPE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAddressTypeUpdate::Ipc2Bts_LeAdapterAddressTypeUpdate(IN const Ipc2Bts_LeAdapterAddressTypeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _addressType = ref._addressType;
}

Ipc2Bts_LeAdapterAddressTypeUpdate& Ipc2Bts_LeAdapterAddressTypeUpdate::operator=(IN const Ipc2Bts_LeAdapterAddressTypeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _addressType = ref._addressType;

   return *this;
}

Ipc2Bts_LeAdapterAddressTypeUpdate::~Ipc2Bts_LeAdapterAddressTypeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAddressTypeUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAddressTypeUpdate(*this);
}

Ipc2Bts_LeAdapterAddressUpdate::Ipc2Bts_LeAdapterAddressUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAddressUpdate))
{
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAddressUpdate::Ipc2Bts_LeAdapterAddressUpdate(IN const Ipc2Bts_LeAdapterAddressUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
}

Ipc2Bts_LeAdapterAddressUpdate& Ipc2Bts_LeAdapterAddressUpdate::operator=(IN const Ipc2Bts_LeAdapterAddressUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   return *this;
}

Ipc2Bts_LeAdapterAddressUpdate::~Ipc2Bts_LeAdapterAddressUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAddressUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAddressUpdate(*this);
}

Ipc2Bts_LeAdapterAliasUpdate::Ipc2Bts_LeAdapterAliasUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAliasUpdate))
{
   // _alias: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAliasUpdate::Ipc2Bts_LeAdapterAliasUpdate(IN const Ipc2Bts_LeAdapterAliasUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _alias = ref._alias;
}

Ipc2Bts_LeAdapterAliasUpdate& Ipc2Bts_LeAdapterAliasUpdate::operator=(IN const Ipc2Bts_LeAdapterAliasUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _alias = ref._alias;

   return *this;
}

Ipc2Bts_LeAdapterAliasUpdate::~Ipc2Bts_LeAdapterAliasUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAliasUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAliasUpdate(*this);
}

Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate::Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAdvertisingTimeoutUpdate))
{
   _advertisingTimeout = 0;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate::Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate(IN const Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _advertisingTimeout = ref._advertisingTimeout;
}

Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate::operator=(IN const Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _advertisingTimeout = ref._advertisingTimeout;

   return *this;
}

Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate::~Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate(*this);
}

Ipc2Bts_LeAdapterDiscoverableModeUpdate::Ipc2Bts_LeAdapterDiscoverableModeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterDiscoverableModeUpdate))
{
   _discoverableMode = BTS_BLE_DISCOVERABLE_MODE_LAST;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterDiscoverableModeUpdate::Ipc2Bts_LeAdapterDiscoverableModeUpdate(IN const Ipc2Bts_LeAdapterDiscoverableModeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _discoverableMode = ref._discoverableMode;
}

Ipc2Bts_LeAdapterDiscoverableModeUpdate& Ipc2Bts_LeAdapterDiscoverableModeUpdate::operator=(IN const Ipc2Bts_LeAdapterDiscoverableModeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _discoverableMode = ref._discoverableMode;

   return *this;
}

Ipc2Bts_LeAdapterDiscoverableModeUpdate::~Ipc2Bts_LeAdapterDiscoverableModeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterDiscoverableModeUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterDiscoverableModeUpdate(*this);
}

Ipc2Bts_LeAdapterAdvertisingDataUpdate::Ipc2Bts_LeAdapterAdvertisingDataUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAdvertisingDataUpdate))
{
   // _advertisingData: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAdvertisingDataUpdate::Ipc2Bts_LeAdapterAdvertisingDataUpdate(IN const Ipc2Bts_LeAdapterAdvertisingDataUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _advertisingData = ref._advertisingData;
}

Ipc2Bts_LeAdapterAdvertisingDataUpdate& Ipc2Bts_LeAdapterAdvertisingDataUpdate::operator=(IN const Ipc2Bts_LeAdapterAdvertisingDataUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _advertisingData = ref._advertisingData;

   return *this;
}

Ipc2Bts_LeAdapterAdvertisingDataUpdate::~Ipc2Bts_LeAdapterAdvertisingDataUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAdvertisingDataUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAdvertisingDataUpdate(*this);
}

Ipc2Bts_LeAdapterAdvertiseEnableUpdate::Ipc2Bts_LeAdapterAdvertiseEnableUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeAdapterAdvertiseEnableUpdate))
{
   _advertiseEnable = false;
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeAdapterAdvertiseEnableUpdate::Ipc2Bts_LeAdapterAdvertiseEnableUpdate(IN const Ipc2Bts_LeAdapterAdvertiseEnableUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _advertiseEnable = ref._advertiseEnable;
}

Ipc2Bts_LeAdapterAdvertiseEnableUpdate& Ipc2Bts_LeAdapterAdvertiseEnableUpdate::operator=(IN const Ipc2Bts_LeAdapterAdvertiseEnableUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _advertiseEnable = ref._advertiseEnable;

   return *this;
}

Ipc2Bts_LeAdapterAdvertiseEnableUpdate::~Ipc2Bts_LeAdapterAdvertiseEnableUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeAdapterAdvertiseEnableUpdate::clone(void) const
{
   return new Ipc2Bts_LeAdapterAdvertiseEnableUpdate(*this);
}

Ipc2Bts_AddLeDeviceObjectPathMapping::Ipc2Bts_AddLeDeviceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_AddLeDeviceObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_AddLeDeviceObjectPathMapping::Ipc2Bts_AddLeDeviceObjectPathMapping(IN const Ipc2Bts_AddLeDeviceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_AddLeDeviceObjectPathMapping& Ipc2Bts_AddLeDeviceObjectPathMapping::operator=(IN const Ipc2Bts_AddLeDeviceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_AddLeDeviceObjectPathMapping::~Ipc2Bts_AddLeDeviceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_AddLeDeviceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_AddLeDeviceObjectPathMapping(*this);
}

Ipc2Bts_DelLeDeviceObjectPathMapping::Ipc2Bts_DelLeDeviceObjectPathMapping()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_DelLeDeviceObjectPathMapping))
{
   // _objPath: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_DelLeDeviceObjectPathMapping::Ipc2Bts_DelLeDeviceObjectPathMapping(IN const Ipc2Bts_DelLeDeviceObjectPathMapping& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Ipc2Bts_DelLeDeviceObjectPathMapping& Ipc2Bts_DelLeDeviceObjectPathMapping::operator=(IN const Ipc2Bts_DelLeDeviceObjectPathMapping& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Ipc2Bts_DelLeDeviceObjectPathMapping::~Ipc2Bts_DelLeDeviceObjectPathMapping()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_DelLeDeviceObjectPathMapping::clone(void) const
{
   return new Ipc2Bts_DelLeDeviceObjectPathMapping(*this);
}

Ipc2Bts_LeDeviceDisconnectResult::Ipc2Bts_LeDeviceDisconnectResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceDisconnectResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceDisconnectResult::Ipc2Bts_LeDeviceDisconnectResult(IN const Ipc2Bts_LeDeviceDisconnectResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_LeDeviceDisconnectResult& Ipc2Bts_LeDeviceDisconnectResult::operator=(IN const Ipc2Bts_LeDeviceDisconnectResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceDisconnectResult::~Ipc2Bts_LeDeviceDisconnectResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceDisconnectResult::clone(void) const
{
   return new Ipc2Bts_LeDeviceDisconnectResult(*this);
}

Ipc2Bts_LeDisconnectionComp::Ipc2Bts_LeDisconnectionComp()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDisconnectionComp))
{
   _status = BTS_BLE_STATUS_LAST;
   _reason = BTS_BT_APPL_DISCONNECT_REASON_LAST;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDisconnectionComp::Ipc2Bts_LeDisconnectionComp(IN const Ipc2Bts_LeDisconnectionComp& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _reason = ref._reason;
   _device = ref._device;
}

Ipc2Bts_LeDisconnectionComp& Ipc2Bts_LeDisconnectionComp::operator=(IN const Ipc2Bts_LeDisconnectionComp& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _reason = ref._reason;
   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDisconnectionComp::~Ipc2Bts_LeDisconnectionComp()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDisconnectionComp::clone(void) const
{
   return new Ipc2Bts_LeDisconnectionComp(*this);
}

Ipc2Bts_LeDeviceAddressTypeUpdate::Ipc2Bts_LeDeviceAddressTypeUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceAddressTypeUpdate))
{
   _addressType = BTS_BLE_DEV_ADDRESS_TYPE_LAST;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceAddressTypeUpdate::Ipc2Bts_LeDeviceAddressTypeUpdate(IN const Ipc2Bts_LeDeviceAddressTypeUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _addressType = ref._addressType;
   _device = ref._device;
}

Ipc2Bts_LeDeviceAddressTypeUpdate& Ipc2Bts_LeDeviceAddressTypeUpdate::operator=(IN const Ipc2Bts_LeDeviceAddressTypeUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _addressType = ref._addressType;
   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceAddressTypeUpdate::~Ipc2Bts_LeDeviceAddressTypeUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceAddressTypeUpdate::clone(void) const
{
   return new Ipc2Bts_LeDeviceAddressTypeUpdate(*this);
}

Ipc2Bts_LeDeviceAddressUpdate::Ipc2Bts_LeDeviceAddressUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceAddressUpdate))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceAddressUpdate::Ipc2Bts_LeDeviceAddressUpdate(IN const Ipc2Bts_LeDeviceAddressUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_LeDeviceAddressUpdate& Ipc2Bts_LeDeviceAddressUpdate::operator=(IN const Ipc2Bts_LeDeviceAddressUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceAddressUpdate::~Ipc2Bts_LeDeviceAddressUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceAddressUpdate::clone(void) const
{
   return new Ipc2Bts_LeDeviceAddressUpdate(*this);
}

Ipc2Bts_LeDeviceConnectedUpdate::Ipc2Bts_LeDeviceConnectedUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_LeDeviceConnectedUpdate))
{
   _connected = false;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_LeDeviceConnectedUpdate::Ipc2Bts_LeDeviceConnectedUpdate(IN const Ipc2Bts_LeDeviceConnectedUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _connected = ref._connected;
   _device = ref._device;
}

Ipc2Bts_LeDeviceConnectedUpdate& Ipc2Bts_LeDeviceConnectedUpdate::operator=(IN const Ipc2Bts_LeDeviceConnectedUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _connected = ref._connected;
   _device = ref._device;

   return *this;
}

Ipc2Bts_LeDeviceConnectedUpdate::~Ipc2Bts_LeDeviceConnectedUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_LeDeviceConnectedUpdate::clone(void) const
{
   return new Ipc2Bts_LeDeviceConnectedUpdate(*this);
}

Ipc2Bts_SendSeamlessPairingErrorCodeResult::Ipc2Bts_SendSeamlessPairingErrorCodeResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SendSeamlessPairingErrorCodeResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SendSeamlessPairingErrorCodeResult::Ipc2Bts_SendSeamlessPairingErrorCodeResult(IN const Ipc2Bts_SendSeamlessPairingErrorCodeResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_SendSeamlessPairingErrorCodeResult& Ipc2Bts_SendSeamlessPairingErrorCodeResult::operator=(IN const Ipc2Bts_SendSeamlessPairingErrorCodeResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_SendSeamlessPairingErrorCodeResult::~Ipc2Bts_SendSeamlessPairingErrorCodeResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SendSeamlessPairingErrorCodeResult::clone(void) const
{
   return new Ipc2Bts_SendSeamlessPairingErrorCodeResult(*this);
}

Ipc2Bts_SeamlessPairingAllowAccessResult::Ipc2Bts_SeamlessPairingAllowAccessResult()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SeamlessPairingAllowAccessResult))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SeamlessPairingAllowAccessResult::Ipc2Bts_SeamlessPairingAllowAccessResult(IN const Ipc2Bts_SeamlessPairingAllowAccessResult& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_SeamlessPairingAllowAccessResult& Ipc2Bts_SeamlessPairingAllowAccessResult::operator=(IN const Ipc2Bts_SeamlessPairingAllowAccessResult& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_SeamlessPairingAllowAccessResult::~Ipc2Bts_SeamlessPairingAllowAccessResult()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SeamlessPairingAllowAccessResult::clone(void) const
{
   return new Ipc2Bts_SeamlessPairingAllowAccessResult(*this);
}

Ipc2Bts_SeamlessPairingErrorCodeReceived::Ipc2Bts_SeamlessPairingErrorCodeReceived()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SeamlessPairingErrorCodeReceived))
{
   _status = BTS_BLE_STATUS_LAST;
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SeamlessPairingErrorCodeReceived::Ipc2Bts_SeamlessPairingErrorCodeReceived(IN const Ipc2Bts_SeamlessPairingErrorCodeReceived& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _status = ref._status;
   _device = ref._device;
}

Ipc2Bts_SeamlessPairingErrorCodeReceived& Ipc2Bts_SeamlessPairingErrorCodeReceived::operator=(IN const Ipc2Bts_SeamlessPairingErrorCodeReceived& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _status = ref._status;
   _device = ref._device;

   return *this;
}

Ipc2Bts_SeamlessPairingErrorCodeReceived::~Ipc2Bts_SeamlessPairingErrorCodeReceived()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SeamlessPairingErrorCodeReceived::clone(void) const
{
   return new Ipc2Bts_SeamlessPairingErrorCodeReceived(*this);
}

Ipc2Bts_SeamlessPairingAccessRequest::Ipc2Bts_SeamlessPairingAccessRequest()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SeamlessPairingAccessRequest))
{
   // _device: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SeamlessPairingAccessRequest::Ipc2Bts_SeamlessPairingAccessRequest(IN const Ipc2Bts_SeamlessPairingAccessRequest& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
}

Ipc2Bts_SeamlessPairingAccessRequest& Ipc2Bts_SeamlessPairingAccessRequest::operator=(IN const Ipc2Bts_SeamlessPairingAccessRequest& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Ipc2Bts_SeamlessPairingAccessRequest::~Ipc2Bts_SeamlessPairingAccessRequest()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SeamlessPairingAccessRequest::clone(void) const
{
   return new Ipc2Bts_SeamlessPairingAccessRequest(*this);
}

Ipc2Bts_SeamlessPairingPairingDataUpdate::Ipc2Bts_SeamlessPairingPairingDataUpdate()
: Ipc2Bts_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Ipc2BtsOC_SeamlessPairingPairingDataUpdate))
{
   // _device: init is done by member constructor
   // _pairingData: init is done by member constructor
   setBtsDestinationFunctionBlock(BTS_FB_CONNECTION);
}

Ipc2Bts_SeamlessPairingPairingDataUpdate::Ipc2Bts_SeamlessPairingPairingDataUpdate(IN const Ipc2Bts_SeamlessPairingPairingDataUpdate& ref)
: Ipc2Bts_BaseMessage(ref)
{
   _device = ref._device;
   _pairingData = ref._pairingData;
}

Ipc2Bts_SeamlessPairingPairingDataUpdate& Ipc2Bts_SeamlessPairingPairingDataUpdate::operator=(IN const Ipc2Bts_SeamlessPairingPairingDataUpdate& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Ipc2Bts_BaseMessage::operator=(ref);

   _device = ref._device;
   _pairingData = ref._pairingData;

   return *this;
}

Ipc2Bts_SeamlessPairingPairingDataUpdate::~Ipc2Bts_SeamlessPairingPairingDataUpdate()
{
}

Ipc2Bts_BaseMessage* Ipc2Bts_SeamlessPairingPairingDataUpdate::clone(void) const
{
   return new Ipc2Bts_SeamlessPairingPairingDataUpdate(*this);
}

} //genivi
} //btstackif
