/**
 * @file TrcIpc2BtsProperty_GEN.h
 *
 * @par SW-Component
 * Trace
 *
 * @brief Traces for Ipc2Bts messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of traces for Ipc2Bts messages.
 */

#ifndef _TRC_IPC_2_BTS_PROPERTY_GENIVI_H_
#define _TRC_IPC_2_BTS_PROPERTY_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

/**
 * Trace property information.
 *
 * @param[in] opCodeVal: message trace id
 * @param[in] opcode: opcode as enum
 * @param[in] interface: interface
 * @param[in] properties: properties
 */
void doPropertyTrace(IN const uint32_t opCodeVal, IN const BTSGenIpc2BtsOpcode opcode, IN const ::ccdbusif::evolution::Interface interface, IN const BTSDbusPropertyList& properties);

} //genivi
} //btstackif

#endif //_TRC_IPC_2_BTS_PROPERTY_GENIVI_H_
