/**
 * @file Ipc2Bts_Telephony_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_TELEPHONY.
 */

#ifndef _IPC_2_BTS_TELEPHONY_MSG_GENIVI_H_
#define _IPC_2_BTS_TELEPHONY_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityTelephony : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityTelephony();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityTelephony(IN const Ipc2Bts_ServiceAvailabilityTelephony& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityTelephony& operator=(IN const Ipc2Bts_ServiceAvailabilityTelephony& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityTelephony();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSGenDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSGenDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSGenDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AddHfpInterfaceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddHfpInterfaceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddHfpInterfaceObjectPathMapping(IN const Ipc2Bts_AddHfpInterfaceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddHfpInterfaceObjectPathMapping& operator=(IN const Ipc2Bts_AddHfpInterfaceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddHfpInterfaceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const ::ccdbusif::evolution::Interface interface) { _interface = interface; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline ::ccdbusif::evolution::Interface getInterface(void) const { return _interface; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   ::ccdbusif::evolution::Interface _interface; /**< parameter interface */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelHfpInterfaceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelHfpInterfaceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelHfpInterfaceObjectPathMapping(IN const Ipc2Bts_DelHfpInterfaceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelHfpInterfaceObjectPathMapping& operator=(IN const Ipc2Bts_DelHfpInterfaceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelHfpInterfaceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const ::ccdbusif::evolution::Interface interface) { _interface = interface; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline ::ccdbusif::evolution::Interface getInterface(void) const { return _interface; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   ::ccdbusif::evolution::Interface _interface; /**< parameter interface */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_GetHandsfreeProperties : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetHandsfreeProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetHandsfreeProperties(IN const Ipc2Bts_GetHandsfreeProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetHandsfreeProperties& operator=(IN const Ipc2Bts_GetHandsfreeProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetHandsfreeProperties();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_GetHandsfreePropertiesExt : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetHandsfreePropertiesExt();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetHandsfreePropertiesExt(IN const Ipc2Bts_GetHandsfreePropertiesExt& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetHandsfreePropertiesExt& operator=(IN const Ipc2Bts_GetHandsfreePropertiesExt& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetHandsfreePropertiesExt();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }
   inline void setProperties(IN const BTSDbusPropertyList& properties) { _properties = properties; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }
   inline void getProperties(OUT BTSDbusPropertyList& properties) const { properties = _properties; }
   inline const BTSDbusPropertyList& getProperties(void) const { return _properties; }
   inline BTSDbusPropertyList& getPropertiesMutable(void) { return _properties; }

private:
   BTSObjectPath _modem; /**< parameter modem */
   BTSDbusPropertyList _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_HandsfreeFeaturesUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_HandsfreeFeaturesUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_HandsfreeFeaturesUpdate(IN const Ipc2Bts_HandsfreeFeaturesUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_HandsfreeFeaturesUpdate& operator=(IN const Ipc2Bts_HandsfreeFeaturesUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_HandsfreeFeaturesUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setFeatures(IN const BTSHfpSupportedFeatures& features) { _features = features; }
   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getFeatures(OUT BTSHfpSupportedFeatures& features) const { features = _features; }
   inline const BTSHfpSupportedFeatures& getFeatures(void) const { return _features; }
   inline BTSHfpSupportedFeatures& getFeaturesMutable(void) { return _features; }
   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   BTSHfpSupportedFeatures _features; /**< parameter features */
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_HandsfreeInbandRingingUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_HandsfreeInbandRingingUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_HandsfreeInbandRingingUpdate(IN const Ipc2Bts_HandsfreeInbandRingingUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_HandsfreeInbandRingingUpdate& operator=(IN const Ipc2Bts_HandsfreeInbandRingingUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_HandsfreeInbandRingingUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInbandRingingEnabled(IN const bool inbandRingingEnabled) { _inbandRingingEnabled = inbandRingingEnabled; }
   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline bool getInbandRingingEnabled(void) const { return _inbandRingingEnabled; }
   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   bool _inbandRingingEnabled; /**< parameter inband ringing enabled */
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_GetModems : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetModems();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetModems(IN const Ipc2Bts_GetModems& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetModems& operator=(IN const Ipc2Bts_GetModems& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetModems();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_GetModemsExt : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetModemsExt();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetModemsExt(IN const Ipc2Bts_GetModemsExt& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetModemsExt& operator=(IN const Ipc2Bts_GetModemsExt& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetModemsExt();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModems(IN const BTSObjectPathList& modems) { _modems = modems; }

   inline void getModems(OUT BTSObjectPathList& modems) const { modems = _modems; }
   inline const BTSObjectPathList& getModems(void) const { return _modems; }
   inline BTSObjectPathList& getModemsMutable(void) { return _modems; }

private:
   BTSObjectPathList _modems; /**< parameter modems */
};

/**
 *
 */
class Ipc2Bts_ModemAdded : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ModemAdded();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ModemAdded(IN const Ipc2Bts_ModemAdded& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ModemAdded& operator=(IN const Ipc2Bts_ModemAdded& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ModemAdded();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_ModemAddedExt : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ModemAddedExt();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ModemAddedExt(IN const Ipc2Bts_ModemAddedExt& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ModemAddedExt& operator=(IN const Ipc2Bts_ModemAddedExt& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ModemAddedExt();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }
   inline void setProperties(IN const BTSDbusPropertyList& properties) { _properties = properties; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }
   inline void getProperties(OUT BTSDbusPropertyList& properties) const { properties = _properties; }
   inline const BTSDbusPropertyList& getProperties(void) const { return _properties; }
   inline BTSDbusPropertyList& getPropertiesMutable(void) { return _properties; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _modem; /**< parameter modem */
   BTSDbusPropertyList _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_ModemRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ModemRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ModemRemoved(IN const Ipc2Bts_ModemRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ModemRemoved& operator=(IN const Ipc2Bts_ModemRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ModemRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_GetModemProperties : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetModemProperties();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetModemProperties(IN const Ipc2Bts_GetModemProperties& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetModemProperties& operator=(IN const Ipc2Bts_GetModemProperties& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetModemProperties();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   BTSObjectPath _modem; /**< parameter modem */
};

/**
 *
 */
class Ipc2Bts_GetModemPropertiesExt : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetModemPropertiesExt();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetModemPropertiesExt(IN const Ipc2Bts_GetModemPropertiesExt& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetModemPropertiesExt& operator=(IN const Ipc2Bts_GetModemPropertiesExt& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetModemPropertiesExt();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }
   inline void setProperties(IN const BTSDbusPropertyList& properties) { _properties = properties; }

   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }
   inline void getProperties(OUT BTSDbusPropertyList& properties) const { properties = _properties; }
   inline const BTSDbusPropertyList& getProperties(void) const { return _properties; }
   inline BTSDbusPropertyList& getPropertiesMutable(void) { return _properties; }

private:
   BTSObjectPath _modem; /**< parameter modem */
   BTSDbusPropertyList _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_ModemInterfacesUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ModemInterfacesUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ModemInterfacesUpdate(IN const Ipc2Bts_ModemInterfacesUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ModemInterfacesUpdate& operator=(IN const Ipc2Bts_ModemInterfacesUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ModemInterfacesUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterfaces(IN const BTSDbusInterfaceList& interfaces) { _interfaces = interfaces; }
   inline void setModem(IN const BTSObjectPath& modem) { _modem = modem; }

   inline void getInterfaces(OUT BTSDbusInterfaceList& interfaces) const { interfaces = _interfaces; }
   inline const BTSDbusInterfaceList& getInterfaces(void) const { return _interfaces; }
   inline BTSDbusInterfaceList& getInterfacesMutable(void) { return _interfaces; }
   inline void getModem(OUT BTSObjectPath& modem) const { modem = _modem; }
   inline const BTSObjectPath& getModem(void) const { return _modem; }
   inline BTSObjectPath& getModemMutable(void) { return _modem; }

private:
   BTSDbusInterfaceList _interfaces; /**< parameter interfaces */
   BTSObjectPath _modem; /**< parameter modem */
};

} //genivi
} //btstackif

#endif //_IPC_2_BTS_TELEPHONY_MSG_GENIVI_H_
