/**
 * @file Ipc2Bts_Connection_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief IPC to BtStackIf messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_CONNECTION.
 */

#ifndef _IPC_2_BTS_CONNECTION_MSG_GENIVI_H_
#define _IPC_2_BTS_CONNECTION_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Ipc2Bts_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Ipc2Bts_ServiceAvailabilityConnection : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceAvailabilityConnection();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceAvailabilityConnection(IN const Ipc2Bts_ServiceAvailabilityConnection& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceAvailabilityConnection& operator=(IN const Ipc2Bts_ServiceAvailabilityConnection& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceAvailabilityConnection();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSGenDbusServiceInterface interface) { _interface = interface; }
   inline void setAvailabilityEvent(IN const BTSDbusServiceAvailability availabilityEvent) { _availabilityEvent = availabilityEvent; }
   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSGenDbusServiceInterface getInterface(void) const { return _interface; }
   inline BTSDbusServiceAvailability getAvailabilityEvent(void) const { return _availabilityEvent; }
   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSGenDbusServiceInterface _interface; /**< parameter interface */
   BTSDbusServiceAvailability _availabilityEvent; /**< parameter availability event */
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_GetAllPropertiesConnection : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetAllPropertiesConnection();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetAllPropertiesConnection(IN const Ipc2Bts_GetAllPropertiesConnection& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetAllPropertiesConnection& operator=(IN const Ipc2Bts_GetAllPropertiesConnection& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetAllPropertiesConnection();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const ::ccdbusif::evolution::Interface interface) { _interface = interface; }
   inline void setProperties(IN const BTSDbusPropertyList& properties) { _properties = properties; }

   inline ::ccdbusif::evolution::Interface getInterface(void) const { return _interface; }
   inline void getProperties(OUT BTSDbusPropertyList& properties) const { properties = _properties; }
   inline const BTSDbusPropertyList& getProperties(void) const { return _properties; }
   inline BTSDbusPropertyList& getPropertiesMutable(void) { return _properties; }

private:
   ::ccdbusif::evolution::Interface _interface; /**< parameter interface */
   BTSDbusPropertyList _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_AddDeviceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddDeviceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddDeviceObjectPathMapping(IN const Ipc2Bts_AddDeviceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddDeviceObjectPathMapping& operator=(IN const Ipc2Bts_AddDeviceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddDeviceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelDeviceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelDeviceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelDeviceObjectPathMapping(IN const Ipc2Bts_DelDeviceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelDeviceObjectPathMapping& operator=(IN const Ipc2Bts_DelDeviceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelDeviceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AddProtocolObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddProtocolObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddProtocolObjectPathMapping(IN const Ipc2Bts_AddProtocolObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddProtocolObjectPathMapping& operator=(IN const Ipc2Bts_AddProtocolObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddProtocolObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
   BTSObjectPath _device; /**< parameter device */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelProtocolObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelProtocolObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelProtocolObjectPathMapping(IN const Ipc2Bts_DelProtocolObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelProtocolObjectPathMapping& operator=(IN const Ipc2Bts_DelProtocolObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelProtocolObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AddSerialObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddSerialObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddSerialObjectPathMapping(IN const Ipc2Bts_AddSerialObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddSerialObjectPathMapping& operator=(IN const Ipc2Bts_AddSerialObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddSerialObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelSerialObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelSerialObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelSerialObjectPathMapping(IN const Ipc2Bts_DelSerialObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelSerialObjectPathMapping& operator=(IN const Ipc2Bts_DelSerialObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelSerialObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_Release : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_Release();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_Release(IN const Ipc2Bts_Release& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_Release& operator=(IN const Ipc2Bts_Release& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_Release();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_RequestPinCode : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestPinCode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestPinCode(IN const Ipc2Bts_RequestPinCode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestPinCode& operator=(IN const Ipc2Bts_RequestPinCode& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestPinCode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DisplayPinCode : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DisplayPinCode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DisplayPinCode(IN const Ipc2Bts_DisplayPinCode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DisplayPinCode& operator=(IN const Ipc2Bts_DisplayPinCode& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DisplayPinCode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setPasskey(IN const BTSNumericValue& passkey) { _passkey = passkey; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getPasskey(OUT BTSNumericValue& passkey) const { passkey = _passkey; }
   inline const BTSNumericValue& getPasskey(void) const { return _passkey; }
   inline BTSNumericValue& getPasskeyMutable(void) { return _passkey; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSNumericValue _passkey; /**< parameter passkey */
};

/**
 *
 */
class Ipc2Bts_RequestPasskey : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestPasskey();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestPasskey(IN const Ipc2Bts_RequestPasskey& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestPasskey& operator=(IN const Ipc2Bts_RequestPasskey& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestPasskey();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_RequestConfirmation : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestConfirmation();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestConfirmation(IN const Ipc2Bts_RequestConfirmation& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestConfirmation& operator=(IN const Ipc2Bts_RequestConfirmation& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestConfirmation();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setPasskey(IN const BTSNumericValue& passkey) { _passkey = passkey; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getPasskey(OUT BTSNumericValue& passkey) const { passkey = _passkey; }
   inline const BTSNumericValue& getPasskey(void) const { return _passkey; }
   inline BTSNumericValue& getPasskeyMutable(void) { return _passkey; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSNumericValue _passkey; /**< parameter passkey */
};

/**
 *
 */
class Ipc2Bts_Cancel : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_Cancel();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_Cancel(IN const Ipc2Bts_Cancel& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_Cancel& operator=(IN const Ipc2Bts_Cancel& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_Cancel();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_CancelRequest : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CancelRequest();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CancelRequest(IN const Ipc2Bts_CancelRequest& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CancelRequest& operator=(IN const Ipc2Bts_CancelRequest& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CancelRequest();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_AuthorizeService : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AuthorizeService();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AuthorizeService(IN const Ipc2Bts_AuthorizeService& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AuthorizeService& operator=(IN const Ipc2Bts_AuthorizeService& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AuthorizeService();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
};

/**
 *
 */
class Ipc2Bts_RequestAuthorization : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestAuthorization();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestAuthorization(IN const Ipc2Bts_RequestAuthorization& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestAuthorization& operator=(IN const Ipc2Bts_RequestAuthorization& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestAuthorization();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_RequestLinkkey : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestLinkkey();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestLinkkey(IN const Ipc2Bts_RequestLinkkey& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestLinkkey& operator=(IN const Ipc2Bts_RequestLinkkey& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestLinkkey();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DisplayPasskey : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DisplayPasskey();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DisplayPasskey(IN const Ipc2Bts_DisplayPasskey& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DisplayPasskey& operator=(IN const Ipc2Bts_DisplayPasskey& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DisplayPasskey();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setPasskey(IN const BTSNumericValue& passkey) { _passkey = passkey; }
   inline void setEntered(IN const BTSNumberTypedKeys entered) { _entered = entered; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getPasskey(OUT BTSNumericValue& passkey) const { passkey = _passkey; }
   inline const BTSNumericValue& getPasskey(void) const { return _passkey; }
   inline BTSNumericValue& getPasskeyMutable(void) { return _passkey; }
   inline BTSNumberTypedKeys getEntered(void) const { return _entered; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSNumericValue _passkey; /**< parameter passkey */
   BTSNumberTypedKeys _entered; /**< parameter entered */
};

/**
 *
 */
class Ipc2Bts_StartDiscoveryResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_StartDiscoveryResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_StartDiscoveryResult(IN const Ipc2Bts_StartDiscoveryResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_StartDiscoveryResult& operator=(IN const Ipc2Bts_StartDiscoveryResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_StartDiscoveryResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_StopDiscoveryResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_StopDiscoveryResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_StopDiscoveryResult(IN const Ipc2Bts_StopDiscoveryResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_StopDiscoveryResult& operator=(IN const Ipc2Bts_StopDiscoveryResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_StopDiscoveryResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_RemoveDeviceResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RemoveDeviceResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RemoveDeviceResult(IN const Ipc2Bts_RemoveDeviceResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RemoveDeviceResult& operator=(IN const Ipc2Bts_RemoveDeviceResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RemoveDeviceResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_CreateDeviceResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CreateDeviceResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CreateDeviceResult(IN const Ipc2Bts_CreateDeviceResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CreateDeviceResult& operator=(IN const Ipc2Bts_CreateDeviceResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CreateDeviceResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SendHCICmdResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SendHCICmdResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SendHCICmdResult(IN const Ipc2Bts_SendHCICmdResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SendHCICmdResult& operator=(IN const Ipc2Bts_SendHCICmdResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SendHCICmdResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_AdapterInitialization : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterInitialization();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterInitialization(IN const Ipc2Bts_AdapterInitialization& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterInitialization& operator=(IN const Ipc2Bts_AdapterInitialization& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterInitialization();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_DeviceCreated : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceCreated();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceCreated(IN const Ipc2Bts_DeviceCreated& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceCreated& operator=(IN const Ipc2Bts_DeviceCreated& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceCreated();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceRemoved(IN const Ipc2Bts_DeviceRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceRemoved& operator=(IN const Ipc2Bts_DeviceRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_BtStackLog : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtStackLog();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtStackLog(IN const Ipc2Bts_BtStackLog& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtStackLog& operator=(IN const Ipc2Bts_BtStackLog& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtStackLog();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSLogStatus status) { _status = status; }
   inline void setLogOpcode(IN const BTSLogOpcode logOpcode) { _logOpcode = logOpcode; }
   inline void setLogLength(IN const BTSLogLength logLength) { _logLength = logLength; }
   inline void setLogData(IN const BTSLogData& logData) { _logData = logData; }

   inline BTSLogStatus getStatus(void) const { return _status; }
   inline BTSLogOpcode getLogOpcode(void) const { return _logOpcode; }
   inline BTSLogLength getLogLength(void) const { return _logLength; }
   inline void getLogData(OUT BTSLogData& logData) const { logData = _logData; }
   inline const BTSLogData& getLogData(void) const { return _logData; }
   inline BTSLogData& getLogDataMutable(void) { return _logData; }

private:
   BTSLogStatus _status; /**< parameter status */
   BTSLogOpcode _logOpcode; /**< parameter log opcode */
   BTSLogLength _logLength; /**< parameter log length */
   BTSLogData _logData; /**< parameter log data */
};

/**
 *
 */
class Ipc2Bts_HCIEvent : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_HCIEvent();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_HCIEvent(IN const Ipc2Bts_HCIEvent& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_HCIEvent& operator=(IN const Ipc2Bts_HCIEvent& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_HCIEvent();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setLength(IN const BTSHciLength length) { _length = length; }
   inline void setData(IN const BTSHciData& data) { _data = data; }

   inline BTSHciLength getLength(void) const { return _length; }
   inline void getData(OUT BTSHciData& data) const { data = _data; }
   inline const BTSHciData& getData(void) const { return _data; }
   inline BTSHciData& getDataMutable(void) { return _data; }

private:
   BTSHciLength _length; /**< parameter length */
   BTSHciData _data; /**< parameter data */
};

/**
 *
 */
class Ipc2Bts_DeviceFound : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceFound();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceFound(IN const Ipc2Bts_DeviceFound& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceFound& operator=(IN const Ipc2Bts_DeviceFound& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceFound();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSDiscoveredDeviceInfo& device) { _device = device; }

   inline void getDevice(OUT BTSDiscoveredDeviceInfo& device) const { device = _device; }
   inline const BTSDiscoveredDeviceInfo& getDevice(void) const { return _device; }
   inline BTSDiscoveredDeviceInfo& getDeviceMutable(void) { return _device; }

private:
   BTSDiscoveredDeviceInfo _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_AdapterAddressUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterAddressUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterAddressUpdate(IN const Ipc2Bts_AdapterAddressUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterAddressUpdate& operator=(IN const Ipc2Bts_AdapterAddressUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterAddressUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Ipc2Bts_AdapterClassUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterClassUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterClassUpdate(IN const Ipc2Bts_AdapterClassUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterClassUpdate& operator=(IN const Ipc2Bts_AdapterClassUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterClassUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setCod(IN const BTSCod cod) { _cod = cod; }

   inline BTSCod getCod(void) const { return _cod; }

private:
   BTSCod _cod; /**< parameter cod */
};

/**
 *
 */
class Ipc2Bts_AdapterAliasUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterAliasUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterAliasUpdate(IN const Ipc2Bts_AdapterAliasUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterAliasUpdate& operator=(IN const Ipc2Bts_AdapterAliasUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterAliasUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }

   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }

private:
   BTSDeviceName _alias; /**< parameter alias */
};

/**
 *
 */
class Ipc2Bts_AdapterPoweredUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterPoweredUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterPoweredUpdate(IN const Ipc2Bts_AdapterPoweredUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterPoweredUpdate& operator=(IN const Ipc2Bts_AdapterPoweredUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterPoweredUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPowered(IN const bool powered) { _powered = powered; }

   inline bool getPowered(void) const { return _powered; }

private:
   bool _powered; /**< parameter powered */
};

/**
 *
 */
class Ipc2Bts_AdapterDiscoverableUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterDiscoverableUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterDiscoverableUpdate(IN const Ipc2Bts_AdapterDiscoverableUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterDiscoverableUpdate& operator=(IN const Ipc2Bts_AdapterDiscoverableUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterDiscoverableUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDiscoverable(IN const bool discoverable) { _discoverable = discoverable; }

   inline bool getDiscoverable(void) const { return _discoverable; }

private:
   bool _discoverable; /**< parameter discoverable */
};

/**
 *
 */
class Ipc2Bts_AdapterDiscoverabletimeoutUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterDiscoverabletimeoutUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterDiscoverabletimeoutUpdate(IN const Ipc2Bts_AdapterDiscoverabletimeoutUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterDiscoverabletimeoutUpdate& operator=(IN const Ipc2Bts_AdapterDiscoverabletimeoutUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterDiscoverabletimeoutUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDiscoverableTimeout(IN const BTSDiscoverableTimeout discoverableTimeout) { _discoverableTimeout = discoverableTimeout; }

   inline BTSDiscoverableTimeout getDiscoverableTimeout(void) const { return _discoverableTimeout; }

private:
   BTSDiscoverableTimeout _discoverableTimeout; /**< parameter discoverable timeout */
};

/**
 *
 */
class Ipc2Bts_AdapterPairableUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterPairableUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterPairableUpdate(IN const Ipc2Bts_AdapterPairableUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterPairableUpdate& operator=(IN const Ipc2Bts_AdapterPairableUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterPairableUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPairable(IN const bool pairable) { _pairable = pairable; }

   inline bool getPairable(void) const { return _pairable; }

private:
   bool _pairable; /**< parameter pairable */
};

/**
 *
 */
class Ipc2Bts_AdapterPairabletimeoutUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterPairabletimeoutUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterPairabletimeoutUpdate(IN const Ipc2Bts_AdapterPairabletimeoutUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterPairabletimeoutUpdate& operator=(IN const Ipc2Bts_AdapterPairabletimeoutUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterPairabletimeoutUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPairableTimeout(IN const BTSPairableTimeout pairableTimeout) { _pairableTimeout = pairableTimeout; }

   inline BTSPairableTimeout getPairableTimeout(void) const { return _pairableTimeout; }

private:
   BTSPairableTimeout _pairableTimeout; /**< parameter pairable timeout */
};

/**
 *
 */
class Ipc2Bts_AdapterDiscoveringUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterDiscoveringUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterDiscoveringUpdate(IN const Ipc2Bts_AdapterDiscoveringUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterDiscoveringUpdate& operator=(IN const Ipc2Bts_AdapterDiscoveringUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterDiscoveringUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDiscovering(IN const bool discovering) { _discovering = discovering; }

   inline bool getDiscovering(void) const { return _discovering; }

private:
   bool _discovering; /**< parameter discovering */
};

/**
 *
 */
class Ipc2Bts_AdapterUuidsUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterUuidsUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterUuidsUpdate(IN const Ipc2Bts_AdapterUuidsUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterUuidsUpdate& operator=(IN const Ipc2Bts_AdapterUuidsUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterUuidsUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setUuids(IN const BTSUuidList& uuids) { _uuids = uuids; }

   inline void getUuids(OUT BTSUuidList& uuids) const { uuids = _uuids; }
   inline const BTSUuidList& getUuids(void) const { return _uuids; }
   inline BTSUuidList& getUuidsMutable(void) { return _uuids; }

private:
   BTSUuidList _uuids; /**< parameter uuids */
};

/**
 *
 */
class Ipc2Bts_AdapterWbsModeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterWbsModeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterWbsModeUpdate(IN const Ipc2Bts_AdapterWbsModeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterWbsModeUpdate& operator=(IN const Ipc2Bts_AdapterWbsModeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterWbsModeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setWbsMode(IN const bool wbsMode) { _wbsMode = wbsMode; }

   inline bool getWbsMode(void) const { return _wbsMode; }

private:
   bool _wbsMode; /**< parameter wbs mode */
};

/**
 *
 */
class Ipc2Bts_AdapterConnectableUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterConnectableUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterConnectableUpdate(IN const Ipc2Bts_AdapterConnectableUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterConnectableUpdate& operator=(IN const Ipc2Bts_AdapterConnectableUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterConnectableUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setConnectable(IN const bool connectable) { _connectable = connectable; }

   inline bool getConnectable(void) const { return _connectable; }

private:
   bool _connectable; /**< parameter connectable */
};

/**
 *
 */
class Ipc2Bts_AdapterHcimodeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterHcimodeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterHcimodeUpdate(IN const Ipc2Bts_AdapterHcimodeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterHcimodeUpdate& operator=(IN const Ipc2Bts_AdapterHcimodeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterHcimodeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setHciMode(IN const bool hciMode) { _hciMode = hciMode; }

   inline bool getHciMode(void) const { return _hciMode; }

private:
   bool _hciMode; /**< parameter hci mode */
};

/**
 *
 */
class Ipc2Bts_AdapterVersionUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterVersionUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterVersionUpdate(IN const Ipc2Bts_AdapterVersionUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterVersionUpdate& operator=(IN const Ipc2Bts_AdapterVersionUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterVersionUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStackVersion(IN const BTSEvolutionVersion& stackVersion) { _stackVersion = stackVersion; }

   inline void getStackVersion(OUT BTSEvolutionVersion& stackVersion) const { stackVersion = _stackVersion; }
   inline const BTSEvolutionVersion& getStackVersion(void) const { return _stackVersion; }
   inline BTSEvolutionVersion& getStackVersionMutable(void) { return _stackVersion; }

private:
   BTSEvolutionVersion _stackVersion; /**< parameter stack version */
};

/**
 *
 */
class Ipc2Bts_AdapterTraceLevelUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterTraceLevelUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterTraceLevelUpdate(IN const Ipc2Bts_AdapterTraceLevelUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterTraceLevelUpdate& operator=(IN const Ipc2Bts_AdapterTraceLevelUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterTraceLevelUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTraceLevel(IN const BTSGeniviTraceLevel& traceLevel) { _traceLevel = traceLevel; }

   inline void getTraceLevel(OUT BTSGeniviTraceLevel& traceLevel) const { traceLevel = _traceLevel; }
   inline const BTSGeniviTraceLevel& getTraceLevel(void) const { return _traceLevel; }
   inline BTSGeniviTraceLevel& getTraceLevelMutable(void) { return _traceLevel; }

private:
   BTSGeniviTraceLevel _traceLevel; /**< parameter trace level */
};

/**
 *
 */
class Ipc2Bts_AdapterTraceCategoryUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterTraceCategoryUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterTraceCategoryUpdate(IN const Ipc2Bts_AdapterTraceCategoryUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterTraceCategoryUpdate& operator=(IN const Ipc2Bts_AdapterTraceCategoryUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterTraceCategoryUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTraceCategory(IN const BTSGeniviTraceCategory& traceCategory) { _traceCategory = traceCategory; }

   inline void getTraceCategory(OUT BTSGeniviTraceCategory& traceCategory) const { traceCategory = _traceCategory; }
   inline const BTSGeniviTraceCategory& getTraceCategory(void) const { return _traceCategory; }
   inline BTSGeniviTraceCategory& getTraceCategoryMutable(void) { return _traceCategory; }

private:
   BTSGeniviTraceCategory _traceCategory; /**< parameter trace category */
};

/**
 *
 */
class Ipc2Bts_AdapterAvailableSppServersUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AdapterAvailableSppServersUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AdapterAvailableSppServersUpdate(IN const Ipc2Bts_AdapterAvailableSppServersUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AdapterAvailableSppServersUpdate& operator=(IN const Ipc2Bts_AdapterAvailableSppServersUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AdapterAvailableSppServersUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAvailableSppServers(IN const BTSUuidList& availableSppServers) { _availableSppServers = availableSppServers; }

   inline void getAvailableSppServers(OUT BTSUuidList& availableSppServers) const { availableSppServers = _availableSppServers; }
   inline const BTSUuidList& getAvailableSppServers(void) const { return _availableSppServers; }
   inline BTSUuidList& getAvailableSppServersMutable(void) { return _availableSppServers; }

private:
   BTSUuidList _availableSppServers; /**< parameter available spp servers */
};

/**
 *
 */
class Ipc2Bts_RegisterAgentResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RegisterAgentResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RegisterAgentResult(IN const Ipc2Bts_RegisterAgentResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RegisterAgentResult& operator=(IN const Ipc2Bts_RegisterAgentResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RegisterAgentResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_UnregisterAgentResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_UnregisterAgentResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_UnregisterAgentResult(IN const Ipc2Bts_UnregisterAgentResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_UnregisterAgentResult& operator=(IN const Ipc2Bts_UnregisterAgentResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_UnregisterAgentResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_RequestDefaultAgentResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RequestDefaultAgentResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RequestDefaultAgentResult(IN const Ipc2Bts_RequestDefaultAgentResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RequestDefaultAgentResult& operator=(IN const Ipc2Bts_RequestDefaultAgentResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RequestDefaultAgentResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_DeviceConnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceConnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceConnectResult(IN const Ipc2Bts_DeviceConnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceConnectResult& operator=(IN const Ipc2Bts_DeviceConnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceConnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceDisconnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceDisconnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceDisconnectResult(IN const Ipc2Bts_DeviceDisconnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceDisconnectResult& operator=(IN const Ipc2Bts_DeviceDisconnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceDisconnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_PairResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_PairResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_PairResult(IN const Ipc2Bts_PairResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_PairResult& operator=(IN const Ipc2Bts_PairResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_PairResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_CancelPairingResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CancelPairingResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CancelPairingResult(IN const Ipc2Bts_CancelPairingResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CancelPairingResult& operator=(IN const Ipc2Bts_CancelPairingResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CancelPairingResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DiscoverServicesResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DiscoverServicesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DiscoverServicesResult(IN const Ipc2Bts_DiscoverServicesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DiscoverServicesResult& operator=(IN const Ipc2Bts_DiscoverServicesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DiscoverServicesResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_CancelDiscoveryResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CancelDiscoveryResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CancelDiscoveryResult(IN const Ipc2Bts_CancelDiscoveryResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CancelDiscoveryResult& operator=(IN const Ipc2Bts_CancelDiscoveryResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CancelDiscoveryResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_ReportLinkkey : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ReportLinkkey();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ReportLinkkey(IN const Ipc2Bts_ReportLinkkey& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ReportLinkkey& operator=(IN const Ipc2Bts_ReportLinkkey& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ReportLinkkey();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setLinkKey(IN const BTSLinkKey& linkKey) { _linkKey = linkKey; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getLinkKey(OUT BTSLinkKey& linkKey) const { linkKey = _linkKey; }
   inline const BTSLinkKey& getLinkKey(void) const { return _linkKey; }
   inline BTSLinkKey& getLinkKeyMutable(void) { return _linkKey; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSLinkKey _linkKey; /**< parameter link key */
};

/**
 *
 */
class Ipc2Bts_IncomingPairingComp : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_IncomingPairingComp();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_IncomingPairingComp(IN const Ipc2Bts_IncomingPairingComp& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_IncomingPairingComp& operator=(IN const Ipc2Bts_IncomingPairingComp& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_IncomingPairingComp();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_SDPProcessReport : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SDPProcessReport();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SDPProcessReport(IN const Ipc2Bts_SDPProcessReport& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SDPProcessReport& operator=(IN const Ipc2Bts_SDPProcessReport& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SDPProcessReport();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setActive(IN const bool active) { _active = active; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline bool getActive(void) const { return _active; }

private:
   BTSObjectPath _device; /**< parameter device */
   bool _active; /**< parameter active */
};

/**
 *
 */
class Ipc2Bts_DeviceAddressUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceAddressUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceAddressUpdate(IN const Ipc2Bts_DeviceAddressUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceAddressUpdate& operator=(IN const Ipc2Bts_DeviceAddressUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceAddressUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceClassUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceClassUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceClassUpdate(IN const Ipc2Bts_DeviceClassUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceClassUpdate& operator=(IN const Ipc2Bts_DeviceClassUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceClassUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setCod(IN const BTSCod cod) { _cod = cod; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSCod getCod(void) const { return _cod; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSCod _cod; /**< parameter cod */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceIconUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceIconUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceIconUpdate(IN const Ipc2Bts_DeviceIconUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceIconUpdate& operator=(IN const Ipc2Bts_DeviceIconUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceIconUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setIcon(IN const BTSIconName& icon) { _icon = icon; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getIcon(OUT BTSIconName& icon) const { icon = _icon; }
   inline const BTSIconName& getIcon(void) const { return _icon; }
   inline BTSIconName& getIconMutable(void) { return _icon; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSIconName _icon; /**< parameter icon */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceUuidsUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceUuidsUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceUuidsUpdate(IN const Ipc2Bts_DeviceUuidsUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceUuidsUpdate& operator=(IN const Ipc2Bts_DeviceUuidsUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceUuidsUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSupportedServices(IN const BTSSupportedServices& supportedServices) { _supportedServices = supportedServices; }
   inline void setUuidList(IN const BTSUuidList& uuidList) { _uuidList = uuidList; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getSupportedServices(OUT BTSSupportedServices& supportedServices) const { supportedServices = _supportedServices; }
   inline const BTSSupportedServices& getSupportedServices(void) const { return _supportedServices; }
   inline BTSSupportedServices& getSupportedServicesMutable(void) { return _supportedServices; }
   inline void getUuidList(OUT BTSUuidList& uuidList) const { uuidList = _uuidList; }
   inline const BTSUuidList& getUuidList(void) const { return _uuidList; }
   inline BTSUuidList& getUuidListMutable(void) { return _uuidList; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSSupportedServices _supportedServices; /**< parameter supported services */
   BTSUuidList _uuidList; /**< parameter uuid list */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DevicePairedUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DevicePairedUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DevicePairedUpdate(IN const Ipc2Bts_DevicePairedUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DevicePairedUpdate& operator=(IN const Ipc2Bts_DevicePairedUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DevicePairedUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPaired(IN const bool paired) { _paired = paired; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getPaired(void) const { return _paired; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _paired; /**< parameter paired */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceConnectedUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceConnectedUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceConnectedUpdate(IN const Ipc2Bts_DeviceConnectedUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceConnectedUpdate& operator=(IN const Ipc2Bts_DeviceConnectedUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceConnectedUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setConnected(IN const bool connected) { _connected = connected; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getConnected(void) const { return _connected; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _connected; /**< parameter connected */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceTrustedUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceTrustedUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceTrustedUpdate(IN const Ipc2Bts_DeviceTrustedUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceTrustedUpdate& operator=(IN const Ipc2Bts_DeviceTrustedUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceTrustedUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTrusted(IN const bool trusted) { _trusted = trusted; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getTrusted(void) const { return _trusted; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _trusted; /**< parameter trusted */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceBlockedUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceBlockedUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceBlockedUpdate(IN const Ipc2Bts_DeviceBlockedUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceBlockedUpdate& operator=(IN const Ipc2Bts_DeviceBlockedUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceBlockedUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setBlocked(IN const bool blocked) { _blocked = blocked; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getBlocked(void) const { return _blocked; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _blocked; /**< parameter blocked */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceAliasUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceAliasUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceAliasUpdate(IN const Ipc2Bts_DeviceAliasUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceAliasUpdate& operator=(IN const Ipc2Bts_DeviceAliasUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceAliasUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSDeviceName _alias; /**< parameter alias */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceAdapterUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceAdapterUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceAdapterUpdate(IN const Ipc2Bts_DeviceAdapterUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceAdapterUpdate& operator=(IN const Ipc2Bts_DeviceAdapterUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceAdapterUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAdapter(IN const BTSObjectPath& adapter) { _adapter = adapter; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getAdapter(OUT BTSObjectPath& adapter) const { adapter = _adapter; }
   inline const BTSObjectPath& getAdapter(void) const { return _adapter; }
   inline BTSObjectPath& getAdapterMutable(void) { return _adapter; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _adapter; /**< parameter adapter */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceModaliasUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceModaliasUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceModaliasUpdate(IN const Ipc2Bts_DeviceModaliasUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceModaliasUpdate& operator=(IN const Ipc2Bts_DeviceModaliasUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceModaliasUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setModalias(IN const BTSModalias& modalias) { _modalias = modalias; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getModalias(OUT BTSModalias& modalias) const { modalias = _modalias; }
   inline const BTSModalias& getModalias(void) const { return _modalias; }
   inline BTSModalias& getModaliasMutable(void) { return _modalias; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSModalias _modalias; /**< parameter modalias */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceRssiUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceRssiUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceRssiUpdate(IN const Ipc2Bts_DeviceRssiUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceRssiUpdate& operator=(IN const Ipc2Bts_DeviceRssiUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceRssiUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setRssi(IN const BTSRssi rssi) { _rssi = rssi; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSRssi getRssi(void) const { return _rssi; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSRssi _rssi; /**< parameter rssi */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceVendorIdUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceVendorIdUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceVendorIdUpdate(IN const Ipc2Bts_DeviceVendorIdUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceVendorIdUpdate& operator=(IN const Ipc2Bts_DeviceVendorIdUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceVendorIdUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setVendorId(IN const BTSVendorId vendorId) { _vendorId = vendorId; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSVendorId getVendorId(void) const { return _vendorId; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSVendorId _vendorId; /**< parameter vendor id */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceVendorIdSourceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceVendorIdSourceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceVendorIdSourceUpdate(IN const Ipc2Bts_DeviceVendorIdSourceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceVendorIdSourceUpdate& operator=(IN const Ipc2Bts_DeviceVendorIdSourceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceVendorIdSourceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setVendorIdSource(IN const BTSVendorIdSource vendorIdSource) { _vendorIdSource = vendorIdSource; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSVendorIdSource getVendorIdSource(void) const { return _vendorIdSource; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSVendorIdSource _vendorIdSource; /**< parameter vendor id source */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceProductIdUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceProductIdUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceProductIdUpdate(IN const Ipc2Bts_DeviceProductIdUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceProductIdUpdate& operator=(IN const Ipc2Bts_DeviceProductIdUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceProductIdUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProductId(IN const BTSProductId productId) { _productId = productId; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSProductId getProductId(void) const { return _productId; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSProductId _productId; /**< parameter product id */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceMapInfoUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceMapInfoUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceMapInfoUpdate(IN const Ipc2Bts_DeviceMapInfoUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceMapInfoUpdate& operator=(IN const Ipc2Bts_DeviceMapInfoUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceMapInfoUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setValid(IN const bool valid) { _valid = valid; }
   inline void setMapInfoList(IN const BTSMapSdpRecordList& mapInfoList) { _mapInfoList = mapInfoList; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getValid(void) const { return _valid; }
   inline void getMapInfoList(OUT BTSMapSdpRecordList& mapInfoList) const { mapInfoList = _mapInfoList; }
   inline const BTSMapSdpRecordList& getMapInfoList(void) const { return _mapInfoList; }
   inline BTSMapSdpRecordList& getMapInfoListMutable(void) { return _mapInfoList; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _valid; /**< parameter valid */
   BTSMapSdpRecordList _mapInfoList; /**< parameter map info list */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceConnectedServiceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceConnectedServiceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceConnectedServiceUpdate(IN const Ipc2Bts_DeviceConnectedServiceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceConnectedServiceUpdate& operator=(IN const Ipc2Bts_DeviceConnectedServiceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceConnectedServiceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setConnectedService(IN const BTSServiceFunction& connectedService) { _connectedService = connectedService; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getConnectedService(OUT BTSServiceFunction& connectedService) const { connectedService = _connectedService; }
   inline const BTSServiceFunction& getConnectedService(void) const { return _connectedService; }
   inline BTSServiceFunction& getConnectedServiceMutable(void) { return _connectedService; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSServiceFunction _connectedService; /**< parameter connected service */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceVersionUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceVersionUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceVersionUpdate(IN const Ipc2Bts_DeviceVersionUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceVersionUpdate& operator=(IN const Ipc2Bts_DeviceVersionUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceVersionUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setVersion(IN const BTSVersion version) { _version = version; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSVersion getVersion(void) const { return _version; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSVersion _version; /**< parameter version */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DevicePbapInfoUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DevicePbapInfoUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DevicePbapInfoUpdate(IN const Ipc2Bts_DevicePbapInfoUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DevicePbapInfoUpdate& operator=(IN const Ipc2Bts_DevicePbapInfoUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DevicePbapInfoUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setValid(IN const bool valid) { _valid = valid; }
   inline void setPbapInfo(IN const BTSPbapSdpRecord& pbapInfo) { _pbapInfo = pbapInfo; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getValid(void) const { return _valid; }
   inline void getPbapInfo(OUT BTSPbapSdpRecord& pbapInfo) const { pbapInfo = _pbapInfo; }
   inline const BTSPbapSdpRecord& getPbapInfo(void) const { return _pbapInfo; }
   inline BTSPbapSdpRecord& getPbapInfoMutable(void) { return _pbapInfo; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _valid; /**< parameter valid */
   BTSPbapSdpRecord _pbapInfo; /**< parameter pbap info */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceModeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceModeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceModeUpdate(IN const Ipc2Bts_DeviceModeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceModeUpdate& operator=(IN const Ipc2Bts_DeviceModeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceModeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setMode(IN const BTSBtPowerMode mode) { _mode = mode; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSBtPowerMode getMode(void) const { return _mode; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSBtPowerMode _mode; /**< parameter mode */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceRoleUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceRoleUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceRoleUpdate(IN const Ipc2Bts_DeviceRoleUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceRoleUpdate& operator=(IN const Ipc2Bts_DeviceRoleUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceRoleUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setMaster(IN const bool master) { _master = master; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getMaster(void) const { return _master; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _master; /**< parameter master */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_DeviceEnableAvpPauseUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DeviceEnableAvpPauseUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DeviceEnableAvpPauseUpdate(IN const Ipc2Bts_DeviceEnableAvpPauseUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DeviceEnableAvpPauseUpdate& operator=(IN const Ipc2Bts_DeviceEnableAvpPauseUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DeviceEnableAvpPauseUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setEnableAvpPause(IN const bool enableAvpPause) { _enableAvpPause = enableAvpPause; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getEnableAvpPause(void) const { return _enableAvpPause; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _enableAvpPause; /**< parameter enable avp pause */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceConnectReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceConnectReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceConnectReqResult(IN const Ipc2Bts_BtApplDeviceConnectReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceConnectReqResult& operator=(IN const Ipc2Bts_BtApplDeviceConnectReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceConnectReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceDisconnectReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceDisconnectReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceDisconnectReqResult(IN const Ipc2Bts_BtApplDeviceDisconnectReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceDisconnectReqResult& operator=(IN const Ipc2Bts_BtApplDeviceDisconnectReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceDisconnectReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplCancelConnectReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplCancelConnectReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplCancelConnectReqResult(IN const Ipc2Bts_BtApplCancelConnectReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplCancelConnectReqResult& operator=(IN const Ipc2Bts_BtApplCancelConnectReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplCancelConnectReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplGetHwVersionReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplGetHwVersionReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplGetHwVersionReqResult(IN const Ipc2Bts_BtApplGetHwVersionReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplGetHwVersionReqResult& operator=(IN const Ipc2Bts_BtApplGetHwVersionReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplGetHwVersionReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplSetConfigurationReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplSetConfigurationReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplSetConfigurationReqResult(IN const Ipc2Bts_BtApplSetConfigurationReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplSetConfigurationReqResult& operator=(IN const Ipc2Bts_BtApplSetConfigurationReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplSetConfigurationReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
};

/**
 *
 */
class Ipc2Bts_BtApplReadConfigurationReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplReadConfigurationReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplReadConfigurationReqResult(IN const Ipc2Bts_BtApplReadConfigurationReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplReadConfigurationReqResult& operator=(IN const Ipc2Bts_BtApplReadConfigurationReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplReadConfigurationReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
};

/**
 *
 */
class Ipc2Bts_BtApplTestModeReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplTestModeReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplTestModeReqResult(IN const Ipc2Bts_BtApplTestModeReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplTestModeReqResult& operator=(IN const Ipc2Bts_BtApplTestModeReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplTestModeReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplTestModeLinkQualityReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplTestModeLinkQualityReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplTestModeLinkQualityReqResult(IN const Ipc2Bts_BtApplTestModeLinkQualityReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplTestModeLinkQualityReqResult& operator=(IN const Ipc2Bts_BtApplTestModeLinkQualityReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplTestModeLinkQualityReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceConnectCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceConnectCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceConnectCfm(IN const Ipc2Bts_BtApplDeviceConnectCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceConnectCfm& operator=(IN const Ipc2Bts_BtApplDeviceConnectCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceConnectCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceConnectInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceConnectInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceConnectInd(IN const Ipc2Bts_BtApplDeviceConnectInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceConnectInd& operator=(IN const Ipc2Bts_BtApplDeviceConnectInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceConnectInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }

private:
   BTSStatusCode _status; /**< parameter status */
   // see base class: BTSBDAddress _deviceAddress;
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceDisconnectCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceDisconnectCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceDisconnectCfm(IN const Ipc2Bts_BtApplDeviceDisconnectCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceDisconnectCfm& operator=(IN const Ipc2Bts_BtApplDeviceDisconnectCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceDisconnectCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceDisconnectInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceDisconnectInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceDisconnectInd(IN const Ipc2Bts_BtApplDeviceDisconnectInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceDisconnectInd& operator=(IN const Ipc2Bts_BtApplDeviceDisconnectInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceDisconnectInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setReason(IN const BTSBtApplDisconnectReason reason) { _reason = reason; }
   inline void setServiceFunction(IN const BTSServiceFunction& serviceFunction) { _serviceFunction = serviceFunction; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSBtApplDisconnectReason getReason(void) const { return _reason; }
   inline void getServiceFunction(OUT BTSServiceFunction& serviceFunction) const { serviceFunction = _serviceFunction; }
   inline const BTSServiceFunction& getServiceFunction(void) const { return _serviceFunction; }
   inline BTSServiceFunction& getServiceFunctionMutable(void) { return _serviceFunction; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }

private:
   BTSStatusCode _status; /**< parameter status */
   // see base class: BTSBDAddress _deviceAddress;
   BTSBtApplDisconnectReason _reason; /**< parameter reason */
   BTSServiceFunction _serviceFunction; /**< parameter service function */
   BTSInstanceIndex _instance; /**< parameter instance */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceDisconnectCompInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceDisconnectCompInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceDisconnectCompInd(IN const Ipc2Bts_BtApplDeviceDisconnectCompInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceDisconnectCompInd& operator=(IN const Ipc2Bts_BtApplDeviceDisconnectCompInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceDisconnectCompInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplDeviceConnectCompInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDeviceConnectCompInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDeviceConnectCompInd(IN const Ipc2Bts_BtApplDeviceConnectCompInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDeviceConnectCompInd& operator=(IN const Ipc2Bts_BtApplDeviceConnectCompInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDeviceConnectCompInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setOpId(IN const BTSOperationId opId) { _opId = opId; }

   inline BTSOperationId getOpId(void) const { return _opId; }

private:
   BTSOperationId _opId; /**< parameter op id */
};

/**
 *
 */
class Ipc2Bts_BtApplCancelConnectCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplCancelConnectCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplCancelConnectCfm(IN const Ipc2Bts_BtApplCancelConnectCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplCancelConnectCfm& operator=(IN const Ipc2Bts_BtApplCancelConnectCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplCancelConnectCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_BtApplStatusNotificationInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplStatusNotificationInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplStatusNotificationInd(IN const Ipc2Bts_BtApplStatusNotificationInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplStatusNotificationInd& operator=(IN const Ipc2Bts_BtApplStatusNotificationInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplStatusNotificationInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   BTSDeviceName _deviceName; /**< parameter device name */
};

/**
 *
 */
class Ipc2Bts_BtApplGetHwVersionCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplGetHwVersionCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplGetHwVersionCfm(IN const Ipc2Bts_BtApplGetHwVersionCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplGetHwVersionCfm& operator=(IN const Ipc2Bts_BtApplGetHwVersionCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplGetHwVersionCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setBtCoreVersion(IN const BTSBtCoreVersion btCoreVersion) { _btCoreVersion = btCoreVersion; }
   inline void setManufacturer(IN const BTSManufacturerNameController manufacturer) { _manufacturer = manufacturer; }
   inline void setHwSubVersion(IN const BTSSubVersionController hwSubVersion) { _hwSubVersion = hwSubVersion; }
   inline void setExtInfo(IN const BTSExtensionInfo& extInfo) { _extInfo = extInfo; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSBtCoreVersion getBtCoreVersion(void) const { return _btCoreVersion; }
   inline BTSManufacturerNameController getManufacturer(void) const { return _manufacturer; }
   inline BTSSubVersionController getHwSubVersion(void) const { return _hwSubVersion; }
   inline void getExtInfo(OUT BTSExtensionInfo& extInfo) const { extInfo = _extInfo; }
   inline const BTSExtensionInfo& getExtInfo(void) const { return _extInfo; }
   inline BTSExtensionInfo& getExtInfoMutable(void) { return _extInfo; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSBtCoreVersion _btCoreVersion; /**< parameter bt core version */
   BTSManufacturerNameController _manufacturer; /**< parameter manufacturer */
   BTSSubVersionController _hwSubVersion; /**< parameter hw sub version */
   BTSExtensionInfo _extInfo; /**< parameter ext info */
};

/**
 *
 */
class Ipc2Bts_BtApplSetConfigurationCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplSetConfigurationCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplSetConfigurationCfm(IN const Ipc2Bts_BtApplSetConfigurationCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplSetConfigurationCfm& operator=(IN const Ipc2Bts_BtApplSetConfigurationCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplSetConfigurationCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
};

/**
 *
 */
class Ipc2Bts_BtApplReadConfigurationCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplReadConfigurationCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplReadConfigurationCfm(IN const Ipc2Bts_BtApplReadConfigurationCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplReadConfigurationCfm& operator=(IN const Ipc2Bts_BtApplReadConfigurationCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplReadConfigurationCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setConfigId(IN const BTSEvoConfigIdEnum configId) { _configId = configId; }
   inline void setData(IN const BTSEvoConfigDataStream& data) { _data = data; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSEvoConfigIdEnum getConfigId(void) const { return _configId; }
   inline void getData(OUT BTSEvoConfigDataStream& data) const { data = _data; }
   inline const BTSEvoConfigDataStream& getData(void) const { return _data; }
   inline BTSEvoConfigDataStream& getDataMutable(void) { return _data; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSEvoConfigIdEnum _configId; /**< parameter config id */
   BTSEvoConfigDataStream _data; /**< parameter data */
};

/**
 *
 */
class Ipc2Bts_BtApplTestModeCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplTestModeCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplTestModeCfm(IN const Ipc2Bts_BtApplTestModeCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplTestModeCfm& operator=(IN const Ipc2Bts_BtApplTestModeCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplTestModeCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_BtApplTestModeCompInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplTestModeCompInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplTestModeCompInd(IN const Ipc2Bts_BtApplTestModeCompInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplTestModeCompInd& operator=(IN const Ipc2Bts_BtApplTestModeCompInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplTestModeCompInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setEnable(IN const bool enable) { _enable = enable; }
   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline bool getEnable(void) const { return _enable; }
   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   bool _enable; /**< parameter enable */
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_BtApplTestModeLinkQualityCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplTestModeLinkQualityCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplTestModeLinkQualityCfm(IN const Ipc2Bts_BtApplTestModeLinkQualityCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplTestModeLinkQualityCfm& operator=(IN const Ipc2Bts_BtApplTestModeLinkQualityCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplTestModeLinkQualityCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setRssi(IN const BTSRssi rssi) { _rssi = rssi; }
   inline void setLinkQuality(IN const BTSLinkQuality linkQuality) { _linkQuality = linkQuality; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSRssi getRssi(void) const { return _rssi; }
   inline BTSLinkQuality getLinkQuality(void) const { return _linkQuality; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSRssi _rssi; /**< parameter rssi */
   BTSLinkQuality _linkQuality; /**< parameter link quality */
};

/**
 *
 */
class Ipc2Bts_ConnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnectResult(IN const Ipc2Bts_ConnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnectResult& operator=(IN const Ipc2Bts_ConnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_DisconnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DisconnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DisconnectResult(IN const Ipc2Bts_DisconnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DisconnectResult& operator=(IN const Ipc2Bts_DisconnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DisconnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_ServiceRemoteUuidUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceRemoteUuidUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceRemoteUuidUpdate(IN const Ipc2Bts_ServiceRemoteUuidUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceRemoteUuidUpdate& operator=(IN const Ipc2Bts_ServiceRemoteUuidUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceRemoteUuidUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }
   inline void setUuid(IN const BTSUuid& uuid) { _uuid = uuid; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProtocolId getProtocol(void) const { return _protocol; }
   inline void getUuid(OUT BTSUuid& uuid) const { uuid = _uuid; }
   inline const BTSUuid& getUuid(void) const { return _uuid; }
   inline BTSUuid& getUuidMutable(void) { return _uuid; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSProtocolId _protocol; /**< parameter protocol */
   BTSUuid _uuid; /**< parameter uuid */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_ServiceStateUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceStateUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceStateUpdate(IN const Ipc2Bts_ServiceStateUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceStateUpdate& operator=(IN const Ipc2Bts_ServiceStateUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceStateUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServiceState(IN const BTSServiceState serviceState) { _serviceState = serviceState; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSServiceState getServiceState(void) const { return _serviceState; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSServiceState _serviceState; /**< parameter service state */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_ServiceDeviceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceDeviceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceDeviceUpdate(IN const Ipc2Bts_ServiceDeviceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceDeviceUpdate& operator=(IN const Ipc2Bts_ServiceDeviceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceDeviceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_ServiceVersionUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ServiceVersionUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ServiceVersionUpdate(IN const Ipc2Bts_ServiceVersionUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ServiceVersionUpdate& operator=(IN const Ipc2Bts_ServiceVersionUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ServiceVersionUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setVersion(IN const BTSProfileVersion version) { _version = version; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline BTSProfileVersion getVersion(void) const { return _version; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSProfileVersion _version; /**< parameter version */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_DebugTraceConfigResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DebugTraceConfigResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DebugTraceConfigResult(IN const Ipc2Bts_DebugTraceConfigResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DebugTraceConfigResult& operator=(IN const Ipc2Bts_DebugTraceConfigResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DebugTraceConfigResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_ProtocolTraceConfigResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ProtocolTraceConfigResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ProtocolTraceConfigResult(IN const Ipc2Bts_ProtocolTraceConfigResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ProtocolTraceConfigResult& operator=(IN const Ipc2Bts_ProtocolTraceConfigResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ProtocolTraceConfigResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_ReportDebugTrace : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ReportDebugTrace();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ReportDebugTrace(IN const Ipc2Bts_ReportDebugTrace& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ReportDebugTrace& operator=(IN const Ipc2Bts_ReportDebugTrace& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ReportDebugTrace();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTraceLocation(IN const BTSDebugTraceLocation traceLocation) { _traceLocation = traceLocation; }
   inline void setTraceLevel(IN const BTSDebugTraceLevel traceLevel) { _traceLevel = traceLevel; }
   inline void setTraceCategory(IN const BTSDebugTraceCategory traceCategory) { _traceCategory = traceCategory; }
   inline void setErrorCode(IN const BTSDebugTraceErrorCode errorCode) { _errorCode = errorCode; }
   inline void setTraceLength(IN const BTSDebugTraceLength traceLength) { _traceLength = traceLength; }
   inline void setTraceData(IN const BTSDebugTraceData& traceData) { _traceData = traceData; }

   inline BTSDebugTraceLocation getTraceLocation(void) const { return _traceLocation; }
   inline BTSDebugTraceLevel getTraceLevel(void) const { return _traceLevel; }
   inline BTSDebugTraceCategory getTraceCategory(void) const { return _traceCategory; }
   inline BTSDebugTraceErrorCode getErrorCode(void) const { return _errorCode; }
   inline BTSDebugTraceLength getTraceLength(void) const { return _traceLength; }
   inline void getTraceData(OUT BTSDebugTraceData& traceData) const { traceData = _traceData; }
   inline const BTSDebugTraceData& getTraceData(void) const { return _traceData; }
   inline BTSDebugTraceData& getTraceDataMutable(void) { return _traceData; }

private:
   BTSDebugTraceLocation _traceLocation; /**< parameter trace location */
   BTSDebugTraceLevel _traceLevel; /**< parameter trace level */
   BTSDebugTraceCategory _traceCategory; /**< parameter trace category */
   BTSDebugTraceErrorCode _errorCode; /**< parameter error code */
   BTSDebugTraceLength _traceLength; /**< parameter trace length */
   BTSDebugTraceData _traceData; /**< parameter trace data */
};

/**
 *
 */
class Ipc2Bts_ReportProtocolTrace : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ReportProtocolTrace();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ReportProtocolTrace(IN const Ipc2Bts_ReportProtocolTrace& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ReportProtocolTrace& operator=(IN const Ipc2Bts_ReportProtocolTrace& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ReportProtocolTrace();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTraceType(IN const BTSDebugTraceFilter traceType) { _traceType = traceType; }
   inline void setTraceDirection(IN const BTSDebugTraceDirection traceDirection) { _traceDirection = traceDirection; }
   inline void setTraceLength(IN const BTSDebugTraceLength traceLength) { _traceLength = traceLength; }
   inline void setTraceData(IN const BTSDebugTraceData& traceData) { _traceData = traceData; }

   inline BTSDebugTraceFilter getTraceType(void) const { return _traceType; }
   inline BTSDebugTraceDirection getTraceDirection(void) const { return _traceDirection; }
   inline BTSDebugTraceLength getTraceLength(void) const { return _traceLength; }
   inline void getTraceData(OUT BTSDebugTraceData& traceData) const { traceData = _traceData; }
   inline const BTSDebugTraceData& getTraceData(void) const { return _traceData; }
   inline BTSDebugTraceData& getTraceDataMutable(void) { return _traceData; }

private:
   BTSDebugTraceFilter _traceType; /**< parameter trace type */
   BTSDebugTraceDirection _traceDirection; /**< parameter trace direction */
   BTSDebugTraceLength _traceLength; /**< parameter trace length */
   BTSDebugTraceData _traceData; /**< parameter trace data */
};

/**
 *
 */
class Ipc2Bts_FatalError : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_FatalError();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_FatalError(IN const Ipc2Bts_FatalError& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_FatalError& operator=(IN const Ipc2Bts_FatalError& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_FatalError();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setErrLocation(IN const BTSFatalErrorLocation errLocation) { _errLocation = errLocation; }
   inline void setErrType(IN const BTSFatalErrorType errType) { _errType = errType; }

   inline BTSFatalErrorLocation getErrLocation(void) const { return _errLocation; }
   inline BTSFatalErrorType getErrType(void) const { return _errType; }

private:
   BTSFatalErrorLocation _errLocation; /**< parameter err location */
   BTSFatalErrorType _errType; /**< parameter err type */
};

/**
 *
 */
class Ipc2Bts_GeneralError : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GeneralError();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GeneralError(IN const Ipc2Bts_GeneralError& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GeneralError& operator=(IN const Ipc2Bts_GeneralError& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GeneralError();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }
   inline void setBinaryStatus(IN const BTSInternalOpcode binaryStatus) { _binaryStatus = binaryStatus; }
   inline void setOpcode(IN const BTSInternalOpcode opcode) { _opcode = opcode; }

   inline BTSStatusCode getStatus(void) const { return _status; }
   inline BTSInternalOpcode getBinaryStatus(void) const { return _binaryStatus; }
   inline BTSInternalOpcode getOpcode(void) const { return _opcode; }

private:
   BTSStatusCode _status; /**< parameter status */
   BTSInternalOpcode _binaryStatus; /**< parameter binary status */
   BTSInternalOpcode _opcode; /**< parameter opcode */
};

/**
 *
 */
class Ipc2Bts_ReportGeniviDebugTrace : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ReportGeniviDebugTrace();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ReportGeniviDebugTrace(IN const Ipc2Bts_ReportGeniviDebugTrace& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ReportGeniviDebugTrace& operator=(IN const Ipc2Bts_ReportGeniviDebugTrace& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ReportGeniviDebugTrace();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setErrFile(IN const BTSGeniviTraceNumber errFile) { _errFile = errFile; }
   inline void setErrLine(IN const BTSGeniviTraceNumber errLine) { _errLine = errLine; }
   inline void setLevel(IN const BTSGeniviTraceNumber level) { _level = level; }
   inline void setCategory(IN const BTSGeniviDebugTraceCategory category) { _category = category; }
   inline void setErrorCode(IN const BTSGeniviTraceNumber errorCode) { _errorCode = errorCode; }
   inline void setData(IN const BTSGeniviTraceData& data) { _data = data; }

   inline BTSGeniviTraceNumber getErrFile(void) const { return _errFile; }
   inline BTSGeniviTraceNumber getErrLine(void) const { return _errLine; }
   inline BTSGeniviTraceNumber getLevel(void) const { return _level; }
   inline BTSGeniviDebugTraceCategory getCategory(void) const { return _category; }
   inline BTSGeniviTraceNumber getErrorCode(void) const { return _errorCode; }
   inline void getData(OUT BTSGeniviTraceData& data) const { data = _data; }
   inline const BTSGeniviTraceData& getData(void) const { return _data; }
   inline BTSGeniviTraceData& getDataMutable(void) { return _data; }

private:
   BTSGeniviTraceNumber _errFile; /**< parameter err file */
   BTSGeniviTraceNumber _errLine; /**< parameter err line */
   BTSGeniviTraceNumber _level; /**< parameter level */
   BTSGeniviDebugTraceCategory _category; /**< parameter category */
   BTSGeniviTraceNumber _errorCode; /**< parameter error code */
   BTSGeniviTraceData _data; /**< parameter data */
};

/**
 *
 */
class Ipc2Bts_GeniviFatalError : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GeniviFatalError();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GeniviFatalError(IN const Ipc2Bts_GeniviFatalError& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GeniviFatalError& operator=(IN const Ipc2Bts_GeniviFatalError& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GeniviFatalError();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setErrFile(IN const BTSGeniviTraceNumber errFile) { _errFile = errFile; }
   inline void setErrLine(IN const BTSGeniviTraceNumber errLine) { _errLine = errLine; }
   inline void setErrCode(IN const BTSGeniviTraceNumber errCode) { _errCode = errCode; }
   inline void setFmt(IN const BTSGeniviTraceError& fmt) { _fmt = fmt; }
   inline void setErrValue(IN const BTSGeniviTraceError& errValue) { _errValue = errValue; }

   inline BTSGeniviTraceNumber getErrFile(void) const { return _errFile; }
   inline BTSGeniviTraceNumber getErrLine(void) const { return _errLine; }
   inline BTSGeniviTraceNumber getErrCode(void) const { return _errCode; }
   inline void getFmt(OUT BTSGeniviTraceError& fmt) const { fmt = _fmt; }
   inline const BTSGeniviTraceError& getFmt(void) const { return _fmt; }
   inline BTSGeniviTraceError& getFmtMutable(void) { return _fmt; }
   inline void getErrValue(OUT BTSGeniviTraceError& errValue) const { errValue = _errValue; }
   inline const BTSGeniviTraceError& getErrValue(void) const { return _errValue; }
   inline BTSGeniviTraceError& getErrValueMutable(void) { return _errValue; }

private:
   BTSGeniviTraceNumber _errFile; /**< parameter err file */
   BTSGeniviTraceNumber _errLine; /**< parameter err line */
   BTSGeniviTraceNumber _errCode; /**< parameter err code */
   BTSGeniviTraceError _fmt; /**< parameter fmt */
   BTSGeniviTraceError _errValue; /**< parameter err value */
};

/**
 *
 */
class Ipc2Bts_BtApplDidSetReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDidSetReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDidSetReqResult(IN const Ipc2Bts_BtApplDidSetReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDidSetReqResult& operator=(IN const Ipc2Bts_BtApplDidSetReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDidSetReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplDidSetCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplDidSetCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplDidSetCfm(IN const Ipc2Bts_BtApplDidSetCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplDidSetCfm& operator=(IN const Ipc2Bts_BtApplDidSetCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplDidSetCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_DunDeviceFilePathUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DunDeviceFilePathUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DunDeviceFilePathUpdate(IN const Ipc2Bts_DunDeviceFilePathUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DunDeviceFilePathUpdate& operator=(IN const Ipc2Bts_DunDeviceFilePathUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DunDeviceFilePathUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   BTSDeviceName _deviceName; /**< parameter device name */
};

/**
 *
 */
class Ipc2Bts_BtApplSppSetUuidReqResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplSppSetUuidReqResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplSppSetUuidReqResult(IN const Ipc2Bts_BtApplSppSetUuidReqResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplSppSetUuidReqResult& operator=(IN const Ipc2Bts_BtApplSppSetUuidReqResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplSppSetUuidReqResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_BtApplSppSetUuidCfm : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplSppSetUuidCfm();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplSppSetUuidCfm(IN const Ipc2Bts_BtApplSppSetUuidCfm& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplSppSetUuidCfm& operator=(IN const Ipc2Bts_BtApplSppSetUuidCfm& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplSppSetUuidCfm();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setStatus(IN const BTSStatusCode status) { _status = status; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline BTSStatusCode getStatus(void) const { return _status; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSStatusCode _status; /**< parameter status */
};

/**
 *
 */
class Ipc2Bts_BtApplSppVirtualDeviceInd : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_BtApplSppVirtualDeviceInd();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_BtApplSppVirtualDeviceInd(IN const Ipc2Bts_BtApplSppVirtualDeviceInd& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_BtApplSppVirtualDeviceInd& operator=(IN const Ipc2Bts_BtApplSppVirtualDeviceInd& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_BtApplSppVirtualDeviceInd();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInstance(IN const BTSInstanceIndex instance) { _instance = instance; }
   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }

   inline BTSInstanceIndex getInstance(void) const { return _instance; }
   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }

private:
   BTSInstanceIndex _instance; /**< parameter instance */
   BTSDeviceName _deviceName; /**< parameter device name */
};

/**
 *
 */
class Ipc2Bts_CreateSessionResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CreateSessionResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CreateSessionResult(IN const Ipc2Bts_CreateSessionResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CreateSessionResult& operator=(IN const Ipc2Bts_CreateSessionResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CreateSessionResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }
   inline void setSession(IN const BTSObjectPath& session) { _session = session; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }
   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
   BTSObjectPath _session; /**< parameter session */
};

/**
 *
 */
class Ipc2Bts_RemoveSessionResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RemoveSessionResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RemoveSessionResult(IN const Ipc2Bts_RemoveSessionResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RemoveSessionResult& operator=(IN const Ipc2Bts_RemoveSessionResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RemoveSessionResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
};

/**
 *
 */
class Ipc2Bts_CancelSessionResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CancelSessionResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CancelSessionResult(IN const Ipc2Bts_CancelSessionResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CancelSessionResult& operator=(IN const Ipc2Bts_CancelSessionResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CancelSessionResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
};

/**
 *
 */
class Ipc2Bts_SessionCreated : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SessionCreated();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SessionCreated(IN const Ipc2Bts_SessionCreated& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SessionCreated& operator=(IN const Ipc2Bts_SessionCreated& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SessionCreated();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSession(IN const BTSObjectPath& session) { _session = session; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }
   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }

   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }
   inline BTSProtocolId getProtocol(void) const { return _protocol; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _session; /**< parameter session */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
   BTSProtocolId _protocol; /**< parameter protocol */
};

/**
 *
 */
class Ipc2Bts_SessionRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SessionRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SessionRemoved(IN const Ipc2Bts_SessionRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SessionRemoved& operator=(IN const Ipc2Bts_SessionRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SessionRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setSession(IN const BTSObjectPath& session) { _session = session; }
   inline void setInstanceId(IN const BTSMasInstanceId instanceId) { _instanceId = instanceId; }
   inline void setProtocol(IN const BTSProtocolId protocol) { _protocol = protocol; }

   inline void getSession(OUT BTSObjectPath& session) const { session = _session; }
   inline const BTSObjectPath& getSession(void) const { return _session; }
   inline BTSObjectPath& getSessionMutable(void) { return _session; }
   inline BTSMasInstanceId getInstanceId(void) const { return _instanceId; }
   inline BTSProtocolId getProtocol(void) const { return _protocol; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _session; /**< parameter session */
   BTSMasInstanceId _instanceId; /**< parameter instance id */
   BTSProtocolId _protocol; /**< parameter protocol */
};

/**
 *
 */
class Ipc2Bts_AddTechnologyObjectPath : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddTechnologyObjectPath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddTechnologyObjectPath(IN const Ipc2Bts_AddTechnologyObjectPath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddTechnologyObjectPath& operator=(IN const Ipc2Bts_AddTechnologyObjectPath& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddTechnologyObjectPath();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelTechnologyObjectPath : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelTechnologyObjectPath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelTechnologyObjectPath(IN const Ipc2Bts_DelTechnologyObjectPath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelTechnologyObjectPath& operator=(IN const Ipc2Bts_DelTechnologyObjectPath& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelTechnologyObjectPath();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_AddNetworkObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddNetworkObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddNetworkObjectPathMapping(IN const Ipc2Bts_AddNetworkObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddNetworkObjectPathMapping& operator=(IN const Ipc2Bts_AddNetworkObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddNetworkObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelNetworkObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelNetworkObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelNetworkObjectPathMapping(IN const Ipc2Bts_DelNetworkObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelNetworkObjectPathMapping& operator=(IN const Ipc2Bts_DelNetworkObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelNetworkObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_GetConnManManagerPropertiesResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetConnManManagerPropertiesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetConnManManagerPropertiesResult(IN const Ipc2Bts_GetConnManManagerPropertiesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetConnManManagerPropertiesResult& operator=(IN const Ipc2Bts_GetConnManManagerPropertiesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetConnManManagerPropertiesResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProperties(IN const ConnManManagerProperty& properties) { _properties = properties; }

   inline void getProperties(OUT ConnManManagerProperty& properties) const { properties = _properties; }
   inline const ConnManManagerProperty& getProperties(void) const { return _properties; }
   inline ConnManManagerProperty& getPropertiesMutable(void) { return _properties; }

private:
   ConnManManagerProperty _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_GetConnManTechnologiesResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetConnManTechnologiesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetConnManTechnologiesResult(IN const Ipc2Bts_GetConnManTechnologiesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetConnManTechnologiesResult& operator=(IN const Ipc2Bts_GetConnManTechnologiesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetConnManTechnologiesResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setTechnologies(IN const ConnManTechnologyList& technologies) { _technologies = technologies; }

   inline void getTechnologies(OUT ConnManTechnologyList& technologies) const { technologies = _technologies; }
   inline const ConnManTechnologyList& getTechnologies(void) const { return _technologies; }
   inline ConnManTechnologyList& getTechnologiesMutable(void) { return _technologies; }

private:
   ConnManTechnologyList _technologies; /**< parameter technologies */
};

/**
 *
 */
class Ipc2Bts_GetConnManServicesResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetConnManServicesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetConnManServicesResult(IN const Ipc2Bts_GetConnManServicesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetConnManServicesResult& operator=(IN const Ipc2Bts_GetConnManServicesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetConnManServicesResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServices(IN const ConnManServiceList& services) { _services = services; }

   inline void getServices(OUT ConnManServiceList& services) const { services = _services; }
   inline const ConnManServiceList& getServices(void) const { return _services; }
   inline ConnManServiceList& getServicesMutable(void) { return _services; }

private:
   ConnManServiceList _services; /**< parameter services */
};

/**
 *
 */
class Ipc2Bts_ConnManTechnologyAdded : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManTechnologyAdded();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManTechnologyAdded(IN const Ipc2Bts_ConnManTechnologyAdded& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManTechnologyAdded& operator=(IN const Ipc2Bts_ConnManTechnologyAdded& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManTechnologyAdded();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPath(IN const BTSObjectPath& path) { _path = path; }
   inline void setProperties(IN const ConnManTechnologyProperty& properties) { _properties = properties; }

   inline void getPath(OUT BTSObjectPath& path) const { path = _path; }
   inline const BTSObjectPath& getPath(void) const { return _path; }
   inline BTSObjectPath& getPathMutable(void) { return _path; }
   inline void getProperties(OUT ConnManTechnologyProperty& properties) const { properties = _properties; }
   inline const ConnManTechnologyProperty& getProperties(void) const { return _properties; }
   inline ConnManTechnologyProperty& getPropertiesMutable(void) { return _properties; }

private:
   BTSObjectPath _path; /**< parameter path */
   ConnManTechnologyProperty _properties; /**< parameter properties */
};

/**
 *
 */
class Ipc2Bts_ConnManTechnologyRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManTechnologyRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManTechnologyRemoved(IN const Ipc2Bts_ConnManTechnologyRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManTechnologyRemoved& operator=(IN const Ipc2Bts_ConnManTechnologyRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManTechnologyRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setPath(IN const BTSObjectPath& path) { _path = path; }

   inline void getPath(OUT BTSObjectPath& path) const { path = _path; }
   inline const BTSObjectPath& getPath(void) const { return _path; }
   inline BTSObjectPath& getPathMutable(void) { return _path; }

private:
   BTSObjectPath _path; /**< parameter path */
};

/**
 *
 */
class Ipc2Bts_ConnManServicesChanged : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServicesChanged();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServicesChanged(IN const Ipc2Bts_ConnManServicesChanged& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServicesChanged& operator=(IN const Ipc2Bts_ConnManServicesChanged& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServicesChanged();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServices(IN const ConnManServiceList& services) { _services = services; }

   inline void getServices(OUT ConnManServiceList& services) const { services = _services; }
   inline const ConnManServiceList& getServices(void) const { return _services; }
   inline ConnManServiceList& getServicesMutable(void) { return _services; }

private:
   ConnManServiceList _services; /**< parameter services */
};

/**
 *
 */
class Ipc2Bts_ConnManServicesRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServicesRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServicesRemoved(IN const Ipc2Bts_ConnManServicesRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServicesRemoved& operator=(IN const Ipc2Bts_ConnManServicesRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServicesRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setServices(IN const BTSObjectPathList& services) { _services = services; }

   inline void getServices(OUT BTSObjectPathList& services) const { services = _services; }
   inline const BTSObjectPathList& getServices(void) const { return _services; }
   inline BTSObjectPathList& getServicesMutable(void) { return _services; }

private:
   BTSObjectPathList _services; /**< parameter services */
};

/**
 *
 */
class Ipc2Bts_GetConnManServicePropertiesResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_GetConnManServicePropertiesResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_GetConnManServicePropertiesResult(IN const Ipc2Bts_GetConnManServicePropertiesResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_GetConnManServicePropertiesResult& operator=(IN const Ipc2Bts_GetConnManServicePropertiesResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_GetConnManServicePropertiesResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setProperties(IN const ConnManServiceProperty& properties) { _properties = properties; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getProperties(OUT ConnManServiceProperty& properties) const { properties = _properties; }
   inline const ConnManServiceProperty& getProperties(void) const { return _properties; }
   inline ConnManServiceProperty& getPropertiesMutable(void) { return _properties; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   ConnManServiceProperty _properties; /**< parameter properties */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_ConnManServiceConnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServiceConnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServiceConnectResult(IN const Ipc2Bts_ConnManServiceConnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServiceConnectResult& operator=(IN const Ipc2Bts_ConnManServiceConnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServiceConnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_ConnManServiceDisconnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServiceDisconnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServiceDisconnectResult(IN const Ipc2Bts_ConnManServiceDisconnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServiceDisconnectResult& operator=(IN const Ipc2Bts_ConnManServiceDisconnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServiceDisconnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_ConnManServiceStateUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServiceStateUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServiceStateUpdate(IN const Ipc2Bts_ConnManServiceStateUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServiceStateUpdate& operator=(IN const Ipc2Bts_ConnManServiceStateUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServiceStateUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setValue(IN const ::ccdbusif::connman::ServiceState value) { _value = value; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline ::ccdbusif::connman::ServiceState getValue(void) const { return _value; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   ::ccdbusif::connman::ServiceState _value; /**< parameter value */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_ConnManServiceInterfaceUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_ConnManServiceInterfaceUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_ConnManServiceInterfaceUpdate(IN const Ipc2Bts_ConnManServiceInterfaceUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_ConnManServiceInterfaceUpdate& operator=(IN const Ipc2Bts_ConnManServiceInterfaceUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_ConnManServiceInterfaceUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setInterface(IN const BTSDeviceName& interface) { _interface = interface; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getInterface(OUT BTSDeviceName& interface) const { interface = _interface; }
   inline const BTSDeviceName& getInterface(void) const { return _interface; }
   inline BTSDeviceName& getInterfaceMutable(void) { return _interface; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSDeviceName _interface; /**< parameter interface */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SerialDeviceFilePath : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SerialDeviceFilePath();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SerialDeviceFilePath(IN const Ipc2Bts_SerialDeviceFilePath& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SerialDeviceFilePath& operator=(IN const Ipc2Bts_SerialDeviceFilePath& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SerialDeviceFilePath();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }
   inline void setService(IN const BTSObjectPath& service) { _service = service; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }
   inline void getService(OUT BTSObjectPath& service) const { service = _service; }
   inline const BTSObjectPath& getService(void) const { return _service; }
   inline BTSObjectPath& getServiceMutable(void) { return _service; }

private:
   BTSDeviceName _deviceName; /**< parameter device name */
   BTSObjectPath _service; /**< parameter service */
};

/**
 *
 */
class Ipc2Bts_CharacterDeviceAddedRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CharacterDeviceAddedRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CharacterDeviceAddedRemoved(IN const Ipc2Bts_CharacterDeviceAddedRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CharacterDeviceAddedRemoved& operator=(IN const Ipc2Bts_CharacterDeviceAddedRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CharacterDeviceAddedRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& deviceName) { _deviceName = deviceName; }
   inline void setAdded(IN const bool added) { _added = added; }

   inline void getDeviceName(OUT BTSDeviceName& deviceName) const { deviceName = _deviceName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _deviceName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _deviceName; }
   inline bool getAdded(void) const { return _added; }

private:
   BTSDeviceName _deviceName; /**< parameter device name */
   bool _added; /**< parameter added */
};

/**
 *
 */
class Ipc2Bts_CreateLeDeviceResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_CreateLeDeviceResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_CreateLeDeviceResult(IN const Ipc2Bts_CreateLeDeviceResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_CreateLeDeviceResult& operator=(IN const Ipc2Bts_CreateLeDeviceResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_CreateLeDeviceResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_RemoveLeDeviceResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_RemoveLeDeviceResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_RemoveLeDeviceResult(IN const Ipc2Bts_RemoveLeDeviceResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_RemoveLeDeviceResult& operator=(IN const Ipc2Bts_RemoveLeDeviceResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_RemoveLeDeviceResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_LeAdapterInitialization : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterInitialization();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterInitialization(IN const Ipc2Bts_LeAdapterInitialization& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterInitialization& operator=(IN const Ipc2Bts_LeAdapterInitialization& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterInitialization();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class Ipc2Bts_LeDeviceCreated : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceCreated();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceCreated(IN const Ipc2Bts_LeDeviceCreated& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceCreated& operator=(IN const Ipc2Bts_LeDeviceCreated& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceCreated();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeDeviceRemoved : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceRemoved();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceRemoved(IN const Ipc2Bts_LeDeviceRemoved& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceRemoved& operator=(IN const Ipc2Bts_LeDeviceRemoved& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceRemoved();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeAdapterAddressTypeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAddressTypeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAddressTypeUpdate(IN const Ipc2Bts_LeAdapterAddressTypeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAddressTypeUpdate& operator=(IN const Ipc2Bts_LeAdapterAddressTypeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAddressTypeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAddressType(IN const BTSBLEDeviceAddressType addressType) { _addressType = addressType; }

   inline BTSBLEDeviceAddressType getAddressType(void) const { return _addressType; }

private:
   BTSBLEDeviceAddressType _addressType; /**< parameter address type */
};

/**
 *
 */
class Ipc2Bts_LeAdapterAddressUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAddressUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAddressUpdate(IN const Ipc2Bts_LeAdapterAddressUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAddressUpdate& operator=(IN const Ipc2Bts_LeAdapterAddressUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAddressUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
};

/**
 *
 */
class Ipc2Bts_LeAdapterAliasUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAliasUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAliasUpdate(IN const Ipc2Bts_LeAdapterAliasUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAliasUpdate& operator=(IN const Ipc2Bts_LeAdapterAliasUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAliasUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAlias(IN const BTSDeviceName& alias) { _alias = alias; }

   inline void getAlias(OUT BTSDeviceName& alias) const { alias = _alias; }
   inline const BTSDeviceName& getAlias(void) const { return _alias; }
   inline BTSDeviceName& getAliasMutable(void) { return _alias; }

private:
   BTSDeviceName _alias; /**< parameter alias */
};

/**
 *
 */
class Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate(IN const Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& operator=(IN const Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAdvertisingTimeout(IN const BTSBLEAdvertisingTimeout advertisingTimeout) { _advertisingTimeout = advertisingTimeout; }

   inline BTSBLEAdvertisingTimeout getAdvertisingTimeout(void) const { return _advertisingTimeout; }

private:
   BTSBLEAdvertisingTimeout _advertisingTimeout; /**< parameter advertising timeout */
};

/**
 *
 */
class Ipc2Bts_LeAdapterDiscoverableModeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterDiscoverableModeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterDiscoverableModeUpdate(IN const Ipc2Bts_LeAdapterDiscoverableModeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterDiscoverableModeUpdate& operator=(IN const Ipc2Bts_LeAdapterDiscoverableModeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterDiscoverableModeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDiscoverableMode(IN const BTSBLEDiscoverableMode discoverableMode) { _discoverableMode = discoverableMode; }

   inline BTSBLEDiscoverableMode getDiscoverableMode(void) const { return _discoverableMode; }

private:
   BTSBLEDiscoverableMode _discoverableMode; /**< parameter discoverable mode */
};

/**
 *
 */
class Ipc2Bts_LeAdapterAdvertisingDataUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAdvertisingDataUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAdvertisingDataUpdate(IN const Ipc2Bts_LeAdapterAdvertisingDataUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAdvertisingDataUpdate& operator=(IN const Ipc2Bts_LeAdapterAdvertisingDataUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAdvertisingDataUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAdvertisingData(IN const BTSBLEAdvertisingData& advertisingData) { _advertisingData = advertisingData; }

   inline void getAdvertisingData(OUT BTSBLEAdvertisingData& advertisingData) const { advertisingData = _advertisingData; }
   inline const BTSBLEAdvertisingData& getAdvertisingData(void) const { return _advertisingData; }
   inline BTSBLEAdvertisingData& getAdvertisingDataMutable(void) { return _advertisingData; }

private:
   BTSBLEAdvertisingData _advertisingData; /**< parameter advertising data */
};

/**
 *
 */
class Ipc2Bts_LeAdapterAdvertiseEnableUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeAdapterAdvertiseEnableUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeAdapterAdvertiseEnableUpdate(IN const Ipc2Bts_LeAdapterAdvertiseEnableUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeAdapterAdvertiseEnableUpdate& operator=(IN const Ipc2Bts_LeAdapterAdvertiseEnableUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeAdapterAdvertiseEnableUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAdvertiseEnable(IN const bool advertiseEnable) { _advertiseEnable = advertiseEnable; }

   inline bool getAdvertiseEnable(void) const { return _advertiseEnable; }

private:
   bool _advertiseEnable; /**< parameter advertise enable */
};

/**
 *
 */
class Ipc2Bts_AddLeDeviceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_AddLeDeviceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_AddLeDeviceObjectPathMapping(IN const Ipc2Bts_AddLeDeviceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_AddLeDeviceObjectPathMapping& operator=(IN const Ipc2Bts_AddLeDeviceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_AddLeDeviceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_DelLeDeviceObjectPathMapping : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_DelLeDeviceObjectPathMapping();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_DelLeDeviceObjectPathMapping(IN const Ipc2Bts_DelLeDeviceObjectPathMapping& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_DelLeDeviceObjectPathMapping& operator=(IN const Ipc2Bts_DelLeDeviceObjectPathMapping& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_DelLeDeviceObjectPathMapping();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Ipc2Bts_LeDeviceDisconnectResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceDisconnectResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceDisconnectResult(IN const Ipc2Bts_LeDeviceDisconnectResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceDisconnectResult& operator=(IN const Ipc2Bts_LeDeviceDisconnectResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceDisconnectResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeDisconnectionComp : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDisconnectionComp();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDisconnectionComp(IN const Ipc2Bts_LeDisconnectionComp& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDisconnectionComp& operator=(IN const Ipc2Bts_LeDisconnectionComp& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDisconnectionComp();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSBLEStatus status) { _status = status; }
   inline void setReason(IN const BTSBtApplDisconnectReason reason) { _reason = reason; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSBLEStatus getStatus(void) const { return _status; }
   inline BTSBtApplDisconnectReason getReason(void) const { return _reason; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSBLEStatus _status; /**< parameter status */
   BTSBtApplDisconnectReason _reason; /**< parameter reason */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeDeviceAddressTypeUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceAddressTypeUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceAddressTypeUpdate(IN const Ipc2Bts_LeDeviceAddressTypeUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceAddressTypeUpdate& operator=(IN const Ipc2Bts_LeDeviceAddressTypeUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceAddressTypeUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setAddressType(IN const BTSBLEDeviceAddressType addressType) { _addressType = addressType; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSBLEDeviceAddressType getAddressType(void) const { return _addressType; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSBLEDeviceAddressType _addressType; /**< parameter address type */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeDeviceAddressUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceAddressUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceAddressUpdate(IN const Ipc2Bts_LeDeviceAddressUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceAddressUpdate& operator=(IN const Ipc2Bts_LeDeviceAddressUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceAddressUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_LeDeviceConnectedUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_LeDeviceConnectedUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_LeDeviceConnectedUpdate(IN const Ipc2Bts_LeDeviceConnectedUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_LeDeviceConnectedUpdate& operator=(IN const Ipc2Bts_LeDeviceConnectedUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_LeDeviceConnectedUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setConnected(IN const bool connected) { _connected = connected; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline bool getConnected(void) const { return _connected; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   bool _connected; /**< parameter connected */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SendSeamlessPairingErrorCodeResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SendSeamlessPairingErrorCodeResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SendSeamlessPairingErrorCodeResult(IN const Ipc2Bts_SendSeamlessPairingErrorCodeResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SendSeamlessPairingErrorCodeResult& operator=(IN const Ipc2Bts_SendSeamlessPairingErrorCodeResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SendSeamlessPairingErrorCodeResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SeamlessPairingAllowAccessResult : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SeamlessPairingAllowAccessResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SeamlessPairingAllowAccessResult(IN const Ipc2Bts_SeamlessPairingAllowAccessResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SeamlessPairingAllowAccessResult& operator=(IN const Ipc2Bts_SeamlessPairingAllowAccessResult& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SeamlessPairingAllowAccessResult();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SeamlessPairingErrorCodeReceived : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SeamlessPairingErrorCodeReceived();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SeamlessPairingErrorCodeReceived(IN const Ipc2Bts_SeamlessPairingErrorCodeReceived& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SeamlessPairingErrorCodeReceived& operator=(IN const Ipc2Bts_SeamlessPairingErrorCodeReceived& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SeamlessPairingErrorCodeReceived();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setStatus(IN const BTSBLEStatus status) { _status = status; }
   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline BTSBLEStatus getStatus(void) const { return _status; }
   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSBLEStatus _status; /**< parameter status */
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SeamlessPairingAccessRequest : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SeamlessPairingAccessRequest();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SeamlessPairingAccessRequest(IN const Ipc2Bts_SeamlessPairingAccessRequest& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SeamlessPairingAccessRequest& operator=(IN const Ipc2Bts_SeamlessPairingAccessRequest& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SeamlessPairingAccessRequest();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }

private:
   BTSObjectPath _device; /**< parameter device */
};

/**
 *
 */
class Ipc2Bts_SeamlessPairingPairingDataUpdate : public Ipc2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Ipc2Bts_SeamlessPairingPairingDataUpdate();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Ipc2Bts_SeamlessPairingPairingDataUpdate(IN const Ipc2Bts_SeamlessPairingPairingDataUpdate& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Ipc2Bts_SeamlessPairingPairingDataUpdate& operator=(IN const Ipc2Bts_SeamlessPairingPairingDataUpdate& ref);

   /**
    * Destructor.
    */
   virtual ~Ipc2Bts_SeamlessPairingPairingDataUpdate();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Ipc2Bts_BaseMessage* clone(void) const;

   inline void setDevice(IN const BTSObjectPath& device) { _device = device; }
   inline void setPairingData(IN const BTSBLEPairingData& pairingData) { _pairingData = pairingData; }

   inline void getDevice(OUT BTSObjectPath& device) const { device = _device; }
   inline const BTSObjectPath& getDevice(void) const { return _device; }
   inline BTSObjectPath& getDeviceMutable(void) { return _device; }
   inline void getPairingData(OUT BTSBLEPairingData& pairingData) const { pairingData = _pairingData; }
   inline const BTSBLEPairingData& getPairingData(void) const { return _pairingData; }
   inline BTSBLEPairingData& getPairingDataMutable(void) { return _pairingData; }

private:
   BTSObjectPath _device; /**< parameter device */
   BTSBLEPairingData _pairingData; /**< parameter pairing data */
};

} //genivi
} //btstackif

#endif //_IPC_2_BTS_CONNECTION_MSG_GENIVI_H_
