/**
 * @file PropertiesGetAllDbusFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for PropertiesGetAll.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for PropertiesGetAll.
 */

#include "PropertiesGetAllDbusFactory.h"
#include "PropertiesGetAllDbusCallbackIf.h"

namespace btstackif {
namespace genivi {

PropertiesGetAllDbusFactory::PropertiesGetAllDbusFactory() :
_createdLocally(true),
_cb(0)
{
}

PropertiesGetAllDbusFactory::~PropertiesGetAllDbusFactory()
{
   _cb = 0;
}

PropertiesGetAllDbusFactory& PropertiesGetAllDbusFactory::getInstance(void)
{
   static PropertiesGetAllDbusFactory factory;
   return factory;
}

PropertiesGetAllDbusCallbackIf* PropertiesGetAllDbusFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new PropertiesGetAllDbusCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void PropertiesGetAllDbusFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void PropertiesGetAllDbusFactory::setCbForTesting(PropertiesGetAllDbusCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
