/**
 * @file PropertiesGetAllDbusCallbackIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief PropertiesGetAll DBUS Callback implementation.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details PropertiesGetAll DBUS callback implementation.
 */

#include "PropertiesGetAllDbusCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"
#include "cc_dbus_if/EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_DBUS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PropertiesGetAllDbusCallbackIf.cpp.trc.h"
#endif
#endif

using namespace ::getall::org::freedesktop::DBus::Properties;

using namespace ::asf::core;

namespace btstackif {
namespace genivi {

PropertiesGetAllDbusCallbackIf::PropertiesGetAllDbusCallbackIf()
{
}

PropertiesGetAllDbusCallbackIf::PropertiesGetAllDbusCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

PropertiesGetAllDbusCallbackIf::~PropertiesGetAllDbusCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void PropertiesGetAllDbusCallbackIf::onPropertiesGetAllProxyAvailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState)
{
   (void)(user);
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_PROPERTIES_GET_ALL);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
      ptrMsg->setBusType(busType);
      ptrMsg->setBusName(busName);
      ptrMsg->setObjPath(objPath);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void PropertiesGetAllDbusCallbackIf::onPropertiesGetAllProxyUnavailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState)
{
   (void)(user);
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_PROPERTIES_GET_ALL);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
      ptrMsg->setBusType(busType);
      ptrMsg->setBusName(busName);
      ptrMsg->setObjPath(objPath);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// TODO: complete rework is needed; object path has to be set for all messages

void PropertiesGetAllDbusCallbackIf::onGetAllError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllError >& error)
{
   (void)(proxy);

   Ipc2Bts_GetAllPropertiesConnection* ptrMsg = ptrNew_Ipc2Bts_GetAllPropertiesConnection();

   if(NULL != ptrMsg)
   {
      // ptrMsg->setInterface(); --- is done later
   }

   onError(ptrMsg, error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void PropertiesGetAllDbusCallbackIf::onGetAllResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllResponse >& response)
{
   // HINT: proxy object delivers following data:
   //    const std::string& getDBusBusName() const;
   //    const std::string& getDBusObjectPath() const;
   //    const std::string& getInterfaceName() const;
   //    TODO: ASF 1.25.0-rc1 --- ::DBusBusType getBusType() const;

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   BTSDbusPropertyList ifProperties;
   ::std::vector<int> matchingInterfaces;

   matchingInterfaces.push_back((int)::ccdbusif::evolution::IF_ADAPTER); // TODO: we need another way to bring the interface name to here
   parser.setTraces(true);
   parser.parseProperties(ifProperties, matchingInterfaces, response->getPropertiesMutable(), ::ccdbusif::BUS_TYPE_SYSTEM /*TODO: ASF 1.25.0-rc1 --- proxy->getBusType()*/, proxy->getDBusBusName(), proxy->getDBusObjectPath(), proxy->getInterfaceName());

   Ipc2Bts_GetAllPropertiesConnection* ptrMsg = ptrNew_Ipc2Bts_GetAllPropertiesConnection();

   if(NULL != ptrMsg)
   {
      // ptrMsg->setInterface(); --- is done later
      ptrMsg->setProperties(ifProperties);
   }

   onResponse(ptrMsg, response->getAct());
}

#if 0
https://code.google.com/p/android-source-browsing/source/browse/tools/dbus-print-message.c?repo=platform--external--dbus&r=ade5c7ad33484a8b8f7c11591d4e80a83e7ff369
#endif

} //genivi
} //btstackif
