/**
 * @file EvolutionGeniviDbusObexSessionCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexSession.
 */

#include "EvolutionGeniviDbusObexSessionCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"

using namespace ::org::bluez::obex::Session;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusObexSessionCallbackIf::EvolutionGeniviDbusObexSessionCallbackIf()
{
}

EvolutionGeniviDbusObexSessionCallbackIf::EvolutionGeniviDbusObexSessionCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusObexSessionCallbackIf::~EvolutionGeniviDbusObexSessionCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusObexSessionCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}

void EvolutionGeniviDbusObexSessionCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/obex/SessionProxy implementation --- start
void EvolutionGeniviDbusObexSessionCallbackIf::onSourceError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onSourceUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onDestinationError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onDestinationUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onChannelError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onChannelUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onTargetError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusObexSessionCallbackIf::onTargetUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetUpdate >& update)
{
   (void)(proxy);
   (void)(update);
}
// org/bluez/obex/SessionProxy implementation --- end

} //genivi
} //btstackif
