/**
 * @file EvolutionGeniviDbusObexClientFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for ObexClient.
 */

#include "EvolutionGeniviDbusObexClientFactory.h"
#include "EvolutionGeniviDbusObexClientCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusObexClientFactory::EvolutionGeniviDbusObexClientFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusObexClientFactory::~EvolutionGeniviDbusObexClientFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusObexClientFactory& EvolutionGeniviDbusObexClientFactory::getInstance(void)
{
   static EvolutionGeniviDbusObexClientFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusObexClientCallbackIf* EvolutionGeniviDbusObexClientFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusObexClientCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusObexClientFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusObexClientFactory::setCbForTesting(EvolutionGeniviDbusObexClientCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
